/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.CreeperMinionEggModel;
import fuzs.mutantmonsters.client.renderer.ModRenderType;
import fuzs.mutantmonsters.client.renderer.entity.layers.PowerableLayer;
import fuzs.mutantmonsters.client.renderer.entity.state.CreeperMinionEggRenderState;
import fuzs.mutantmonsters.world.entity.CreeperMinionEgg;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;

public class CreeperMinionEggRenderer
extends EntityRenderer<CreeperMinionEgg, CreeperMinionEggRenderState> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/creeper_minion_egg.png");
    private final CreeperMinionEggModel model;
    private final CreeperMinionEggModel armorModel;

    public CreeperMinionEggRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new CreeperMinionEggModel(context.bakeLayer(ModelLayerLocations.CREEPER_MINION_EGG));
        this.armorModel = new CreeperMinionEggModel(context.bakeLayer(ModelLayerLocations.CREEPER_MINION_EGG_ARMOR));
        this.shadowRadius = 0.4f;
    }

    public void render(CreeperMinionEggRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        poseStack.translate(0.0f, -1.5f, 0.0f);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(this.model.renderType(TEXTURE_LOCATION));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        if (renderState.isCharged) {
            this.renderArmor(renderState, poseStack, bufferSource, packedLight);
        }
        poseStack.popPose();
    }

    protected void renderArmor(CreeperMinionEggRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        RenderType renderType = ModRenderType.energySwirl(PowerableLayer.LIGHTNING_TEXTURE, renderState.ageInTicks * 0.01f, renderState.ageInTicks * 0.01f);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        int color = ARGB.colorFromFloat((float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
        this.armorModel.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
    }

    public void extractRenderState(CreeperMinionEgg entity, CreeperMinionEggRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.isCharged = entity.isCharged();
    }

    public CreeperMinionEggRenderState createRenderState() {
        return new CreeperMinionEggRenderState();
    }
}

