/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.CreeperMinionModel;
import fuzs.mutantmonsters.client.renderer.entity.layers.PowerableLayer;
import fuzs.mutantmonsters.client.renderer.entity.state.CreeperMinionRenderState;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.CreeperRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class CreeperMinionRenderer
extends MobRenderer<CreeperMinion, CreeperRenderState, CreeperMinionModel> {
    public static final ResourceLocation TEXTURE_LOCATION = ResourceLocationHelper.withDefaultNamespace((String)"textures/entity/creeper/creeper.png");

    public CreeperMinionRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CreeperMinionModel(context.bakeLayer(ModelLayerLocations.CREEPER_MINION)), 0.25f);
        this.addLayer((RenderLayer)new PowerableLayer(this, new CreeperMinionModel(context.bakeLayer(ModelLayerLocations.CREEPER_MINION_ARMOR))));
    }

    public void extractRenderState(CreeperMinion entity, CreeperRenderState reusedState, float partialTick) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)reusedState, partialTick);
        reusedState.swelling = entity.getSwelling(partialTick);
        reusedState.isPowered = entity.isCharged();
        ((CreeperMinionRenderState)reusedState).inSittingPose = entity.isInSittingPose();
    }

    public CreeperRenderState createRenderState() {
        return new CreeperMinionRenderState();
    }

    protected float getWhiteOverlayProgress(CreeperRenderState renderState) {
        float flashIntensity = renderState.swelling;
        return (int)(flashIntensity * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)flashIntensity, (float)0.5f, (float)1.0f);
    }

    protected void scale(CreeperRenderState renderState, PoseStack poseStack) {
        float flashIntensity = renderState.swelling;
        float f1 = 1.0f + Mth.sin((float)(flashIntensity * 100.0f)) * flashIntensity * 0.01f;
        flashIntensity = Mth.clamp((float)flashIntensity, (float)0.0f, (float)1.0f);
        flashIntensity *= flashIntensity;
        flashIntensity *= flashIntensity;
        float f2 = (1.0f + flashIntensity * 0.4f) * f1;
        float f3 = (1.0f + flashIntensity * 0.1f) / f1;
        poseStack.scale(f2, f3, f2);
    }

    public ResourceLocation getTextureLocation(CreeperRenderState renderState) {
        return TEXTURE_LOCATION;
    }
}

