/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.renderer.ModRenderType;
import fuzs.mutantmonsters.client.renderer.entity.state.EndersoulCloneRenderState;
import fuzs.mutantmonsters.world.entity.EndersoulClone;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class EndersoulCloneRenderer
extends MobRenderer<EndersoulClone, EndersoulCloneRenderState, EndermanModel<EndersoulCloneRenderState>> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/endersoul.png");

    public EndersoulCloneRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new EndermanModel(context.bakeLayer(ModelLayerLocations.ENDERSOUL_CLONE)), 0.5f);
        this.shadowStrength = 0.5f;
    }

    public void extractRenderState(EndersoulClone entity, EndersoulCloneRenderState reusedState, float partialTick) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)reusedState, partialTick);
        HumanoidMobRenderer.extractHumanoidRenderState((LivingEntity)entity, (HumanoidRenderState)reusedState, (float)partialTick, (ItemModelResolver)this.itemModelResolver);
        reusedState.isCreepy = entity.isAggressive();
        reusedState.renderOffset = new Vec3(entity.getRandom().nextGaussian() * 0.02, 0.0, entity.getRandom().nextGaussian() * 0.02);
    }

    public EndersoulCloneRenderState createRenderState() {
        return new EndersoulCloneRenderState();
    }

    public Vec3 getRenderOffset(EndersoulCloneRenderState renderState) {
        return renderState.isCreepy ? renderState.renderOffset : super.getRenderOffset((EntityRenderState)renderState);
    }

    protected RenderType getRenderType(EndersoulCloneRenderState renderState, boolean bodyVisible, boolean translucent, boolean glowing) {
        return ModRenderType.energySwirl(this.getTextureLocation(renderState), renderState.ageInTicks * 0.008f, renderState.ageInTicks * 0.008f);
    }

    protected float getFlipDegrees() {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(EndersoulCloneRenderState renderState) {
        return TEXTURE_LOCATION;
    }

    protected int getModelTint(EndersoulCloneRenderState renderState) {
        return ARGB.colorFromFloat((float)1.0f, (float)0.9f, (float)0.3f, (float)1.0f);
    }
}

