/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.EndersoulFragmentModel;
import fuzs.mutantmonsters.client.renderer.ModRenderType;
import fuzs.mutantmonsters.client.renderer.entity.state.EndersoulFragmentRenderState;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import java.util.Arrays;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;

public class EndersoulFragmentRenderer
extends EntityRenderer<EndersoulFragment, EndersoulFragmentRenderState> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/endersoul_fragment.png");
    private final EndersoulFragmentModel model;

    public EndersoulFragmentRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new EndersoulFragmentModel(context.bakeLayer(ModelLayerLocations.ENDERSOUL_FRAGMENT));
        this.shadowRadius = 0.3f;
        this.shadowStrength = 0.5f;
    }

    public void extractRenderState(EndersoulFragment entity, EndersoulFragmentRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.stickRotations = (float[][])Arrays.stream(entity.stickRotations).map(array -> Arrays.copyOf(array, ((float[])array).length)).toArray(x$0 -> new float[x$0][]);
    }

    public void render(EndersoulFragmentRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
        poseStack.pushPose();
        poseStack.translate(0.0f, -1.9f, 0.0f);
        poseStack.scale(1.6f, 1.6f, 1.6f);
        this.model.setupAnim(renderState);
        RenderType renderType = ModRenderType.energySwirl(TEXTURE_LOCATION, renderState.ageInTicks * 0.008f, renderState.ageInTicks * 0.008f);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        int color = ARGB.colorFromFloat((float)1.0f, (float)0.9f, (float)0.3f, (float)1.0f);
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        poseStack.popPose();
    }

    public EndersoulFragmentRenderState createRenderState() {
        return new EndersoulFragmentRenderState();
    }
}

