/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.MutantArrowModel;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantArrowRenderState;
import fuzs.mutantmonsters.world.entity.projectile.MutantArrow;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class MutantArrowRenderer
extends EntityRenderer<MutantArrow, MutantArrowRenderState> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_arrow.png");
    private final MutantArrowModel model;

    public MutantArrowRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new MutantArrowModel(context.bakeLayer(ModelLayerLocations.MUTANT_ARROW));
    }

    public boolean shouldRender(MutantArrow mutantArrow, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void extractRenderState(MutantArrow entity, MutantArrowRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.xRot = entity.getXRot(partialTick);
        reusedState.yRot = entity.getYRot(partialTick);
        reusedState.clones = entity.getClones();
        reusedState.deltaMovement = entity.getDeltaMovement();
    }

    public MutantArrowRenderState createRenderState() {
        return new MutantArrowRenderState();
    }

    public void render(MutantArrowRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
        for (int i = 0; i < renderState.clones; ++i) {
            poseStack.pushPose();
            poseStack.translate(0.0f, -2.35f, 0.5f);
            Vec3 deltaMovement = renderState.deltaMovement.scale(-0.1).multiply((double)i, (double)i, (double)i);
            poseStack.translate(deltaMovement.x, deltaMovement.y, deltaMovement.z);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.xRot));
            poseStack.scale(1.2f, 1.2f, 1.2f);
            VertexConsumer vertexConsumer = bufferSource.getBuffer(this.model.renderType(TEXTURE_LOCATION));
            int color = ARGB.colorFromFloat((float)(1.0f - (float)i * 0.08f), (float)1.0f, (float)1.0f, (float)1.0f);
            this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
            poseStack.popPose();
        }
    }
}

