/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.MutantCreeperModel;
import fuzs.mutantmonsters.client.renderer.entity.layers.PowerableLayer;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantCreeperRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class MutantCreeperRenderer
extends MobRenderer<MutantCreeper, MutantCreeperRenderState, MutantCreeperModel> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_creeper.png");

    public MutantCreeperRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MutantCreeperModel(context.bakeLayer(ModelLayerLocations.MUTANT_CREEPER)), 1.5f);
        this.addLayer((RenderLayer)new PowerableLayer(this, new MutantCreeperModel(context.bakeLayer(ModelLayerLocations.MUTANT_CREEPER_ARMOR))));
    }

    public void extractRenderState(MutantCreeper entity, MutantCreeperRenderState reusedState, float partialTick) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)reusedState, partialTick);
        reusedState.attackTime = entity.getAttackAnim(partialTick);
        reusedState.isJumpAttacking = entity.isJumpAttacking();
        reusedState.overlayColor = entity.getOverlayColor(partialTick);
        reusedState.isPowered = entity.isCharged();
    }

    public MutantCreeperRenderState createRenderState() {
        return new MutantCreeperRenderState();
    }

    protected float getFlipDegrees() {
        return 0.0f;
    }

    protected float getWhiteOverlayProgress(MutantCreeperRenderState renderState) {
        return renderState.isJumpAttacking && renderState.deathTime == 0.0f ? ((int)(renderState.overlayColor * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)renderState.overlayColor, (float)0.5f, (float)1.0f)) : renderState.overlayColor;
    }

    protected void scale(MutantCreeperRenderState mutantCreeper, PoseStack poseStack) {
        float scale = 1.2f;
        this.shadowRadius = 1.5f;
        if (mutantCreeper.deathTime > 0.0f) {
            float deathProgress = mutantCreeper.deathTime / 100.0f;
            scale -= deathProgress * 0.4f;
            this.shadowRadius -= deathProgress * 0.4f;
        }
        poseStack.scale(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(MutantCreeperRenderState renderState) {
        return TEXTURE_LOCATION;
    }
}

