/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanCloneLayer;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanDeathLayer;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanEyesLayer;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanHeldBlocksLayer;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanScreamLayer;
import fuzs.mutantmonsters.client.renderer.entity.layers.MutantEndermanTeleportLayer;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantEndermanRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantEndermanRenderer
extends MobRenderer<MutantEnderman, MutantEndermanRenderState, MutantEndermanModel> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_enderman/mutant_enderman.png");
    private final MutantEndermanTeleportLayer teleportLayer;

    public MutantEndermanRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MutantEndermanModel(context.bakeLayer(ModelLayerLocations.MUTANT_ENDERMAN)), 0.8f);
        this.addLayer(new MutantEndermanDeathLayer((RenderLayerParent<MutantEndermanRenderState, MutantEndermanModel>)this));
        this.addLayer(new MutantEndermanEyesLayer((RenderLayerParent<MutantEndermanRenderState, MutantEndermanModel>)this));
        this.addLayer(new MutantEndermanCloneLayer((RenderLayerParent<MutantEndermanRenderState, MutantEndermanModel>)this, context.getModelSet()));
        this.teleportLayer = new MutantEndermanTeleportLayer((RenderLayerParent<MutantEndermanRenderState, MutantEndermanModel>)this);
        this.addLayer(this.teleportLayer);
        this.addLayer(new MutantEndermanScreamLayer((RenderLayerParent<MutantEndermanRenderState, MutantEndermanModel>)this));
        this.addLayer(new MutantEndermanHeldBlocksLayer((RenderLayerParent<MutantEndermanRenderState, MutantEndermanModel>)this, context.getBlockRenderDispatcher()));
    }

    public boolean shouldRender(MutantEnderman mutantEnderman, Frustum camera, double camX, double camY, double camZ) {
        if (super.shouldRender((Entity)mutantEnderman, camera, camX, camY, camZ)) {
            return true;
        }
        if (mutantEnderman.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
            return mutantEnderman.getTeleportPosition().map(Vec3::atBottomCenterOf).map(arg_0 -> ((EntityDimensions)mutantEnderman.getType().getDimensions()).makeBoundingBox(arg_0)).filter(arg_0 -> ((Frustum)camera).isVisible(arg_0)).isPresent();
        }
        return false;
    }

    public void render(MutantEndermanRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (renderState.isClone) {
            this.shadowRadius = 0.5f;
            this.shadowStrength = 0.5f;
        } else {
            this.shadowRadius = 0.8f;
            this.shadowStrength = renderState.deathTime > 80.0f ? 1.0f - MutantEndermanRenderer.getDeathProgress((LivingEntityRenderState)renderState) : 1.0f;
        }
        super.render((LivingEntityRenderState)renderState, poseStack, bufferSource, packedLight);
        if (renderState.animation == MutantEnderman.TELEPORT_ANIMATION && renderState.teleportPosition != null) {
            poseStack.pushPose();
            poseStack.translate((double)renderState.teleportPosition.getX() + 0.5 - renderState.x, (double)renderState.teleportPosition.getY() - renderState.y, (double)renderState.teleportPosition.getZ() + 0.5 - renderState.z);
            this.teleportLayer.setShrinking(true);
            super.render((LivingEntityRenderState)renderState, poseStack, bufferSource, packedLight);
            this.teleportLayer.setShrinking(false);
            poseStack.popPose();
        }
    }

    public static float getDeathProgress(LivingEntityRenderState renderState) {
        return (renderState.deathTime - 80.0f) / ((float)MutantEnderman.DEATH_ANIMATION.duration() - 80.0f);
    }

    public Vec3 getRenderOffset(MutantEndermanRenderState renderState) {
        return renderState.renderOffset != null ? renderState.renderOffset : super.getRenderOffset((EntityRenderState)renderState);
    }

    public void extractRenderState(MutantEnderman mutantEnderman, MutantEndermanRenderState reusedState, float partialTick) {
        super.extractRenderState((LivingEntity)mutantEnderman, (LivingEntityRenderState)reusedState, partialTick);
        reusedState.hasRedOverlay = mutantEnderman.hurtTime > 0;
        reusedState.isCreepy = mutantEnderman.isAggressive();
        reusedState.animationTime = mutantEnderman.getAnimationTick() > 0 ? (float)mutantEnderman.getAnimationTick() + partialTick : (float)mutantEnderman.getAnimationTick();
        reusedState.animation = mutantEnderman.getAnimation();
        reusedState.armScale = mutantEnderman.getArmScale(partialTick);
        reusedState.isClone = mutantEnderman.isClone();
        for (int i = 0; i < reusedState.heldBlocks.length; ++i) {
            reusedState.heldBlocks[i] = mutantEnderman.getHeldBlock(i).orElse(null);
        }
        reusedState.activeArm = mutantEnderman.getActiveArm();
        boolean hasTarget = mutantEnderman.hasTargetTicks > 0;
        for (int i = 0; i < mutantEnderman.heldBlockTicks.length; ++i) {
            reusedState.heldBlockTicks[i] = (float)mutantEnderman.heldBlockTicks[i] + (mutantEnderman.heldBlockTicks[i] > 0 ? (hasTarget ? partialTick : -partialTick) : 0.0f);
        }
        reusedState.teleportPosition = mutantEnderman.getTeleportPosition().orElse(null);
        reusedState.renderOffset = this.getRenderOffset(mutantEnderman);
    }

    @Nullable
    private Vec3 getRenderOffset(MutantEnderman mutantEnderman) {
        boolean death;
        boolean stare = mutantEnderman.getAnimation() == MutantEnderman.STARE_ANIMATION;
        boolean scream = mutantEnderman.getAnimation() == MutantEnderman.SCREAM_ANIMATION;
        boolean clone = mutantEnderman.isClone() && mutantEnderman.isAggressive();
        boolean telesmash = mutantEnderman.getAnimation() == MutantEnderman.TELESMASH_ANIMATION && (float)mutantEnderman.getAnimationTick() < 18.0f;
        boolean bl = death = mutantEnderman.getAnimation() == MutantEnderman.DEATH_ANIMATION;
        if (stare || scream || clone || telesmash || death) {
            double shake = 0.03;
            if (clone) {
                shake = 0.02;
            } else if (death) {
                shake = (float)mutantEnderman.getAnimationTick() < 80.0f ? 0.02 : 0.05;
            } else if ((float)mutantEnderman.getAnimationTick() >= 40.0f) {
                shake *= 0.5;
            }
            return new Vec3(mutantEnderman.getRandom().nextGaussian() * shake, 0.0, mutantEnderman.getRandom().nextGaussian() * shake);
        }
        return null;
    }

    public MutantEndermanRenderState createRenderState() {
        return new MutantEndermanRenderState();
    }

    public ResourceLocation getTextureLocation(MutantEndermanRenderState renderState) {
        return TEXTURE_LOCATION;
    }

    public RenderType getRenderType(MutantEndermanRenderState renderState, boolean bodyVisible, boolean translucent, boolean glowing) {
        if (renderState.isClone || renderState.deathTime > 80.0f) {
            return null;
        }
        return super.getRenderType((LivingEntityRenderState)renderState, bodyVisible, translucent, glowing);
    }

    protected float getFlipDegrees() {
        return 0.0f;
    }

    protected AABB getBoundingBoxForCulling(MutantEnderman mutantEnderman) {
        return super.getBoundingBoxForCulling((LivingEntity)mutantEnderman).inflate(3.0);
    }
}

