/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.MutantZombieModel;
import fuzs.mutantmonsters.client.renderer.entity.state.AnimatedEntityRenderState;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantZombieRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class MutantZombieRenderer
extends MobRenderer<MutantZombie, MutantZombieRenderState, MutantZombieModel> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_zombie.png");

    public MutantZombieRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MutantZombieModel(context.bakeLayer(ModelLayerLocations.MUTANT_ZOMBIE)), 1.0f);
    }

    public Vec3 getRenderOffset(MutantZombieRenderState renderState) {
        return new Vec3(0.0, -0.0975, 0.0);
    }

    public void extractRenderState(MutantZombie entity, MutantZombieRenderState reusedState, float partialTick) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)reusedState, partialTick);
        reusedState.hasRedOverlay = entity.hurtTime > 0 || entity.deathTime > 0 && entity.getLives() <= 0;
        AnimatedEntityRenderState.extractAnimatedEntityRenderState(entity, reusedState, partialTick, this.itemModelResolver);
        reusedState.vanishTime = entity.vanishTime > 0 ? (float)entity.vanishTime + partialTick : (float)entity.vanishTime;
        reusedState.throwHitTime = entity.throwHitTick == -1 ? -1.0f : (float)entity.throwHitTick + partialTick;
        reusedState.throwFinishTime = entity.throwFinishTick == -1 ? -1.0f : (float)entity.throwFinishTick + partialTick;
    }

    public MutantZombieRenderState createRenderState() {
        return new MutantZombieRenderState();
    }

    public ResourceLocation getTextureLocation(MutantZombieRenderState renderState) {
        return TEXTURE_LOCATION;
    }

    protected RenderType getRenderType(MutantZombieRenderState renderState, boolean bodyVisible, boolean translucent, boolean glowing) {
        return super.getRenderType((LivingEntityRenderState)renderState, bodyVisible, translucent || renderState.vanishTime > 0.0f, glowing);
    }

    protected void setupRotations(MutantZombieRenderState renderState, PoseStack poseStack, float bodyRot, float scale) {
        if (renderState.deathTime > 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - bodyRot));
            float deathAmount = Math.min(20.0f, renderState.deathTime);
            boolean reviving = false;
            if (renderState.deathTime > 100.0f) {
                deathAmount = 140.0f - renderState.deathTime;
                reviving = true;
            }
            if (deathAmount > 0.0f) {
                float flipAmount = reviving ? deathAmount / 40.0f * 1.6f : (deathAmount - 1.0f) / 20.0f * 1.6f;
                if ((flipAmount = Mth.sqrt((float)flipAmount)) > 1.0f) {
                    flipAmount = 1.0f;
                }
                poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(flipAmount * this.getFlipDegrees()));
            }
        } else {
            super.setupRotations((LivingEntityRenderState)renderState, poseStack, bodyRot, scale);
        }
    }

    protected float getFlipDegrees() {
        return 80.0f;
    }

    protected void scale(MutantZombieRenderState renderState, PoseStack poseStack) {
        poseStack.scale(1.3f, 1.3f, 1.3f);
    }

    protected int getModelTint(MutantZombieRenderState renderState) {
        if (renderState.vanishTime > 0.0f) {
            float alpha = 1.0f - renderState.vanishTime / 100.0f * 0.6f;
            return ARGB.white((float)Mth.clamp((float)alpha, (float)0.0f, (float)1.0f));
        }
        return super.getModelTint((LivingEntityRenderState)renderState);
    }

    protected AABB getBoundingBoxForCulling(MutantZombie mutantZombie) {
        return super.getBoundingBoxForCulling((LivingEntity)mutantZombie).inflate(1.0);
    }
}

