/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ModelLayerLocations;
import fuzs.mutantmonsters.client.model.SpiderPigModel;
import fuzs.mutantmonsters.client.renderer.entity.layers.SimpleEquipmentLayer;
import fuzs.mutantmonsters.client.renderer.entity.state.SpiderPigRenderState;
import fuzs.mutantmonsters.world.entity.mutant.SpiderPig;
import net.minecraft.client.model.AdultAndBabyModelPair;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;

public class SpiderPigRenderer
extends MobRenderer<SpiderPig, SpiderPigRenderState, SpiderPigModel> {
    public static final ResourceLocation TEXTURE_LOCATION = MutantMonsters.id("textures/entity/spider_pig.png");
    static final EquipmentClientInfo.Layer CLIENT_INFO_LAYER = new EquipmentClientInfo.Layer(MutantMonsters.id("saddle"));
    static final StringRepresentable LAYER_TYPE = () -> "spider_pig_saddle";
    private final AdultAndBabyModelPair<SpiderPigModel> models;

    public SpiderPigRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SpiderPigModel(context.bakeLayer(ModelLayerLocations.SPIDER_PIG)), 0.8f);
        this.models = new AdultAndBabyModelPair((Model)new SpiderPigModel(context.bakeLayer(ModelLayerLocations.SPIDER_PIG)), (Model)new SpiderPigModel(context.bakeLayer(ModelLayerLocations.SPIDER_PIG_BABY)));
        this.addLayer(new SimpleEquipmentLayer(this, (ResourceKey<EquipmentAsset>)EquipmentAssets.SADDLE, CLIENT_INFO_LAYER, LAYER_TYPE, renderState -> renderState.saddle, new SpiderPigModel(context.bakeLayer(ModelLayerLocations.SPIDER_PIG_SADDLE)), new SpiderPigModel(context.bakeLayer(ModelLayerLocations.SPIDER_PIG_BABY_SADDLE))));
    }

    public void extractRenderState(SpiderPig spiderPig, SpiderPigRenderState reusedState, float partialTick) {
        super.extractRenderState((LivingEntity)spiderPig, (LivingEntityRenderState)reusedState, partialTick);
        reusedState.attackTime = spiderPig.getAttackAnim(partialTick);
        reusedState.saddle = spiderPig.getItemBySlot(EquipmentSlot.SADDLE).copy();
    }

    public void render(SpiderPigRenderState livingEntityRenderState, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        this.model = (EntityModel)this.models.getModel(livingEntityRenderState.isBaby);
        super.render((LivingEntityRenderState)livingEntityRenderState, poseStack, multiBufferSource, packedLight);
    }

    public SpiderPigRenderState createRenderState() {
        return new SpiderPigRenderState();
    }

    protected float getFlipDegrees() {
        return 180.0f;
    }

    protected void scale(SpiderPigRenderState renderState, PoseStack poseStack) {
        poseStack.scale(1.2f, 1.2f, 1.2f);
    }

    public ResourceLocation getTextureLocation(SpiderPigRenderState renderState) {
        return TEXTURE_LOCATION;
    }
}

