/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.client.renderer.entity.state.ThrowableBlockRenderState;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;

public class ThrowableBlockRenderer
extends EntityRenderer<ThrowableBlock, ThrowableBlockRenderState> {
    private final BlockRenderDispatcher blockRenderer;

    public ThrowableBlockRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderer = context.getBlockRenderDispatcher();
        this.shadowRadius = 0.6f;
    }

    public void extractRenderState(ThrowableBlock entity, ThrowableBlockRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.blockState = entity.getBlockState();
        reusedState.isLarge = entity.isLarge();
        reusedState.yRot = entity.getYRot(partialTick);
    }

    public ThrowableBlockRenderState createRenderState() {
        return new ThrowableBlockRenderState();
    }

    public void render(ThrowableBlockRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5, 0.0);
        if (renderState.isLarge) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.yRot));
        } else {
            poseStack.scale(-0.75f, -0.75f, 0.75f);
        }
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(45.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.ageInTicks * 20.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZN.rotationDegrees(renderState.ageInTicks * 12.0f));
        poseStack.translate(-0.5f, -0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        this.blockRenderer.renderSingleBlock(renderState.blockState, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

