/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.client.renderer.ModRenderType;
import fuzs.mutantmonsters.client.renderer.entity.EndersoulCloneRenderer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ARGB;

public abstract class EnderEnergySwirlLayer<S extends LivingEntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    protected EnderEnergySwirlLayer(RenderLayerParent<S, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, S renderState, float yRot, float xRot) {
        poseStack.pushPose();
        this.scale(poseStack, this.getScale(renderState));
        this.getModel().setupAnim(renderState);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(ModRenderType.energySwirl(EndersoulCloneRenderer.TEXTURE_LOCATION, ((LivingEntityRenderState)renderState).ageInTicks * 0.008f, ((LivingEntityRenderState)renderState).ageInTicks * 0.008f));
        int color = ARGB.colorFromFloat((float)this.getAlpha(renderState), (float)0.9f, (float)0.3f, (float)1.0f);
        this.getModel().renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        poseStack.popPose();
    }

    protected EntityModel<? super S> getModel() {
        return this.getParentModel();
    }

    protected float getScale(S renderState) {
        return 1.0f;
    }

    protected void scale(PoseStack poseStack, float scale) {
    }

    protected float getAlpha(S renderState) {
        return 1.0f;
    }
}

