/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.renderer.entity.MutantEndermanRenderer;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantEndermanRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class MutantEndermanDeathLayer
extends RenderLayer<MutantEndermanRenderState, MutantEndermanModel> {
    private static final ResourceLocation DEATH_TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_enderman/death.png");
    private static final RenderType DEATH_RENDER_TYPE = RenderType.entityDecal((ResourceLocation)MutantEndermanRenderer.TEXTURE_LOCATION);

    public MutantEndermanDeathLayer(RenderLayerParent<MutantEndermanRenderState, MutantEndermanModel> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, MutantEndermanRenderState renderState, float yRot, float xRot) {
        if (renderState.deathTime > 80.0f) {
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.dragonExplosionAlpha((ResourceLocation)DEATH_TEXTURE_LOCATION));
            int color = ARGB.colorFromFloat((float)MutantEndermanRenderer.getDeathProgress((LivingEntityRenderState)renderState), (float)1.0f, (float)1.0f, (float)1.0f);
            ((MutantEndermanModel)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
            vertexConsumer = bufferSource.getBuffer(DEATH_RENDER_TYPE);
            ((MutantEndermanModel)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        }
    }
}

