/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantEndermanRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class MutantEndermanHeldBlocksLayer
extends RenderLayer<MutantEndermanRenderState, MutantEndermanModel> {
    private final BlockRenderDispatcher blockRenderer;

    public MutantEndermanHeldBlocksLayer(RenderLayerParent<MutantEndermanRenderState, MutantEndermanModel> renderer, BlockRenderDispatcher blockRenderer) {
        super(renderer);
        this.blockRenderer = blockRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, MutantEndermanRenderState renderState, float yRot, float xRot) {
        if (renderState.animation != MutantEnderman.CLONE_ANIMATION) {
            for (int i = 0; i < 4; ++i) {
                BlockState blockState = renderState.heldBlocks[i];
                if (blockState == null) continue;
                poseStack.pushPose();
                ((MutantEndermanModel)this.getParentModel()).translateRotateArm(poseStack, i);
                poseStack.translate(0.0, 1.2, 0.0);
                float rotationAmount = renderState.ageInTicks + (float)(i + 1) * 2.0f * (float)Math.PI;
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(rotationAmount * 10.0f));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotationAmount * 8.0f));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(rotationAmount * 6.0f));
                poseStack.scale(-0.75f, -0.75f, 0.75f);
                poseStack.translate(-0.5, -0.5, 0.5);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                this.blockRenderer.renderSingleBlock(blockState, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
        }
    }
}

