/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.renderer.entity.layers.EnderEnergySwirlLayer;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantEndermanRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;

public class MutantEndermanScreamLayer
extends EnderEnergySwirlLayer<MutantEndermanRenderState, MutantEndermanModel> {
    public MutantEndermanScreamLayer(RenderLayerParent<MutantEndermanRenderState, MutantEndermanModel> renderer) {
        super(renderer);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, MutantEndermanRenderState renderState, float yRot, float xRot) {
        if (renderState.animation == MutantEnderman.SCREAM_ANIMATION) {
            super.render(poseStack, bufferSource, packedLight, renderState, yRot, xRot);
        }
    }

    @Override
    protected float getScale(MutantEndermanRenderState renderState) {
        if (renderState.animationTime < 40.0f) {
            return 1.2f + renderState.animationTime / 40.0f;
        }
        if (renderState.animationTime < 160.0f) {
            return 2.2f;
        }
        return Math.max(0.0f, 2.2f - renderState.animationTime / 10.0f);
    }

    @Override
    protected void scale(PoseStack poseStack, float scale) {
        poseStack.scale(scale, scale * 0.8f, scale);
    }

    @Override
    protected float getAlpha(MutantEndermanRenderState renderState) {
        if (renderState.animationTime < 40.0f) {
            return renderState.animationTime / 40.0f;
        }
        if (renderState.animationTime >= 160.0f) {
            return 1.0f - renderState.animationTime / 40.0f;
        }
        return 1.0f;
    }
}

