/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.renderer.entity.layers.EnderEnergySwirlLayer;
import fuzs.mutantmonsters.client.renderer.entity.state.MutantEndermanRenderState;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;

public class MutantEndermanTeleportLayer
extends EnderEnergySwirlLayer<MutantEndermanRenderState, MutantEndermanModel> {
    private boolean isShrinking;

    public MutantEndermanTeleportLayer(RenderLayerParent<MutantEndermanRenderState, MutantEndermanModel> renderer) {
        super(renderer);
    }

    public void setShrinking(boolean shrinking) {
        this.isShrinking = shrinking;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, MutantEndermanRenderState renderState, float yRot, float xRot) {
        if (renderState.animation == MutantEnderman.TELEPORT_ANIMATION && renderState.animationTime < 10.0f) {
            super.render(poseStack, bufferSource, packedLight, renderState, yRot, xRot);
        }
    }

    @Override
    protected float getScale(MutantEndermanRenderState renderState) {
        if (this.isShrinking) {
            return 2.2f - renderState.animationTime / 10.0f;
        }
        return 1.2f + renderState.animationTime / 10.0f;
    }

    @Override
    protected void scale(PoseStack poseStack, float scale) {
        poseStack.scale(scale, scale * 0.8f, scale);
    }

    @Override
    protected float getAlpha(MutantEndermanRenderState renderState) {
        if (!this.isShrinking && renderState.animationTime >= 8.0f) {
            return 1.0f - (renderState.animationTime - 8.0f) / 2.0f;
        }
        if (this.isShrinking && renderState.animationTime < 2.0f) {
            return renderState.animationTime / 2.0f;
        }
        return 1.0f;
    }
}

