/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import fuzs.mutantmonsters.world.level.SeismicWave;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.puzzleslib.api.item.v2.EnchantingHelper;
import fuzs.puzzleslib.api.util.v1.DamageHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEventsHandler {
    public static EventResult onItemUseTick(LivingEntity entity, ItemStack useItem, MutableInt useItemRemaining) {
        if (entity.getItemBySlot(EquipmentSlot.CHEST).is(ModItems.MUTANT_SKELETON_CHESTPLATE_ITEM) && useItem.getItem() instanceof BowItem && BowItem.getPowerForTime((int)(useItem.getUseDuration(entity) - useItemRemaining.getAsInt())) < 1.0f) {
            useItemRemaining.mapInt(i -> i - 2);
        }
        return EventResult.PASS;
    }

    public static EventResult onArrowLoose(Player player, ItemStack weapon, Level level, MutableInt charge, boolean hasAmmo) {
        if (player.getItemBySlot(EquipmentSlot.HEAD).is(ModItems.MUTANT_SKELETON_SKULL_ITEM) && weapon.getItem() instanceof BowItem) {
            Holder enchantment = EnchantingHelper.lookup((LevelReader)level, (ResourceKey)Enchantments.MULTISHOT);
            if (weapon.getEnchantments().getLevel(enchantment) == 0) {
                ItemStack itemStack = weapon.copy();
                itemStack.enchant(enchantment, 1);
                itemStack.releaseUsing(level, (LivingEntity)player, player.getUseItemRemainingTicks());
                return EventResult.INTERRUPT;
            }
        }
        return EventResult.PASS;
    }

    public static void onEndPlayerTick(Player player) {
        PlayerEventsHandler.playShoulderEntitySound(player, player.getShoulderEntityLeft());
        PlayerEventsHandler.playShoulderEntitySound(player, player.getShoulderEntityRight());
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SeismicWave seismicWave = SeismicWave.poll(player);
            if (seismicWave != null) {
                PlayerEventsHandler.handleSeismicWave(serverLevel, player, seismicWave);
            }
        }
    }

    private static void handleSeismicWave(ServerLevel serverLevel, Player player, @NotNull SeismicWave seismicWave) {
        seismicWave.affectBlocks(serverLevel, (Entity)player);
        AABB box = new AABB((double)seismicWave.getX(), (double)seismicWave.getY() + 1.0, (double)seismicWave.getZ(), (double)seismicWave.getX() + 1.0, (double)seismicWave.getY() + 2.0, (double)seismicWave.getZ() + 1.0);
        for (LivingEntity livingEntity : serverLevel.getEntitiesOfClass(LivingEntity.class, box)) {
            if (livingEntity == player || player.getVehicle() == livingEntity) continue;
            DamageSource damageSource = DamageHelper.damageSource((LevelReader)serverLevel, ModRegistry.PLAYER_SEISMIC_WAVE_DAMAGE_TYPE, (Entity)player);
            livingEntity.hurtServer(serverLevel, damageSource, 6.0f + (float)player.getRandom().nextInt(3));
        }
    }

    private static void playShoulderEntitySound(Player player, @Nullable CompoundTag compoundTag) {
        EntityType entityType;
        if (compoundTag != null && !compoundTag.isEmpty() && !compoundTag.getBooleanOr("Silent", false) && (entityType = (EntityType)compoundTag.read("id", EntityType.CODEC).orElse(null)) == ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.value() && player.level().random.nextInt(500) == 0) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSoundEvents.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.value(), player.getSoundSource(), 1.0f, (player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.2f + 1.5f);
        }
    }

    public static EventResult onItemToss(ServerPlayer serverPlayer, ItemStack itemStack) {
        boolean isHoldingEndersoulHand;
        boolean bl = isHoldingEndersoulHand = itemStack.is(ModItems.ENDERSOUL_HAND_ITEM) && itemStack.isDamaged();
        if (itemStack.is(Items.ENDER_EYE) || isHoldingEndersoulHand) {
            int endersoulFragments = 0;
            for (EndersoulFragment endersoulFragment : serverPlayer.level().getEntitiesOfClass(EndersoulFragment.class, serverPlayer.getBoundingBox().inflate(8.0))) {
                if (!endersoulFragment.ownedBy((Entity)serverPlayer)) continue;
                ++endersoulFragments;
                endersoulFragment.discard();
            }
            if (endersoulFragments > 0) {
                EntityUtil.sendParticlePacket((Entity)serverPlayer, (ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.value(), 256);
                int additionalDamageValue = endersoulFragments * 60;
                if (isHoldingEndersoulHand) {
                    int damageValue = itemStack.getDamageValue() - additionalDamageValue;
                    itemStack.setDamageValue(Math.max(damageValue, 0));
                } else {
                    ItemStack newItemStack = new ItemStack(ModItems.ENDERSOUL_HAND_ITEM);
                    newItemStack.setDamageValue(newItemStack.getMaxDamage() - additionalDamageValue);
                    ItemEntity itemEntity = serverPlayer.createItemStackToDrop(newItemStack, false, true);
                    if (itemEntity != null) {
                        serverPlayer.level().addFreshEntity((Entity)itemEntity);
                        serverPlayer.awardStat(Stats.ITEM_DROPPED.get((Object)newItemStack.getItem()), itemStack.getCount());
                        serverPlayer.awardStat(Stats.DROP);
                        return EventResult.INTERRUPT;
                    }
                }
            }
        }
        return EventResult.PASS;
    }
}

