/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.network;

import fuzs.mutantmonsters.services.CommonAbstractions;
import fuzs.puzzleslib.api.network.v4.message.MessageListener;
import fuzs.puzzleslib.api.network.v4.message.play.ClientboundPlayMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public record ClientboundSeismicWaveFluidParticlesMessage(BlockPos blockPos) implements ClientboundPlayMessage
{
    public static final StreamCodec<ByteBuf, ClientboundSeismicWaveFluidParticlesMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ClientboundSeismicWaveFluidParticlesMessage::blockPos, ClientboundSeismicWaveFluidParticlesMessage::new);

    public MessageListener<ClientboundPlayMessage.Context> getListener() {
        return new MessageListener<ClientboundPlayMessage.Context>(){

            public void accept(ClientboundPlayMessage.Context context) {
                BlockPos blockPos = ClientboundSeismicWaveFluidParticlesMessage.this.blockPos;
                BlockState blockState = context.level().getBlockState(blockPos);
                blockState.getFluidState().getShape((BlockGetter)context.level(), blockPos).forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    double d1 = Math.min(1.0, maxX - minX);
                    double d2 = Math.min(1.0, maxY - minY);
                    double d3 = Math.min(1.0, maxZ - minZ);
                    int i = Math.max(2, Mth.ceil((double)(d1 / 0.25)));
                    int j = Math.max(2, Mth.ceil((double)(d2 / 0.25)));
                    int k = Math.max(2, Mth.ceil((double)(d3 / 0.25)));
                    for (int l = 0; l < i; ++l) {
                        for (int i1 = 0; i1 < j; ++i1) {
                            for (int j1 = 0; j1 < k; ++j1) {
                                double d4 = ((double)l + 0.5) / (double)i;
                                double d5 = ((double)i1 + 0.5) / (double)j;
                                double d6 = ((double)j1 + 0.5) / (double)k;
                                double d7 = d4 * d1 + minX;
                                double d8 = d5 * d2 + minY;
                                double d9 = d6 * d3 + minZ;
                                context.level().addAlwaysVisibleParticle((ParticleOptions)CommonAbstractions.INSTANCE.createBlockParticle((ParticleType<BlockParticleOption>)ParticleTypes.BLOCK, blockState, blockPos), true, (double)blockPos.getX() + d7, (double)blockPos.getY() + d8, (double)blockPos.getZ() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5);
                            }
                        }
                    }
                });
            }
        };
    }
}

