/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.network.client;

import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.puzzleslib.api.network.v4.codec.ExtraStreamCodecs;
import fuzs.puzzleslib.api.network.v4.message.MessageListener;
import fuzs.puzzleslib.api.network.v4.message.play.ServerboundPlayMessage;
import io.netty.buffer.ByteBuf;
import java.util.function.BiConsumer;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;

public record ServerboundCreeperMinionTrackerMessage(int entityId, DataType dataType, boolean optionValue) implements ServerboundPlayMessage
{
    public static final StreamCodec<ByteBuf, ServerboundCreeperMinionTrackerMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ServerboundCreeperMinionTrackerMessage::entityId, (StreamCodec)ExtraStreamCodecs.fromEnum(DataType.class), ServerboundCreeperMinionTrackerMessage::dataType, (StreamCodec)ByteBufCodecs.BOOL, ServerboundCreeperMinionTrackerMessage::optionValue, ServerboundCreeperMinionTrackerMessage::new);

    public MessageListener<ServerboundPlayMessage.Context> getListener() {
        return new MessageListener<ServerboundPlayMessage.Context>(){

            public void accept(ServerboundPlayMessage.Context context) {
                Entity entity = context.level().getEntity(ServerboundCreeperMinionTrackerMessage.this.entityId);
                if (entity instanceof CreeperMinion) {
                    CreeperMinion creeperMinion = (CreeperMinion)entity;
                    ServerboundCreeperMinionTrackerMessage.this.dataType.valueConsumer.accept(creeperMinion, ServerboundCreeperMinionTrackerMessage.this.optionValue);
                }
            }
        };
    }

    public static enum DataType {
        CAN_DESTROY_BLOCKS(CreeperMinion::setDestroyBlocks),
        IS_CUSTOM_NAME_VISIBLE(Entity::setCustomNameVisible),
        CAN_RIDE_ON_SHOULDER(CreeperMinion::setCanRideOnShoulder);

        final BiConsumer<CreeperMinion, Boolean> valueConsumer;

        private DataType(BiConsumer<CreeperMinion, Boolean> valueConsumer) {
            this.valueConsumer = valueConsumer;
        }
    }
}

