/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.util;

import com.google.common.collect.ImmutableMap;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.network.ClientboundMutantLevelParticlesMessage;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class EntityUtil {
    private static final Map<EntityType<?>, Item> VANILLA_SKULLS_MAP = ImmutableMap.of((Object)EntityType.CREEPER, (Object)Items.CREEPER_HEAD, (Object)EntityType.ZOMBIE, (Object)Items.ZOMBIE_HEAD, (Object)EntityType.SKELETON, (Object)Items.SKELETON_SKULL, (Object)EntityType.WITHER_SKELETON, (Object)Items.WITHER_SKELETON_SKULL, (Object)EntityType.ENDER_DRAGON, (Object)Items.DRAGON_HEAD);

    private EntityUtil() {
    }

    public static float getHeadAngle(LivingEntity livingEntity, double x, double z) {
        return Mth.degreesDifferenceAbs((float)((float)(Math.atan2(z, x) * 180.0 / Math.PI) + 90.0f), (float)livingEntity.yHeadRot);
    }

    public static void spawnLingeringCloud(LivingEntity livingEntity) {
        Collection collection = livingEntity.getActiveEffects();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(livingEntity.level(), livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
            areaEffectCloud.setRadius(1.5f);
            areaEffectCloud.setRadiusOnUse(-0.5f);
            areaEffectCloud.setWaitTime(10);
            areaEffectCloud.setDuration(areaEffectCloud.getDuration() / 2);
            areaEffectCloud.setRadiusPerTick(-areaEffectCloud.getRadius() / (float)areaEffectCloud.getDuration());
            for (MobEffectInstance effectinstance : collection) {
                areaEffectCloud.addEffect(new MobEffectInstance(effectinstance));
            }
            livingEntity.level().addFreshEntity((Entity)areaEffectCloud);
        }
    }

    public static void stunRavager(LivingEntity livingEntity) {
        Ravager ravager;
        if (livingEntity instanceof Ravager && (ravager = (Ravager)livingEntity).getStunnedTick() == 0) {
            ravager.handleEntityEvent((byte)39);
            livingEntity.playSound(SoundEvents.RAVAGER_STUNNED, 1.0f, 1.0f);
            livingEntity.level().broadcastEntityEvent((Entity)livingEntity, (byte)39);
        }
    }

    public static void disableShield(LivingEntity livingEntity, int ticks) {
        Level level = livingEntity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemStack = livingEntity.getItemBlockingWith();
            if (itemStack != null && itemStack.has(DataComponents.BLOCKS_ATTACKS)) {
                ((BlocksAttacks)itemStack.get(DataComponents.BLOCKS_ATTACKS)).disable(serverLevel, livingEntity, (float)ticks / 20.0f, itemStack);
            }
        }
    }

    public static void sendPlayerVelocityPacket(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ((ServerPlayer)entity).connection.send((Packet)new ClientboundSetEntityMotionPacket(entity));
        }
    }

    public static boolean isFeline(LivingEntity livingEntity) {
        return livingEntity instanceof Ocelot || livingEntity instanceof Cat;
    }

    public static boolean shouldAttackEntity(LivingEntity target, LivingEntity owner, boolean targetCreepers) {
        if (!(owner instanceof Player)) {
            return true;
        }
        if (target instanceof Creeper) {
            return targetCreepers;
        }
        if (target instanceof TamableAnimal) {
            return !((TamableAnimal)target).isOwnedBy(owner);
        }
        if (target instanceof Player && !((Player)owner).canHarmPlayer((Player)target)) {
            return false;
        }
        if (target instanceof AbstractGolem && !(target instanceof Enemy)) {
            return false;
        }
        return !(target instanceof AbstractHorse) || !((AbstractHorse)target).isTamed();
    }

    public static void spawnEndersoulParticles(Entity entity, RandomSource random, int amount, float speed) {
        for (int i = 0; i < amount; ++i) {
            float f = (random.nextFloat() - 0.5f) * speed;
            float f1 = (random.nextFloat() - 0.5f) * speed;
            float f2 = (random.nextFloat() - 0.5f) * speed;
            double tempX = entity.getX() + (double)((random.nextFloat() - 0.5f) * entity.getBbWidth());
            double tempY = entity.getY() + (double)((random.nextFloat() - 0.5f) * entity.getBbHeight()) + 0.5;
            double tempZ = entity.getZ() + (double)((random.nextFloat() - 0.5f) * entity.getBbWidth());
            entity.level().addParticle((ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.value(), tempX, tempY, tempZ, (double)f, (double)f1, (double)f2);
        }
    }

    public static void sendParticlePacket(Entity entity, ParticleOptions particle, int amount) {
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        MessageSender.broadcast((PlayerSet)PlayerSet.nearEntity((Entity)entity), (Message)new ClientboundMutantLevelParticlesMessage(particle, x, y, z, entity.getBbWidth(), entity.getBbHeight(), entity.getBbWidth(), amount));
    }

    public static Vec3 getDirVector(float rotation, float scale) {
        float rad = rotation * ((float)Math.PI / 180);
        return new Vec3((double)(-Mth.sin((float)rad) * scale), 0.0, (double)(Mth.cos((float)rad) * scale));
    }

    public static boolean teleportTo(Mob mob, double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        boolean success = false;
        if (mob.level().isLoaded((BlockPos)pos)) {
            do {
                pos.move(Direction.DOWN);
            } while (pos.getY() > mob.level().getMinY() && !mob.level().getBlockState((BlockPos)pos).blocksMotion());
            pos.move(Direction.UP);
            AABB bb = mob.getDimensions(Pose.STANDING).makeBoundingBox((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (mob.level().noCollision((Entity)mob, bb) && !mob.level().containsAnyLiquid(bb)) {
                success = true;
            }
        }
        if (!success) {
            return false;
        }
        mob.getNavigation().stop();
        mob.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        return true;
    }

    public static void divertAttackers(Mob targetedMob, LivingEntity newTarget) {
        for (Mob attacker : targetedMob.level().getEntitiesOfClass(Mob.class, targetedMob.getBoundingBox().inflate(16.0, 10.0, 16.0))) {
            if (attacker == targetedMob || attacker.getTarget() != targetedMob) continue;
            attacker.setTarget(newTarget);
        }
    }

    public static ItemStack getSkullDrop(EntityType<?> entityType) {
        if (!VANILLA_SKULLS_MAP.containsKey(entityType)) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)VANILLA_SKULLS_MAP.get(entityType));
    }
}

