/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.services.CommonAbstractions;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class CreeperMinionEgg
extends Entity
implements OwnableEntity {
    private static final EntityDataAccessor<Boolean> DATA_CHARGED = SynchedEntityData.defineId(CreeperMinionEgg.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> DATA_OWNERUUID_ID = SynchedEntityData.defineId(CreeperMinionEgg.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);
    private final InterpolationHandler interpolation = new InterpolationHandler((Entity)this);
    private int health = 8;
    private int age = (60 + this.random.nextInt(40)) * 1200;
    private int recentlyHit;
    private int dismountTicks;

    public CreeperMinionEgg(EntityType<? extends CreeperMinionEgg> entityType, Level level) {
        super(entityType, level);
        this.blocksBuilding = true;
    }

    public CreeperMinionEgg(MutantCreeper spawner) {
        this((EntityType<? extends CreeperMinionEgg>)((EntityType)ModEntityTypes.CREEPER_MINION_EGG_ENTITY_TYPE.value()), spawner.level());
        this.setPos(spawner.getX(), spawner.getY(), spawner.getZ());
        this.setCharged(spawner.isCharged());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_CHARGED, (Object)false);
        builder.define(DATA_OWNERUUID_ID, Optional.empty());
    }

    private void setHealth(int health) {
        this.health = health;
    }

    private void setAge(int age) {
        this.age = age;
    }

    @Nullable
    public EntityReference<LivingEntity> getOwnerReference() {
        return ((Optional)this.entityData.get(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwner(@Nullable Player livingEntity) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(livingEntity).map(EntityReference::new));
    }

    public void setOwnerReference(@Nullable EntityReference<LivingEntity> entityReference) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(entityReference));
    }

    public boolean isCharged() {
        return (Boolean)this.entityData.get(DATA_CHARGED);
    }

    public void setCharged(boolean charged) {
        this.entityData.set(DATA_CHARGED, (Object)charged);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean canCollideWith(Entity entity) {
        return Boat.canVehicleCollide((Entity)this, (Entity)entity);
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public boolean isPushable() {
        return this.isAlive();
    }

    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }

    public void thunderHit(ServerLevel serverLevel, LightningBolt lightningBolt) {
        super.thunderHit(serverLevel, lightningBolt);
        this.setCharged(true);
    }

    public void tick() {
        Level level;
        super.tick();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.04, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, 0.0, 0.7));
        }
        if (this.isPassenger()) {
            if (this.getFirstPassenger() != null) {
                this.dismountTicks = 10;
            } else if (this.dismountTicks > 0) {
                --this.dismountTicks;
            }
            Entity rootVehicle = this.getRootVehicle();
            if (this.isInWall() || !rootVehicle.hasPose(Pose.STANDING) && !rootVehicle.hasPose(Pose.CROUCHING) || this.dismountTicks <= 0 && rootVehicle.isShiftKeyDown() || rootVehicle.isSpectator()) {
                this.stopRiding();
                this.playMountingSound(false);
            }
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.health < 8 && this.tickCount - this.recentlyHit > 80 && this.tickCount % 20 == 0) {
                ++this.health;
            }
            if (--this.age <= 0) {
                EntityReference<LivingEntity> entityReference = this.getOwnerReference();
                if (entityReference != null) {
                    Player player;
                    UniquelyIdentifyable uniquelyIdentifyable = entityReference.getEntity((UUIDLookup)this.level(), LivingEntity.class);
                    if (uniquelyIdentifyable instanceof Player && this.distanceToSqr((Entity)(player = (Player)uniquelyIdentifyable)) < 4096.0) {
                        this.hatch(player);
                    } else {
                        this.age = 1200;
                    }
                } else {
                    this.hurtServer(serverLevel, this.damageSources().magic(), 1000.0f);
                }
            }
        }
    }

    private void hatch(Player player) {
        CreeperMinion creeperMinion = (CreeperMinion)((EntityType)ModEntityTypes.CREEPER_MINION_ENTITY_TYPE.value()).create(this.level(), EntitySpawnReason.BREEDING);
        if (creeperMinion != null) {
            if (!CommonAbstractions.INSTANCE.onAnimalTame((Animal)creeperMinion, player)) {
                creeperMinion.tame(player);
                creeperMinion.setOrderedToSit(true);
            }
            creeperMinion.setCharged(this.isCharged());
            creeperMinion.setPos(this.getX(), this.getY(), this.getZ());
            this.level().addFreshEntity((Entity)creeperMinion);
            this.playSound((SoundEvent)ModSoundEvents.ENTITY_CREEPER_MINION_EGG_HATCH_SOUND_EVENT.value(), 0.7f, 0.9f + this.random.nextFloat() * 0.1f);
            this.discard();
        }
    }

    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        if (!player.isSecondaryUseActive() && player.hasPose(Pose.STANDING) && !player.hasPassenger((Entity)this) && this.startRiding(this.getTopPassenger((Entity)player))) {
            if (!this.level().isClientSide) {
                this.setOwner(player);
                this.playMountingSound(true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"mount.onboard", (Object[])new Object[]{Component.keybind((String)"key.sneak")}), true);
            }
            return InteractionResultHelper.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.interact(player, interactionHand);
    }

    private Entity getTopPassenger(Entity entity) {
        List list = entity.getPassengers();
        return !list.isEmpty() ? this.getTopPassenger((Entity)list.getFirst()) : entity;
    }

    private void playMountingSound(boolean isMounting) {
        this.playSound(SoundEvents.ITEM_PICKUP, 0.7f, (isMounting ? 0.6f : 0.3f) + this.random.nextFloat() * 0.1f);
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float damageAmount) {
        if (this.isInvulnerableToBase(damageSource)) {
            return false;
        }
        if (this.isAlive()) {
            this.markHurt();
            if (damageSource.is(DamageTypeTags.IS_EXPLOSION)) {
                this.age = (int)((float)this.age - damageAmount * 80.0f);
                EntityUtil.sendParticlePacket(this, (ParticleOptions)ParticleTypes.HEART, (int)(damageAmount / 2.0f));
                return false;
            }
            this.recentlyHit = this.tickCount;
            this.setDeltaMovement(0.0, 0.2, 0.0);
            this.health = (int)((float)this.health - damageAmount);
            if (this.health <= 0) {
                float sizeIn = this.isCharged() ? 2.0f : 0.0f;
                MutatedExplosionHelper.explode(this, sizeIn, false, Level.ExplosionInteraction.TNT);
                if (serverLevel.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    if (!this.isCharged() && this.random.nextInt(3) != 0) {
                        for (int i = 5 + this.random.nextInt(6); i > 0; --i) {
                            this.spawnAtLocation(serverLevel, (ItemLike)Items.GUNPOWDER);
                        }
                    } else {
                        this.spawnAtLocation(serverLevel, (ItemLike)ModItems.CREEPER_SHARD_ITEM.value());
                    }
                }
                this.discard();
            }
            return true;
        }
        return false;
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        valueOutput.putInt("Health", this.health);
        valueOutput.putInt("Age", this.age);
        valueOutput.putInt("RecentlyHit", this.recentlyHit);
        valueOutput.putBoolean("Charged", this.isCharged());
        valueOutput.putByte("DismountTicks", (byte)this.dismountTicks);
        EntityReference<LivingEntity> entityReference = this.getOwnerReference();
        if (entityReference != null) {
            entityReference.store(valueOutput, "Owner");
        }
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        valueInput.getInt("Health").ifPresent(this::setHealth);
        valueInput.getInt("Age").ifPresent(this::setAge);
        this.recentlyHit = valueInput.getIntOr("RecentlyHit", 0);
        this.setCharged(valueInput.getBooleanOr("Charged", false));
        this.dismountTicks = valueInput.getByteOr("DismountTicks", (byte)0);
        this.setOwnerReference((EntityReference<LivingEntity>)EntityReference.readWithOldOwnerConversion((ValueInput)valueInput, (String)"Owner", (Level)this.level()));
    }
}

