/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.puzzleslib.api.util.v1.DamageHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EndersoulFragment
extends Entity
implements TraceableEntity {
    @Nullable
    private final MutantEnderman spawner;
    public final float[][] stickRotations = new float[8][3];
    private int explodeTick = 20 + this.random.nextInt(20);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;

    private EndersoulFragment(EntityType<? extends EndersoulFragment> entityType, Level level, MutantEnderman mutantEnderman) {
        super(entityType, level);
        this.spawner = mutantEnderman;
        for (int i = 0; i < this.stickRotations.length; ++i) {
            for (int j = 0; j < this.stickRotations[i].length; ++j) {
                this.stickRotations[i][j] = this.random.nextFloat() * 2.0f * (float)Math.PI;
            }
        }
    }

    public EndersoulFragment(EntityType<? extends EndersoulFragment> entityType, Level level) {
        this(entityType, level, null);
    }

    public EndersoulFragment(Level level, MutantEnderman mutantEnderman) {
        this((EntityType<? extends EndersoulFragment>)((EntityType)ModEntityTypes.ENDERSOUL_FRAGMENT_ENTITY_TYPE.value()), level, mutantEnderman);
    }

    public static boolean isProtected(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isHolding((Item)ModItems.ENDERSOUL_HAND_ITEM.value());
    }

    private void setExplodeTick(int explodeTick) {
        this.explodeTick = explodeTick;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void setOwner(@Nullable Entity owner) {
        if (owner != null) {
            this.ownerUUID = owner.getUUID();
            this.cachedOwner = owner;
        }
    }

    @Nullable
    public Entity getOwner() {
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null) {
            this.cachedOwner = this.findOwner(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    @Nullable
    protected Entity findOwner(UUID entityUuid) {
        Entity entity;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            entity = serverLevel.getEntity(entityUuid);
        } else {
            entity = null;
        }
        return entity;
    }

    public boolean ownedBy(Entity entity) {
        return entity.getUUID().equals(this.ownerUUID);
    }

    protected void setOwnerThroughUUID(@Nullable UUID uuid) {
        if (!Objects.equals(this.ownerUUID, uuid)) {
            this.ownerUUID = uuid;
            this.cachedOwner = uuid != null ? this.findOwner(uuid) : null;
        }
    }

    public void restoreFrom(Entity entity) {
        super.restoreFrom(entity);
        if (entity instanceof EndersoulFragment) {
            EndersoulFragment endersoulFragment = (EndersoulFragment)entity;
            this.ownerUUID = endersoulFragment.ownerUUID;
            this.cachedOwner = endersoulFragment.cachedOwner;
        }
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public boolean isPushable() {
        return this.isAlive();
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            EntityUtil.spawnEndersoulParticles(this, this.random, 64, 0.8f);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void tick() {
        super.tick();
        Entity owner = this.getOwner();
        if (owner == null) {
            vec3 = this.getDeltaMovement();
            if (vec3.y > -0.05 && !this.isNoGravity()) {
                this.setDeltaMovement(vec3.x, Math.max(-0.05, vec3.y - 0.1), vec3.z);
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            this.noPhysics = true;
            vec3 = new Vec3(owner.getX() - this.getX(), owner.getY() + (double)owner.getEyeHeight() / 2.0 - this.getY(), owner.getZ() - this.getZ());
            this.setPosRaw(this.getX(), this.getY() + vec3.y * 0.015, this.getZ());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9).add(vec3.normalize().scale(0.05)));
            this.setPos(this.position().add(this.getDeltaMovement()));
            this.applyEffectsFromBlocks();
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (--this.explodeTick <= 0) {
                this.explode(serverLevel);
            }
        }
    }

    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        if (!this.ownedBy((Entity)player) && !player.isSecondaryUseActive()) {
            this.setOwner((Entity)player);
            this.explodeTick += 600;
            this.playSound(SoundEvents.ENDER_EYE_DEATH, 1.0f, 0.8f + this.level().random.nextFloat() * 0.4f);
            return InteractionResultHelper.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.interact(player, interactionHand);
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float amount) {
        if (this.isInvulnerableToBase(damageSource)) {
            return false;
        }
        if (this.isAlive() && this.tickCount > 0) {
            this.explode(serverLevel);
        }
        return true;
    }

    private void explode(ServerLevel serverLevel) {
        this.playSound((SoundEvent)ModSoundEvents.ENTITY_ENDERSOUL_FRAGMENT_EXPLODE_SOUND_EVENT.value(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        serverLevel.broadcastEntityEvent((Entity)this, (byte)3);
        for (Entity entity : serverLevel.getEntities((Entity)this, this.getBoundingBox().inflate(5.0), MutantEnderman.ENDER_TARGETS)) {
            boolean hitChance;
            if (this.ownedBy(entity)) continue;
            boolean bl = hitChance = this.random.nextInt(3) != 0;
            if (EndersoulFragment.isProtected(entity)) {
                hitChance = this.random.nextInt(3) == 0;
            } else {
                double x = entity.getX() - this.getX();
                double z = entity.getZ() - this.getZ();
                double d = Math.sqrt(x * x + z * z);
                entity.setDeltaMovement(0.8 * x / d, (double)(this.random.nextFloat() * 0.6f - 0.1f), 0.8 * z / d);
                EntityUtil.sendPlayerVelocityPacket(entity);
            }
            if (!hitChance) continue;
            DamageSource damageSource = DamageHelper.damageSource((LevelReader)serverLevel, ModRegistry.ENDERSOUL_FRAGMENT_EXPLOSION_DAMAGE_TYPE, (Entity)this, (Entity)(this.spawner != null ? this.spawner : this));
            entity.hurtServer(serverLevel, damageSource, 1.0f);
        }
        this.discard();
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        valueOutput.storeNullable("Owner", UUIDUtil.CODEC, (Object)this.ownerUUID);
        valueOutput.putInt("ExplodeTick", this.explodeTick);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        this.setOwnerThroughUUID(valueInput.read("Owner", UUIDUtil.CODEC).orElse(null));
        valueInput.getInt("ExplodeTick").ifPresent(this::setExplodeTick);
    }
}

