/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Locale;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantSkeletonBodyPart
extends Entity
implements TraceableEntity {
    static final String TAG_BODY_PART = "BodyPart";
    static final String TAG_DESPAWN_TIMER = "DespawnTimer";
    private static final EntityDataAccessor<BodyPart> DATA_BODY_PART = SynchedEntityData.defineId(MutantSkeletonBodyPart.class, (EntityDataSerializer)((EntityDataSerializer)ModRegistry.BODY_PART_ENTITY_DATA_SERIALIZER.value()));
    private final InterpolationHandler interpolation = new InterpolationHandler((Entity)this);
    private final boolean yawPositive;
    private final boolean pitchPositive;
    @Nullable
    private Mob owner;
    private int despawnTimer;

    public MutantSkeletonBodyPart(EntityType<? extends MutantSkeletonBodyPart> type, Level level) {
        super(type, level);
        this.setYRot(this.random.nextFloat() * 360.0f);
        this.yRotO = this.getYRot();
        this.setXRot(this.random.nextFloat() * 360.0f);
        this.xRotO = this.getXRot();
        this.yawPositive = this.random.nextBoolean();
        this.pitchPositive = this.random.nextBoolean();
    }

    public MutantSkeletonBodyPart(Level level, Mob owner, BodyPart bodyPart) {
        this((EntityType<? extends MutantSkeletonBodyPart>)((EntityType)ModEntityTypes.BODY_PART_ENTITY_TYPE.value()), level);
        this.owner = owner;
        this.setBodyPart(bodyPart);
        this.setPos(owner.getX(), owner.getY() + (double)(3.2f * (0.25f + this.random.nextFloat() * 0.5f)), owner.getZ());
        this.setRemainingFireTicks(owner.getRemainingFireTicks());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_BODY_PART, (Object)BodyPart.PELVIS);
    }

    public BodyPart getBodyPart() {
        return (BodyPart)((Object)this.entityData.get(DATA_BODY_PART));
    }

    private void setBodyPart(BodyPart bodyPart) {
        this.entityData.set(DATA_BODY_PART, (Object)bodyPart);
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getLegacyItemByPart());
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        return false;
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }

    public void restoreFrom(Entity entity) {
        super.restoreFrom(entity);
        if (entity instanceof MutantSkeletonBodyPart) {
            MutantSkeletonBodyPart mutantSkeletonBodyPart = (MutantSkeletonBodyPart)entity;
            this.owner = mutantSkeletonBodyPart.owner;
        }
    }

    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.045, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.96));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.7));
        }
        if (!this.onGround() && this.stuckSpeedMultiplier == Vec3.ZERO) {
            this.setYRot(this.getYRot() + 10.0f * (float)(this.yawPositive ? 1 : -1));
            this.setXRot(this.getXRot() + 15.0f * (float)(this.pitchPositive ? 1 : -1));
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (Entity entity : serverLevel.getEntities((Entity)this, this.getBoundingBox(), this::canHarm)) {
                    float damageAmount;
                    DamageSource damageSource;
                    if (!entity.hurtServer(serverLevel, damageSource = serverLevel.damageSources().thrown((Entity)this, (Entity)(this.owner != null ? this.owner : this)), damageAmount = 4.0f + (float)this.random.nextInt(4))) continue;
                    entity.igniteForSeconds((float)this.getRemainingFireTicks() / 20.0f);
                }
            }
            if (this.despawnTimer > 0) {
                --this.despawnTimer;
            }
        } else {
            ++this.despawnTimer;
        }
        if (!this.level().isClientSide && this.despawnTimer >= this.getMaxAge()) {
            this.discard();
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ServerLevel serverLevel;
        Level level = this.level();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ResourceKey<LootTable> resourceKey = this.getItemPartLootTableId();
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(resourceKey);
            LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(ModRegistry.BODY_PART_LOOT_CONTEXT_PARAM_SET);
            ObjectArrayList list = lootTable.getRandomItems(lootParams);
            for (ItemStack item : list) {
                if (item.isEmpty()) continue;
                this.spawnAtLocation(serverLevel, item).setNoPickUpDelay();
            }
        }
        this.discard();
        return InteractionResultHelper.sidedSuccess((boolean)this.level().isClientSide);
    }

    private boolean canHarm(Entity entity) {
        return entity.isPickable() && entity.getType() != ModEntityTypes.MUTANT_SKELETON_ENTITY_TYPE.value();
    }

    protected Component getTypeName() {
        return Component.translatable((String)this.getLegacyItemByPart().getDescriptionId());
    }

    private Item getLegacyItemByPart() {
        return (Item)this.getBodyPart().group.item.get().value();
    }

    private ResourceKey<LootTable> getItemPartLootTableId() {
        return this.getBodyPart().group.lootTable.get();
    }

    public int getMaxAge() {
        return 6000;
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        valueOutput.store(TAG_BODY_PART, BodyPart.CODEC, (Object)this.getBodyPart());
        valueOutput.putInt(TAG_DESPAWN_TIMER, this.despawnTimer);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        valueInput.read(TAG_BODY_PART, BodyPart.CODEC).ifPresent(this::setBodyPart);
        this.despawnTimer = valueInput.getIntOr(TAG_DESPAWN_TIMER, 0);
    }

    @Nullable
    public Entity getOwner() {
        return this.owner;
    }

    public static enum BodyPart implements StringRepresentable
    {
        PELVIS(BodyPartGroup.PELVIS),
        LEFT_UPPER_RIB(BodyPartGroup.RIB),
        RIGHT_UPPER_RIB(BodyPartGroup.RIB),
        LEFT_MIDDLE_RIB(BodyPartGroup.RIB),
        RIGHT_MIDDLE_RIB(BodyPartGroup.RIB),
        LEFT_LOWER_RIB(BodyPartGroup.RIB),
        RIGHT_LOWER_RIB(BodyPartGroup.RIB),
        HEAD(BodyPartGroup.SKULL),
        LEFT_ARM(BodyPartGroup.LIMB),
        RIGHT_ARM(BodyPartGroup.LIMB),
        LEFT_FORE_ARM(BodyPartGroup.LIMB),
        RIGHT_FORE_ARM(BodyPartGroup.LIMB),
        LEFT_LEG(BodyPartGroup.LIMB),
        RIGHT_LEG(BodyPartGroup.LIMB),
        LEFT_FORE_LEG(BodyPartGroup.LIMB),
        RIGHT_FORE_LEG(BodyPartGroup.LIMB),
        LEFT_SHOULDER(BodyPartGroup.SHOULDER),
        RIGHT_SHOULDER(BodyPartGroup.SHOULDER);

        private static final BodyPart[] VALUES;
        public static final StringRepresentable.StringRepresentableCodec<BodyPart> CODEC;
        public static final IntFunction<BodyPart> BY_ID;
        public static final StreamCodec<ByteBuf, BodyPart> STREAM_CODEC;
        public final BodyPartGroup group;

        private BodyPart(BodyPartGroup group) {
            this.group = group;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = BodyPart.values();
            CODEC = StringRepresentable.fromEnum(() -> VALUES);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])VALUES, (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }

    public static enum BodyPartGroup {
        PELVIS(() -> ModItems.MUTANT_SKELETON_PELVIS_ITEM, () -> ModRegistry.MUTANT_SKELETON_PELVIS_LOOT_TABLE),
        RIB(() -> ModItems.MUTANT_SKELETON_RIB_ITEM, () -> ModRegistry.MUTANT_SKELETON_RIB_LOOT_TABLE),
        SKULL(() -> ModItems.MUTANT_SKELETON_SKULL_ITEM, () -> ModRegistry.MUTANT_SKELETON_SKULL_LOOT_TABLE),
        LIMB(() -> ModItems.MUTANT_SKELETON_LIMB_ITEM, () -> ModRegistry.MUTANT_SKELETON_LIMB_LOOT_TABLE),
        SHOULDER(() -> ModItems.MUTANT_SKELETON_SHOULDER_PAD_ITEM, () -> ModRegistry.MUTANT_SKELETON_SHOULDER_PAD_LOOT_TABLE);

        public final Supplier<Holder.Reference<Item>> item;
        public final Supplier<ResourceKey<LootTable>> lootTable;

        private BodyPartGroup(Supplier<Holder.Reference<Item>> item, Supplier<ResourceKey<LootTable>> lootTable) {
            this.item = item;
            this.lootTable = lootTable;
        }
    }
}

