/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.world.effect.ChemicalXMobEffect;
import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.UUIDLookup;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SkullSpirit
extends Entity {
    private static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> DATA_TARGETUUID_ID = SynchedEntityData.defineId(SkullSpirit.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);
    private static final EntityDataAccessor<Boolean> DATA_ATTACHED = SynchedEntityData.defineId(SkullSpirit.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int startTick = 15;
    private int attachedTick = 80 + this.random.nextInt(40);
    @Nullable
    private UUID conversionStarter;

    public SkullSpirit(EntityType<? extends SkullSpirit> type, Level level) {
        super(type, level);
        this.noPhysics = true;
    }

    public SkullSpirit(Level level, Mob target, @Nullable UUID conversionStarter) {
        this((EntityType<? extends SkullSpirit>)((EntityType)ModEntityTypes.SKULL_SPIRIT_ENTITY_TYPE.value()), level);
        this.setTarget((LivingEntity)target);
        this.conversionStarter = conversionStarter;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_TARGETUUID_ID, Optional.empty());
        builder.define(DATA_ATTACHED, (Object)false);
    }

    @Nullable
    public LivingEntity getTarget() {
        return (LivingEntity)EntityReference.get(this.getTargetReference(), (UUIDLookup)this.level(), LivingEntity.class);
    }

    @Nullable
    public EntityReference<LivingEntity> getTargetReference() {
        return ((Optional)this.entityData.get(DATA_TARGETUUID_ID)).orElse(null);
    }

    public void setTarget(@Nullable LivingEntity livingEntity) {
        this.entityData.set(DATA_TARGETUUID_ID, Optional.ofNullable(livingEntity).map(EntityReference::new));
    }

    public void setTargetReference(@Nullable EntityReference<LivingEntity> entityReference) {
        this.entityData.set(DATA_TARGETUUID_ID, Optional.ofNullable(entityReference));
    }

    public boolean isAttached() {
        return (Boolean)this.entityData.get(DATA_ATTACHED);
    }

    private void setAttached(boolean attached) {
        this.entityData.set(DATA_ATTACHED, (Object)attached);
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public void tick() {
        Mob target;
        LivingEntity livingEntity = this.getTarget();
        if (livingEntity instanceof Mob && (target = (Mob)livingEntity).isAlive()) {
            if (this.isAttached()) {
                if (!this.level().isClientSide) {
                    target.setDeltaMovement((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), target.getDeltaMovement().y, (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f));
                    if (--this.attachedTick <= 0) {
                        EntityType<?> mutantType = ChemicalXMobEffect.getMutantOf(target);
                        if (mutantType != null && this.random.nextInt(4) != 0) {
                            MutatedExplosionHelper.explode(this, 2.0f, false, Level.ExplosionInteraction.NONE);
                            Mob mob = target.convertTo(mutantType, ConversionParams.single((Mob)target, (boolean)true, (boolean)true), Function.identity()::apply);
                            if (mob != null) {
                                Player player;
                                mob.setPersistenceRequired();
                                AABB boundingBox = mob.getBoundingBox();
                                for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)boundingBox.minX), (int)Mth.floor((double)mob.getY()), (int)Mth.floor((double)boundingBox.minZ), (int)Mth.floor((double)boundingBox.maxX), (int)Mth.floor((double)boundingBox.maxY), (int)Mth.floor((double)boundingBox.maxZ))) {
                                    if (!(this.level().getBlockState(pos).getDestroySpeed((BlockGetter)this.level(), pos) > -1.0f)) continue;
                                    this.level().destroyBlock(pos, true);
                                }
                                if (this.conversionStarter != null && (player = this.level().getPlayerByUUID(this.conversionStarter)) instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, (Entity)mob);
                                }
                            }
                        } else {
                            this.setAttached(false);
                            MutatedExplosionHelper.explode(this, 2.0f, false, Level.ExplosionInteraction.NONE);
                        }
                        this.discard();
                    }
                }
                this.setPos(target.getX(), target.getY(), target.getZ());
                if (this.random.nextInt(8) == 0) {
                    target.hurt(this.level().damageSources().magic(), 0.0f);
                }
                for (int i = 0; i < 3; ++i) {
                    double posX = target.getX() + (double)(this.random.nextFloat() * target.getBbWidth() * 2.0f) - (double)target.getBbWidth();
                    double posY = target.getY() + 0.5 + (double)(this.random.nextFloat() * target.getBbHeight());
                    double posZ = target.getZ() + (double)(this.random.nextFloat() * target.getBbWidth() * 2.0f) - (double)target.getBbWidth();
                    double x = this.random.nextGaussian() * 0.02;
                    double y = this.random.nextGaussian() * 0.02;
                    double z = this.random.nextGaussian() * 0.02;
                    this.level().addParticle((ParticleOptions)ModRegistry.SKULL_SPIRIT_PARTICLE_TYPE.value(), posX, posY, posZ, x, y, z);
                }
            } else {
                double z;
                double y;
                double x;
                double d;
                this.xo = this.getX();
                this.yo = this.getY();
                this.zo = this.getZ();
                this.setDeltaMovement(Vec3.ZERO);
                if (this.startTick-- >= 0) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(0.3f * (float)this.startTick / 15.0f), 0.0));
                }
                if ((d = Math.sqrt((x = target.getX() - this.getX()) * x + (y = target.getY() - this.getY()) * y + (z = target.getZ() - this.getZ()) * z)) != 0.0) {
                    this.setDeltaMovement(this.getDeltaMovement().add(x / d * 0.2, y / d * 0.2, z / d * 0.2));
                    this.move(MoverType.SELF, this.getDeltaMovement());
                }
                if (!this.level().isClientSide && this.distanceToSqr((Entity)target) < 1.0) {
                    this.setAttached(true);
                }
                for (int i = 0; i < 16; ++i) {
                    float xx = (this.random.nextFloat() - 0.5f) * 1.2f;
                    float yy = (this.random.nextFloat() - 0.5f) * 1.2f;
                    float zz = (this.random.nextFloat() - 0.5f) * 1.2f;
                    this.level().addParticle((ParticleOptions)ModRegistry.SKULL_SPIRIT_PARTICLE_TYPE.value(), this.getX() + (double)xx, this.getY() + (double)yy, this.getZ() + (double)zz, 0.0, 0.0, 0.0);
                }
            }
        } else {
            this.discard();
        }
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        return false;
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        valueOutput.putBoolean("Attached", this.isAttached());
        valueOutput.putInt("AttachedTick", this.attachedTick);
        EntityReference<LivingEntity> entityReference = this.getTargetReference();
        if (entityReference != null) {
            entityReference.store(valueOutput, "Target");
        }
        valueOutput.storeNullable("ConversionPlayer", UUIDUtil.CODEC, (Object)this.conversionStarter);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        this.setAttached(valueInput.getBooleanOr("Attached", false));
        this.attachedTick = valueInput.getIntOr("AttachedTick", 0);
        this.setTargetReference((EntityReference<LivingEntity>)EntityReference.read((ValueInput)valueInput, (String)"Target"));
        this.conversionStarter = valueInput.read("ConversionPlayer", UUIDUtil.CODEC).orElse(null);
    }
}

