/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.ai.goal;

import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class AvoidDamageGoal
extends PanicGoal {
    private final BooleanSupplier avoidsAttacker;

    public AvoidDamageGoal(PathfinderMob creature, double speed) {
        this(creature, speed, () -> false);
    }

    public AvoidDamageGoal(PathfinderMob creature, double speed, BooleanSupplier avoidsAttacker) {
        super(creature, speed);
        this.avoidsAttacker = avoidsAttacker;
    }

    public boolean canUse() {
        if (this.mob.isOnFire() && !this.mob.isSensitiveToWater()) {
            BlockPos blockpos;
            if (this.mob.level().isRaining()) {
                for (int i = 0; i < 10; ++i) {
                    BlockPos blockpos1 = this.mob.blockPosition().offset(this.mob.getRandom().nextInt(20) - 10, this.mob.getRandom().nextInt(6) - 3, this.mob.getRandom().nextInt(20) - 10);
                    if (!this.mob.level().isRainingAt(blockpos1) || !(this.mob.getWalkTargetValue(blockpos1) >= 0.0f)) continue;
                    return this.hasPosition(Vec3.atBottomCenterOf((Vec3i)blockpos1));
                }
            }
            return (blockpos = this.lookForWater((BlockGetter)this.mob.level(), (Entity)this.mob, 15)) != null && this.mob.getNavigation().createPath(blockpos, 0) != null && this.hasPosition(Vec3.atLowerCornerOf((Vec3i)blockpos)) || this.findRandomPosition();
        }
        if (this.avoidsAttacker.getAsBoolean() && this.mob.getLastHurtByMob() != null) {
            return this.hasPosition(DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)10, (int)9, (Vec3)this.mob.getLastHurtByMob().position()));
        }
        if (this.mob.getLastDamageSource() != null && this.shouldAvoidDamage(this.mob.getLastDamageSource())) {
            Vec3 damageVec = this.mob.getLastDamageSource().getSourcePosition();
            return damageVec != null ? this.hasPosition(DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)8, (int)5, (Vec3)damageVec)) : this.findRandomPosition();
        }
        return false;
    }

    private boolean hasPosition(Vec3 vec3d) {
        if (vec3d == null) {
            return false;
        }
        this.posX = vec3d.x;
        this.posY = vec3d.y;
        this.posZ = vec3d.z;
        return true;
    }

    protected boolean shouldAvoidDamage(DamageSource source) {
        if (source.getEntity() != null) {
            return false;
        }
        if (source.is(DamageTypeTags.WITCH_RESISTANT_TO) && source.getDirectEntity() == null) {
            return false;
        }
        return !source.is(DamageTypes.DROWN) && !source.is(DamageTypes.FALL) && !source.is(DamageTypes.STARVE) && !source.is(DamageTypes.FELL_OUT_OF_WORLD);
    }
}

