/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.init.ModTags;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.EndersoulClone;
import fuzs.mutantmonsters.world.entity.EndersoulFragment;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.animation.AdditionalSpawnDataEntity;
import fuzs.mutantmonsters.world.entity.animation.AnimatedEntity;
import fuzs.mutantmonsters.world.entity.animation.EntityAnimation;
import fuzs.mutantmonsters.world.entity.mutant.MutantMonster;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import fuzs.puzzleslib.api.util.v1.DamageHelper;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantEnderman
extends MutantMonster
implements NeutralMob,
AnimatedEntity {
    public static final Predicate<Entity> ENDER_TARGETS = EntitySelector.LIVING_ENTITY_STILL_ALIVE.and(EntitySelector.NO_CREATIVE_OR_SPECTATOR).and(entity -> !entity.getType().is(ModTags.ENDER_FRIENDS_ENTITY_TYPE_TAG));
    private static final ResourceLocation STEP_HEIGHT_MODIFIER_CLONING_ID = MutantMonsters.id("cloning");
    private static final AttributeModifier STEP_HEIGHT_MODIFIER_CLONING = new AttributeModifier(STEP_HEIGHT_MODIFIER_CLONING_ID, -0.4, AttributeModifier.Operation.ADD_VALUE);
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_TELEPORT_POSITION = SynchedEntityData.defineId(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Byte> DATA_ACTIVE_ARM = SynchedEntityData.defineId(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> DATA_CLONE = SynchedEntityData.defineId(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final List<EntityDataAccessor<Optional<BlockState>>> DATA_HELD_BLOCKS = ImmutableList.of((Object)SynchedEntityData.defineId(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_STATE), (Object)SynchedEntityData.defineId(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_STATE), (Object)SynchedEntityData.defineId(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_STATE), (Object)SynchedEntityData.defineId(MutantEnderman.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_STATE));
    public static final EntityAnimation MELEE_ANIMATION = new EntityAnimation("mutant_enderman_melee", 10);
    public static final EntityAnimation THROW_ANIMATION = new EntityAnimation("mutant_enderman_throw", 14);
    public static final EntityAnimation STARE_ANIMATION = new EntityAnimation("mutant_enderman_stare", 100);
    public static final EntityAnimation TELEPORT_ANIMATION = new EntityAnimation("mutant_enderman_teleport", 10);
    public static final EntityAnimation SCREAM_ANIMATION = new EntityAnimation("mutant_enderman_scream", 165);
    public static final EntityAnimation CLONE_ANIMATION = new EntityAnimation("mutant_enderman_clone", 600);
    public static final EntityAnimation TELESMASH_ANIMATION = new EntityAnimation("mutant_enderman_telesmash", 30);
    public static final EntityAnimation DEATH_ANIMATION = new EntityAnimation("mutant_enderman_death", 280);
    private static final EntityAnimation[] ANIMATIONS = new EntityAnimation[]{MELEE_ANIMATION, THROW_ANIMATION, STARE_ANIMATION, TELEPORT_ANIMATION, SCREAM_ANIMATION, CLONE_ANIMATION, TELESMASH_ANIMATION, DEATH_ANIMATION};
    private EntityAnimation animation;
    private int animationTick;
    private int prevArmScale;
    private int armScale;
    public int hasTargetTicks;
    private int screamDelayTick;
    public final int[] heldBlockTicks = new int[DATA_HELD_BLOCKS.size()];
    private boolean triggerThrowBlock;
    private int blockFrenzy;
    @Nullable
    private List<Entity> capturedEntities;
    private DamageSource deathCause;
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public MutantEnderman(EntityType<? extends MutantEnderman> entityType, Level level) {
        super(entityType, level);
        this.animation = EntityAnimation.NONE;
        this.xpReward = 50;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new ThrowBlockGoal(this));
        this.goalSelector.addGoal(1, (Goal)new StareGoal(this));
        this.goalSelector.addGoal(1, (Goal)new TeleportGoal(this));
        this.goalSelector.addGoal(1, (Goal)new ScreamGoal(this));
        this.goalSelector.addGoal(1, (Goal)new CloneGoal(this));
        this.goalSelector.addGoal(1, (Goal)new TeleSmashGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.2).setMaxAttackTick(15));
        this.goalSelector.addGoal(3, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new FindTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MutantEnderman.createMonsterAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.ATTACK_DAMAGE, 7.0).add(Attributes.FOLLOW_RANGE, 96.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.4);
    }

    public static boolean checkMutantEndermanSpawnRules(EntityType<MutantEnderman> entityType, ServerLevelAccessor serverLevel, EntitySpawnReason entitySpawnReason, BlockPos blockPos, RandomSource randomSource) {
        return randomSource.nextInt(3) == 0 && MutantEnderman.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)serverLevel, (EntitySpawnReason)entitySpawnReason, (BlockPos)blockPos, (RandomSource)randomSource);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TELEPORT_POSITION, Optional.empty());
        builder.define(DATA_ACTIVE_ARM, (Object)0);
        builder.define(DATA_CLONE, (Object)false);
        for (EntityDataAccessor<Optional<BlockState>> dataHeldBlock : DATA_HELD_BLOCKS) {
            builder.define(dataHeldBlock, Optional.empty());
        }
    }

    public Optional<BlockPos> getTeleportPosition() {
        return (Optional)this.entityData.get(DATA_TELEPORT_POSITION);
    }

    private void setTeleportPosition(@Nullable BlockPos pos) {
        this.entityData.set(DATA_TELEPORT_POSITION, Optional.ofNullable(pos));
    }

    public Optional<BlockState> getHeldBlock(int armIndex) {
        return (Optional)this.entityData.get(DATA_HELD_BLOCKS.get(armIndex));
    }

    public void setHeldBlock(int armIndex, Optional<BlockState> blockState, int tick) {
        this.entityData.set(DATA_HELD_BLOCKS.get(armIndex), blockState);
        this.heldBlockTicks[armIndex] = tick;
    }

    private HeldBlock packHeldBlock(int armIndex) {
        return new HeldBlock(this.getHeldBlock(armIndex), this.heldBlockTicks[armIndex]);
    }

    private void unpackHeldBlock(int armIndex, HeldBlock heldBlock) {
        this.setHeldBlock(armIndex, heldBlock.blockState(), heldBlock.heldTicks());
    }

    public int getActiveArm() {
        return ((Byte)this.entityData.get(DATA_ACTIVE_ARM)).byteValue();
    }

    private void setActiveArm(int armId) {
        this.entityData.set(DATA_ACTIVE_ARM, (Object)((byte)armId));
    }

    public boolean isClone() {
        return (Boolean)this.entityData.get(DATA_CLONE);
    }

    private void setClone(boolean isClone) {
        this.entityData.set(DATA_CLONE, (Object)isClone);
        this.playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_MORPH_SOUND_EVENT.value(), 2.0f, this.getVoicePitch());
        this.level().broadcastEntityEvent((Entity)this, (byte)0);
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.angerTime = angerTime;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID angerTarget) {
        this.angerTarget = angerTarget;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    @Override
    public EntityAnimation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(EntityAnimation animation) {
        this.animation = animation;
    }

    @Override
    public EntityAnimation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isClone()) {
            return ((EntityType)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.value()).getDimensions();
        }
        return super.getDefaultDimensions(pose);
    }

    protected void tickHeadTurn(float renderYawOffset) {
        if (this.deathTime <= 0) {
            super.tickHeadTurn(renderYawOffset);
        }
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public int getMaxFallDistance() {
        return this.isClone() ? 3 : super.getMaxFallDistance();
    }

    public boolean isPickable() {
        return super.isPickable() && this.animation != TELEPORT_ANIMATION;
    }

    protected void updateNoActionTime() {
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (DATA_CLONE.equals(key)) {
            this.refreshDimensions();
        }
        if (DATA_TELEPORT_POSITION.equals(key) && this.getTeleportPosition().isPresent() && this.level().isClientSide) {
            this.animation = TELEPORT_ANIMATION;
            this.animationTick = 0;
            this.spawnTeleportParticles();
        }
    }

    public void setTarget(@Nullable LivingEntity entitylivingbaseIn) {
        super.setTarget(entitylivingbaseIn);
        this.setAggressive(entitylivingbaseIn != null);
    }

    public float getArmScale(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevArmScale, (float)this.armScale) / 10.0f;
    }

    private void updateTargetTick() {
        this.prevArmScale = this.armScale;
        if (this.isAggressive()) {
            this.hasTargetTicks = 20;
        }
        boolean emptyHanded = true;
        for (int i = 0; i < DATA_HELD_BLOCKS.size(); ++i) {
            if (this.getHeldBlock(i).isPresent()) {
                emptyHanded = false;
            }
            if (this.hasTargetTicks > 0) {
                if (!this.getHeldBlock(i).isPresent()) continue;
                this.heldBlockTicks[i] = Math.min(10, this.heldBlockTicks[i] + 1);
                continue;
            }
            this.heldBlockTicks[i] = Math.max(0, this.heldBlockTicks[i] - 1);
        }
        if (this.hasTargetTicks > 0) {
            this.armScale = Math.min(10, this.armScale + 1);
        } else if (emptyHanded) {
            this.armScale = Math.max(0, this.armScale - 1);
        } else {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                boolean mobGriefing = EntityHelper.isMobGriefingAllowed((ServerLevel)serverLevel, (Entity)this);
                for (int i = 0; i < DATA_HELD_BLOCKS.size(); ++i) {
                    if (!this.getHeldBlock(i).isPresent() || this.heldBlockTicks[i] != 0) continue;
                    BlockPos startPos = BlockPos.containing((double)(this.getX() - 1.5 + this.random.nextDouble() * 4.0), (double)(this.getY() - 0.5 + this.random.nextDouble() * 2.5), (double)(this.getZ() - 1.5 + this.random.nextDouble() * 4.0));
                    BlockState heldState = Block.updateFromNeighbourShapes((BlockState)this.getHeldBlock(i).orElseThrow(), (LevelAccessor)serverLevel, (BlockPos)startPos);
                    if (mobGriefing && this.canPlaceBlock((Level)serverLevel, startPos, heldState, startPos.below())) {
                        serverLevel.setBlockAndUpdate(startPos, heldState);
                        SoundType soundType = heldState.getSoundType();
                        serverLevel.playSound(null, startPos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                        this.setHeldBlock(i, Optional.empty(), 0);
                        continue;
                    }
                    if (mobGriefing && this.random.nextInt(50) != 0) continue;
                    this.triggerThrowBlock = true;
                }
            }
        }
        this.hasTargetTicks = Math.max(0, this.hasTargetTicks - 1);
    }

    private boolean canPlaceBlock(Level level, BlockPos startPos, BlockState blockState, BlockPos belowPos) {
        return level.isEmptyBlock(startPos) && !level.isEmptyBlock(belowPos) && level.getBlockState(belowPos).isCollisionShapeFullBlock((BlockGetter)level, belowPos) && blockState.canSurvive((LevelReader)level, startPos) && level.getEntities((Entity)this, new AABB(startPos)).isEmpty();
    }

    private void updateScreamEntities() {
        if (this.screamDelayTick > 0) {
            --this.screamDelayTick;
        }
        if (this.animation == SCREAM_ANIMATION && this.animationTick >= 40 && this.animationTick <= 160) {
            if (this.animationTick == 160) {
                this.capturedEntities = null;
            } else if (this.capturedEntities == null) {
                this.capturedEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(20.0, 12.0, 20.0), ENDER_TARGETS);
            } else {
                Iterator<Entity> iterator = this.capturedEntities.iterator();
                while (iterator.hasNext()) {
                    Entity entity = iterator.next();
                    if (!(this.distanceToSqr(entity) > 400.0) && !entity.isSpectator()) {
                        entity.setXRot(entity.getXRot() + (this.random.nextFloat() - 0.3f) * 6.0f);
                        continue;
                    }
                    iterator.remove();
                }
            }
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 0) {
            this.spawnTeleportParticles();
        } else {
            super.handleEntityEvent(id);
        }
    }

    @Override
    public void aiStep() {
        this.jumping = false;
        super.aiStep();
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.animation == DEATH_ANIMATION) {
            this.deathTime = this.animationTick;
        }
        this.updateTargetTick();
        this.updateScreamEntities();
        if (this.level().isClientSide && !this.isClone()) {
            for (int i = 0; i < 3; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(0.5), this.getRandomY() + (double)(this.deathTime > 0 ? 1.0f : 0.0f) - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    private void updateBlockFrenzy(ServerLevel serverLevel) {
        this.blockFrenzy = Math.max(0, this.blockFrenzy - 1);
        if (this.getTarget() != null && !this.isAnimationPlaying()) {
            if (this.blockFrenzy == 0 && (this.getLastDamageSource() != null && !this.getLastDamageSource().isDirect() || this.random.nextInt(!this.isPathFinding() ? 300 : 600) == 0)) {
                this.blockFrenzy = 200 + this.random.nextInt(80);
            }
            if (this.blockFrenzy > 0 && this.random.nextInt(8) == 0) {
                int armIndex = this.getFavorableHand();
                BlockPos pos = BlockPos.containing((double)(this.getX() - 2.5 + this.random.nextDouble() * 5.0), (double)(this.getY() - 0.5 + this.random.nextDouble() * 3.0), (double)(this.getZ() - 2.5 + this.random.nextDouble() * 5.0));
                BlockState blockState = serverLevel.getBlockState(pos);
                if (armIndex != -1 && MutantEnderman.canBlockBeHeld((Level)serverLevel, pos, blockState, ModTags.MUTANT_ENDERMAN_HOLDABLE_IMMUNE_BLOCK_TAG)) {
                    this.setHeldBlock(armIndex, Optional.of(blockState), 0);
                    if (EntityHelper.isMobGriefingAllowed((ServerLevel)serverLevel, (Entity)this)) {
                        serverLevel.removeBlock(pos, false);
                    }
                }
            }
        }
    }

    public static boolean canBlockBeHeld(Level level, BlockPos blockPos, BlockState blockState, TagKey<Block> tagKey) {
        if (blockState.isCollisionShapeFullBlock((BlockGetter)level, blockPos) && !blockState.hasBlockEntity() && !blockState.is(tagKey)) {
            float destroySpeed = blockState.getDestroySpeed((BlockGetter)level, blockPos);
            return destroySpeed >= 0.0f && destroySpeed < 50.0f;
        }
        return false;
    }

    private void updateTeleport() {
        LivingEntity entity = this.getTarget();
        this.teleportByChance(entity == null ? 1600 : 800, (Entity)entity);
        if (this.isInWater() || this.fallDistance > 3.0 || entity != null && (this.isPassengerOfSameVehicle((Entity)entity) || this.distanceToSqr((Entity)entity) > 1024.0 || !this.isPathFinding())) {
            this.teleportByChance(10, (Entity)entity);
        }
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        this.updatePersistentAnger(serverLevel, true);
        this.updateBlockFrenzy(serverLevel);
        this.updateTeleport();
        super.customServerAiStep(serverLevel);
    }

    private int getAvailableHand() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < DATA_HELD_BLOCKS.size(); ++i) {
            if (!this.getHeldBlock(i).isEmpty()) continue;
            list.add(i);
        }
        if (list.isEmpty()) {
            return -1;
        }
        return (Integer)list.get(this.random.nextInt(list.size()));
    }

    private int getFavorableHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 0; i < DATA_HELD_BLOCKS.size(); ++i) {
            if (!this.getHeldBlock(i).isEmpty()) continue;
            if (i <= 1) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!outer.isEmpty()) {
            return (Integer)outer.get(this.random.nextInt(outer.size()));
        }
        return (Integer)inner.get(this.random.nextInt(inner.size()));
    }

    private int getThrowingHand() {
        ArrayList<Integer> outer = new ArrayList<Integer>();
        ArrayList<Integer> inner = new ArrayList<Integer>();
        for (int i = 0; i < DATA_HELD_BLOCKS.size(); ++i) {
            if (!this.getHeldBlock(i).isPresent()) continue;
            if (i <= 1) {
                outer.add(i);
                continue;
            }
            inner.add(i);
        }
        if (outer.isEmpty() && inner.isEmpty()) {
            return -1;
        }
        if (!inner.isEmpty()) {
            return (Integer)inner.get(this.random.nextInt(inner.size()));
        }
        return (Integer)outer.get(this.random.nextInt(outer.size()));
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity entity) {
        if (!this.isAnimationPlaying()) {
            int arm = this.getAvailableHand();
            if (!this.teleportByChance(6, entity)) {
                if (arm != -1) {
                    boolean allHandsFree = this.allHandsFree();
                    if (allHandsFree && entity.getType() != EntityType.WITHER && this.random.nextInt(10) == 0) {
                        this.animation = CLONE_ANIMATION;
                    } else if (allHandsFree && this.random.nextInt(7) == 0) {
                        this.animation = TELESMASH_ANIMATION;
                    } else {
                        this.setActiveArm(arm);
                        this.animation = MELEE_ANIMATION;
                    }
                } else {
                    this.triggerThrowBlock = true;
                }
            }
        }
        if (this.isClone()) {
            DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)this);
            boolean hurt = entity.hurtServer(serverLevel, damageSource, (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE));
            if (this.random.nextInt(2) == 0) {
                double x = entity.getX() + (this.random.nextDouble() - 0.5) * 24.0;
                double y = entity.getY() + (double)this.random.nextInt(5) + 4.0;
                double z = entity.getZ() + (this.random.nextDouble() - 0.5) * 24.0;
                this.teleportToPosition(x, y, z);
            }
            if (hurt) {
                this.heal(2.0f);
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)entity, (DamageSource)damageSource);
            }
            this.swing(InteractionHand.MAIN_HAND);
            return hurt;
        }
        return true;
    }

    private boolean allHandsFree() {
        return this.getHeldBlock(0).isEmpty() && this.getHeldBlock(1).isEmpty();
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float damageAmount) {
        if (this.isInvulnerableTo(serverLevel, damageSource)) {
            return false;
        }
        if (!(damageSource.getEntity() instanceof EnderDragon) && !(damageSource.getEntity() instanceof MutantEnderman)) {
            if (!(this.animation != TELEPORT_ANIMATION && this.animation != SCREAM_ANIMATION || damageSource.is(DamageTypes.FELL_OUT_OF_WORLD))) {
                return false;
            }
            boolean hurt = super.hurtServer(serverLevel, damageSource, damageAmount);
            if (hurt && this.animation == STARE_ANIMATION) {
                this.animation = EntityAnimation.NONE;
                return true;
            }
            if (!this.isAnimationPlaying() && this.isAlive()) {
                Entity entity = damageSource.getEntity();
                boolean isDodgingPossible = entity == null || damageSource.is(ModTags.MUTANT_ENDERMAN_DODGE_DAMAGE_TYPE_TAG);
                if (this.teleportByChance(isDodgingPossible ? 3 : 6, entity)) {
                    if (entity instanceof LivingEntity) {
                        this.setLastHurtByMob((LivingEntity)entity);
                    }
                    return false;
                }
                this.teleportByChance(damageSource.is(DamageTypeTags.BYPASSES_ARMOR) ? 3 : 5, entity);
            }
            return hurt;
        }
        return false;
    }

    public boolean addEffect(MobEffectInstance mobEffect, @Nullable Entity entity) {
        return !this.isClone() && super.addEffect(mobEffect, entity);
    }

    private boolean teleportByChance(int chance, @Nullable Entity entity) {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        if (this.random.nextInt(Math.max(1, chance)) == 0) {
            return entity == null ? this.teleportRandomly() : this.teleportToEntity(entity);
        }
        return false;
    }

    private boolean teleportRandomly() {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double radius = 24.0;
        double x = this.getX() + (this.random.nextDouble() - 0.5) * 2.0 * radius;
        double y = this.getY() + (double)this.random.nextInt((int)radius * 2) - radius;
        double z = this.getZ() + (this.random.nextDouble() - 0.5) * 2.0 * radius;
        return this.teleportToPosition(x, y, z);
    }

    private boolean teleportToEntity(Entity entity) {
        if (this.isAnimationPlaying() && !this.isClone()) {
            return false;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double radius = 16.0;
        if (this.distanceToSqr(entity) < 100.0) {
            x = entity.getX() + (this.random.nextDouble() - 0.5) * 2.0 * radius;
            y = entity.getY() + this.random.nextDouble() * radius;
            z = entity.getZ() + (this.random.nextDouble() - 0.5) * 2.0 * radius;
        } else {
            Vec3 vec = new Vec3(this.getX() - entity.getX(), this.getY(0.5) - entity.getEyeY(), this.getZ() - entity.getZ());
            vec = vec.normalize();
            x = this.getX() + (this.random.nextDouble() - 0.5) * 8.0 - vec.x * radius;
            y = this.getY() + (double)this.random.nextInt(8) - vec.y * radius;
            z = this.getZ() + (this.random.nextDouble() - 0.5) * 8.0 - vec.z * radius;
        }
        return this.teleportToPosition(x, y, z);
    }

    private boolean teleportToPosition(double x, double y, double z) {
        if (!this.isEffectiveAi()) {
            return false;
        }
        if (this.isClone()) {
            boolean flag = EntityUtil.teleportTo((Mob)this, x, y, z);
            if (flag) {
                this.stopRiding();
                if (!this.isSilent()) {
                    this.level().playLocalSound(this.xo, this.yo, this.zo, (SoundEvent)ModSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.value(), this.getSoundSource(), 1.0f, 1.0f, false);
                    this.playSound((SoundEvent)ModSoundEvents.ENTITY_ENDERSOUL_CLONE_TELEPORT_SOUND_EVENT.value(), 1.0f, 1.0f);
                }
            }
            return flag;
        }
        if (this.isAnimationPlaying()) {
            return false;
        }
        this.animation = TELEPORT_ANIMATION;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        boolean success = false;
        if (this.level().isLoaded((BlockPos)pos)) {
            do {
                pos.move(Direction.DOWN);
            } while (pos.getY() > this.level().getMinY() && !this.level().getBlockState((BlockPos)pos).blocksMotion());
            pos.move(Direction.UP);
            AABB aabb = this.getType().getSpawnAABB((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            if (this.level().noCollision((Entity)this, aabb) && !this.level().containsAnyLiquid(aabb)) {
                success = true;
            }
        }
        if (!success) {
            this.animation = EntityAnimation.NONE;
            return false;
        }
        this.setTeleportPosition((BlockPos)pos);
        return true;
    }

    public static void teleportAttack(ServerLevel serverLevel, LivingEntity attacker) {
        double radius = 3.0;
        int duration = 140 + attacker.getRandom().nextInt(60);
        DamageSource damageSource = attacker.damageSources().mobAttack(attacker);
        if (attacker instanceof Player) {
            radius = 2.0;
            duration = 100;
            damageSource = attacker.damageSources().playerAttack((Player)attacker);
        }
        for (Entity entity : serverLevel.getEntities((Entity)attacker, attacker.getBoundingBox().inflate(radius), ENDER_TARGETS)) {
            if (entity instanceof LivingEntity && entity.hurtServer(serverLevel, damageSource, 4.0f) && attacker.getRandom().nextInt(3) == 0) {
                ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.BLINDNESS, duration));
            }
            double x = entity.getX() - attacker.getX();
            double z = entity.getZ() - attacker.getZ();
            double signX = x / Math.abs(x);
            double signZ = z / Math.abs(z);
            entity.setDeltaMovement((radius * signX * 2.0 - x) * 0.2, 0.2, (radius * signZ * 2.0 - z) * 0.2);
            EntityUtil.sendPlayerVelocityPacket(entity);
        }
    }

    private void spawnTeleportParticles() {
        BlockPos teleportPos = this.getTeleportPosition().orElse(null);
        int amount = teleportPos != null ? 512 : 256;
        for (int i = 0; i < amount; ++i) {
            boolean useCurrentPos = teleportPos == null || i < amount / 2;
            double tempX = (useCurrentPos ? this.getX() : (double)teleportPos.getX()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            double tempY = (useCurrentPos ? this.getY() : (double)teleportPos.getY()) + (this.random.nextDouble() - 0.5) * (double)this.getBbHeight() + 1.5;
            double tempZ = (useCurrentPos ? this.getZ() : (double)teleportPos.getZ()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth();
            this.level().addParticle((ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.value(), tempX, tempY, tempZ, (this.random.nextDouble() - 0.5) * 1.8, (this.random.nextDouble() - 0.5) * 1.8, (this.random.nextDouble() - 0.5) * 1.8);
        }
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected void blockedByItem(LivingEntity livingEntity) {
        if (this.isClone()) {
            super.blockedByItem(livingEntity);
        } else {
            livingEntity.hurtMarked = true;
        }
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        this.capturedEntities = null;
        if (!this.level().isClientSide) {
            this.deathCause = damageSource;
            for (WrappedGoal goal : this.goalSelector.getAvailableGoals()) {
                if (!goal.isRunning()) continue;
                goal.stop();
            }
            AnimatedEntity.sendAnimationPacket(this, DEATH_ANIMATION);
            if (this.lastHurtByPlayerMemoryTime > 0) {
                this.lastHurtByPlayerMemoryTime += DEATH_ANIMATION.duration();
            }
        }
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource damageSource) {
        for (int i = 0; i < DATA_HELD_BLOCKS.size(); ++i) {
            BlockState blockState = this.getHeldBlock(i).orElse(null);
            if (blockState == null) continue;
            ItemStack itemStack = new ItemStack((ItemLike)Items.DIAMOND_AXE);
            EnchantmentHelper.enchantItemFromProvider((ItemStack)itemStack, (RegistryAccess)level.registryAccess(), (ResourceKey)VanillaEnchantmentProviders.ENDERMAN_LOOT_DROP, (DifficultyInstance)level.getCurrentDifficultyAt(this.blockPosition()), (RandomSource)this.getRandom());
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)itemStack).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)this);
            for (ItemStack itemStack2 : blockState.getDrops(builder)) {
                this.spawnAtLocation(level, itemStack2);
            }
            this.setHeldBlock(i, Optional.empty(), 0);
        }
    }

    protected void tickDeath() {
        ServerLevel serverLevel;
        Level level;
        this.setDeltaMovement(0.0, Math.min(this.getDeltaMovement().y, 0.0), 0.0);
        if (this.deathTime == 80) {
            this.playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_DEATH_SOUND_EVENT.value(), 5.0f, this.getVoicePitch());
        }
        if (this.deathTime >= 60) {
            if (this.deathTime < 80 && this.capturedEntities == null) {
                this.capturedEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(10.0, 8.0, 10.0), ENDER_TARGETS);
            }
            if (!this.level().isClientSide && this.random.nextInt(3) != 0) {
                EndersoulFragment orb = new EndersoulFragment(this.level(), this);
                orb.setPos(this.getX(), this.getY() + 3.8, this.getZ());
                orb.setDeltaMovement((this.random.nextDouble() - 0.5) * 1.5, (this.random.nextDouble() - 0.5) * 1.5, (this.random.nextDouble() - 0.5) * 1.5);
                this.level().addFreshEntity((Entity)orb);
            }
        }
        if (this.deathTime >= 80 && this.deathTime < DEATH_ANIMATION.duration() - 20 && this.capturedEntities != null) {
            Iterator<Entity> iterator = this.capturedEntities.iterator();
            while (iterator.hasNext()) {
                Entity entity = iterator.next();
                if (entity.fallDistance > 4.5) {
                    entity.fallDistance = 4.5;
                }
                if (!(this.distanceToSqr(entity) > 64.0)) continue;
                if (!EndersoulFragment.isProtected(entity) && !entity.isSpectator()) {
                    double x = this.getX() - entity.getX();
                    double y = entity.getDeltaMovement().y;
                    double z = this.getZ() - entity.getZ();
                    double d = Math.sqrt(x * x + z * z);
                    if (this.getY() + 4.0 > entity.getY()) {
                        y = Math.max(entity.getDeltaMovement().y, 0.4);
                    }
                    entity.setDeltaMovement(0.8 * x / d, y, 0.8 * z / d);
                    continue;
                }
                iterator.remove();
            }
        }
        if ((level = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (this.deathTime >= 100 && this.deathTime < 150 && this.deathTime % 6 == 0 && serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                this.lootTable = Optional.of(ModRegistry.MUTANT_ENDERMAN_CONTINUOUS_LOOT_TABLE);
                this.dropFromLootTable(serverLevel, this.deathCause != null ? this.deathCause : serverLevel.damageSources().generic(), this.lastHurtByPlayerMemoryTime > 0);
            }
        }
        if ((level = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (this.deathTime >= DEATH_ANIMATION.duration()) {
                super.dropAllDeathLoot(serverLevel, this.deathCause != null ? this.deathCause : this.level().damageSources().generic());
                this.discard();
            }
        }
    }

    public ItemEntity spawnAtLocation(ServerLevel serverLevel, ItemStack itemStack) {
        return this.deathTime > 0 ? this.spawnAtLocation(serverLevel, itemStack, 3.84f) : super.spawnAtLocation(serverLevel, itemStack);
    }

    protected Component getTypeName() {
        return this.isClone() ? ((EntityType)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.value()).getDescription() : super.getTypeName();
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        this.addPersistentAngerSaveData(valueOutput);
        valueOutput.putInt("BlockFrenzy", this.blockFrenzy);
        valueOutput.putInt("ScreamDelay", this.screamDelayTick);
        valueOutput.store("HeldBlocks", HeldBlock.LIST_CODEC, IntStream.range(0, DATA_HELD_BLOCKS.size()).mapToObj(this::packHeldBlock).toList());
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.readPersistentAngerSaveData(this.level(), valueInput);
        this.blockFrenzy = valueInput.getIntOr("BlockFrenzy", 0);
        this.screamDelayTick = valueInput.getIntOr("ScreamDelay", 0);
        valueInput.read("HeldBlocks", HeldBlock.LIST_CODEC).ifPresent(list -> {
            for (int i = 0; i < list.size(); ++i) {
                this.unpackHeldBlock(i, (HeldBlock)list.get(i));
            }
        });
    }

    public int getAmbientSoundInterval() {
        return 200;
    }

    public void playAmbientSound() {
        if (!this.isClone()) {
            super.playAmbientSound();
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_HURT_SOUND_EVENT.value();
    }

    private boolean isBeingLookedAtBy(LivingEntity target) {
        if (!(target instanceof Mob)) {
            Vec3 lookVec = target.getViewVector(1.0f).normalize();
            Vec3 targetVec = new Vec3(this.getX() - target.getX(), this.getEyeY() - target.getEyeY(), this.getZ() - target.getZ());
            double length = targetVec.length();
            double d = lookVec.dot(targetVec = targetVec.normalize());
            return d > 1.0 - 0.08 / length && target.hasLineOfSight((Entity)this);
        }
        return ((Mob)target).getTarget() == this && target.hasLineOfSight((Entity)this);
    }

    @Override
    public void writeAdditionalAddEntityData(CompoundTag compoundTag) {
        AnimatedEntity.super.writeAdditionalAddEntityData(compoundTag);
        compoundTag.putInt("has_target_ticks", this.hasTargetTicks);
        compoundTag.putByte("arm_scale", (byte)this.armScale);
        compoundTag.putIntArray("held_block_ticks", this.heldBlockTicks);
    }

    @Override
    public void readAdditionalAddEntityData(CompoundTag compoundTag) {
        AnimatedEntity.super.readAdditionalAddEntityData(compoundTag);
        this.hasTargetTicks = compoundTag.getIntOr("has_target_ticks", 0);
        this.armScale = compoundTag.getByteOr("arm_scale", (byte)0);
        compoundTag.getIntArray("held_block_ticks").ifPresent(heldBlockTicks -> System.arraycopy(heldBlockTicks, 0, this.heldBlockTicks, 0, this.heldBlockTicks.length));
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return AdditionalSpawnDataEntity.getPacket(this, serverEntity);
    }

    static class MeleeGoal
    extends AnimationGoal<MutantEnderman> {
        public MeleeGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected EntityAnimation getAnimation() {
            return MELEE_ANIMATION;
        }

        public void tick() {
            if (((MutantEnderman)this.mob).animationTick == 3) {
                ((MutantEnderman)this.mob).playSound(SoundEvents.PLAYER_ATTACK_STRONG, 1.0f, ((MutantEnderman)this.mob).getVoicePitch());
                boolean lower = ((MutantEnderman)this.mob).getActiveArm() >= 2;
                float attackDamage = (float)((MutantEnderman)this.mob).getAttributeValue(Attributes.ATTACK_DAMAGE);
                for (LivingEntity livingEntity : ((MutantEnderman)this.mob).level().getEntitiesOfClass(LivingEntity.class, ((MutantEnderman)this.mob).getBoundingBox().inflate(4.0))) {
                    if (livingEntity instanceof MutantEnderman || livingEntity instanceof EndersoulClone) continue;
                    double dist = ((MutantEnderman)this.mob).distanceTo((Entity)livingEntity);
                    double x = ((MutantEnderman)this.mob).getX() - livingEntity.getX();
                    double z = ((MutantEnderman)this.mob).getZ() - livingEntity.getZ();
                    if (!(((MutantEnderman)this.mob).getBoundingBox().minY <= livingEntity.getBoundingBox().maxY) || !(dist <= 4.0) || !(EntityUtil.getHeadAngle((LivingEntity)this.mob, x, z) < 3.0f + (1.0f - (float)dist / 4.0f) * 40.0f)) continue;
                    livingEntity.hurt(((MutantEnderman)this.mob).damageSources().mobAttack((LivingEntity)this.mob), attackDamage > 0.0f ? attackDamage + (lower ? 1.0f : 3.0f) : 0.0f);
                    float power = 0.4f + ((MutantEnderman)this.mob).random.nextFloat() * 0.2f;
                    if (!lower) {
                        power += 0.2f;
                    }
                    livingEntity.setDeltaMovement(-x / dist * (double)power, (double)(power * 0.6f), -z / dist * (double)power);
                    EntityUtil.sendPlayerVelocityPacket((Entity)livingEntity);
                }
            }
        }
    }

    static class ThrowBlockGoal
    extends AnimationGoal<MutantEnderman> {
        public ThrowBlockGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected EntityAnimation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean canUse() {
            if (((MutantEnderman)this.mob).isAnimationPlaying()) {
                return false;
            }
            if (!((MutantEnderman)this.mob).triggerThrowBlock && ((MutantEnderman)this.mob).getRandom().nextInt(28) != 0) {
                return false;
            }
            if (((MutantEnderman)this.mob).getTarget() != null && !((MutantEnderman)this.mob).hasLineOfSight((Entity)((MutantEnderman)this.mob).getTarget())) {
                return false;
            }
            int id = ((MutantEnderman)this.mob).getThrowingHand();
            if (id == -1) {
                return false;
            }
            ((MutantEnderman)this.mob).setActiveArm(id);
            return true;
        }

        @Override
        public void start() {
            super.start();
            int id = ((MutantEnderman)this.mob).getActiveArm();
            ((MutantEnderman)this.mob).level().addFreshEntity((Entity)new ThrowableBlock((MutantEnderman)this.mob, id));
            ((MutantEnderman)this.mob).setHeldBlock(id, Optional.empty(), 0);
        }

        @Override
        public void stop() {
            super.stop();
            ((MutantEnderman)this.mob).triggerThrowBlock = false;
        }
    }

    static class StareGoal
    extends AnimationGoal<MutantEnderman> {
        private LivingEntity attackTarget;

        public StareGoal(MutantEnderman mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return STARE_ANIMATION;
        }

        @Override
        public boolean canUse() {
            this.attackTarget = ((MutantEnderman)this.mob).getTarget();
            return this.attackTarget != null && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            ((MutantEnderman)this.mob).ambientSoundTime = -((MutantEnderman)this.mob).getAmbientSoundInterval();
            ((MutantEnderman)this.mob).level().playSound(null, (Entity)this.mob, (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_STARE_SOUND_EVENT.value(), ((MutantEnderman)this.mob).getSoundSource(), 2.5f, 0.7f + ((MutantEnderman)this.mob).random.nextFloat() * 0.2f);
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.attackTarget.isAlive() && ((MutantEnderman)this.mob).isBeingLookedAtBy(this.attackTarget);
        }

        public void tick() {
            ((MutantEnderman)this.mob).getNavigation().stop();
            ((MutantEnderman)this.mob).lookControl.setLookAt((Entity)this.attackTarget, 45.0f, 45.0f);
        }

        @Override
        public void stop() {
            super.stop();
            this.attackTarget.stopRiding();
            DamageSource damageSource = DamageHelper.damageSource((LevelReader)((MutantEnderman)this.mob).level(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob);
            this.attackTarget.hurtServer((ServerLevel)((MutantEnderman)this.mob).level(), damageSource, 2.0f);
            this.attackTarget.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 160 + ((MutantEnderman)this.mob).random.nextInt(140)));
            double x = ((MutantEnderman)this.mob).getX() - this.attackTarget.getX();
            double z = ((MutantEnderman)this.mob).getZ() - this.attackTarget.getZ();
            this.attackTarget.setDeltaMovement(x * 0.1, 0.3, z * 0.1);
            EntityUtil.sendPlayerVelocityPacket((Entity)this.attackTarget);
            this.attackTarget = null;
        }
    }

    static class TeleportGoal
    extends AnimationGoal<MutantEnderman> {
        public TeleportGoal(MutantEnderman mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return TELEPORT_ANIMATION;
        }

        @Override
        public void start() {
            ((MutantEnderman)this.mob).animation = TELEPORT_ANIMATION;
            ((MutantEnderman)this.mob).animationTick = 0;
            MutantEnderman.teleportAttack((ServerLevel)((MutantEnderman)this.mob).level(), (LivingEntity)this.mob);
            ((MutantEnderman)this.mob).getTeleportPosition().ifPresent(pos -> ((MutantEnderman)this.mob).setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5));
            if (!((MutantEnderman)this.mob).isSilent()) {
                ((MutantEnderman)this.mob).level().playSound(null, ((MutantEnderman)this.mob).xo, ((MutantEnderman)this.mob).yo, ((MutantEnderman)this.mob).zo, (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT_SOUND_EVENT.value(), ((MutantEnderman)this.mob).getSoundSource(), 1.0f, 1.0f);
                ((MutantEnderman)this.mob).playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_TELEPORT_SOUND_EVENT.value(), 1.0f, 1.0f);
            }
            MutantEnderman.teleportAttack((ServerLevel)((MutantEnderman)this.mob).level(), (LivingEntity)this.mob);
            ((MutantEnderman)this.mob).setPos(((MutantEnderman)this.mob).xo, ((MutantEnderman)this.mob).yo, ((MutantEnderman)this.mob).zo);
        }

        public void tick() {
            ((MutantEnderman)this.mob).getNavigation().stop();
        }

        @Override
        public void stop() {
            ((MutantEnderman)this.mob).stopRiding();
            ((MutantEnderman)this.mob).fallDistance = 0.0;
            ((MutantEnderman)this.mob).getTeleportPosition().ifPresent(pos -> ((MutantEnderman)this.mob).teleportTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5));
            super.stop();
            ((MutantEnderman)this.mob).setTeleportPosition(null);
        }
    }

    static class ScreamGoal
    extends AnimationGoal<MutantEnderman> {
        public ScreamGoal(MutantEnderman mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return SCREAM_ANIMATION;
        }

        @Override
        public boolean canUse() {
            if (((MutantEnderman)this.mob).getTarget() != null && !((MutantEnderman)this.mob).isAnimationPlaying()) {
                return ((MutantEnderman)this.mob).screamDelayTick <= 0 && ((MutantEnderman)this.mob).distanceToSqr((Entity)((MutantEnderman)this.mob).getTarget()) < 400.0 && ((MutantEnderman)this.mob).random.nextInt(((MutantEnderman)this.mob).isInWaterOrRain() ? 400 : 1200) == 0;
            }
            return false;
        }

        public void tick() {
            ((MutantEnderman)this.mob).getNavigation().stop();
            if (((MutantEnderman)this.mob).animationTick == 40) {
                ((MutantEnderman)this.mob).ambientSoundTime = -((MutantEnderman)this.mob).getAmbientSoundInterval();
                ((MutantEnderman)this.mob).level().getLevelData().setRaining(false);
                ((MutantEnderman)this.mob).level().broadcastEntityEvent((Entity)this.mob, (byte)0);
                ((MutantEnderman)this.mob).playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ENDERMAN_SCREAM_SOUND_EVENT.value(), 5.0f, 0.7f + ((MutantEnderman)this.mob).random.nextFloat() * 0.2f);
                for (Entity entity : ((MutantEnderman)this.mob).level().getEntities((Entity)this.mob, ((MutantEnderman)this.mob).getBoundingBox().inflate(20.0, 12.0, 20.0), ENDER_TARGETS)) {
                    if (!(((MutantEnderman)this.mob).distanceToSqr(entity) < 400.0)) continue;
                    entity.hurt(DamageHelper.damageSource((LevelReader)((MutantEnderman)this.mob).level(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob), 4.0f);
                    if (!(entity instanceof Mob)) continue;
                    Mob mobEntity = (Mob)entity;
                    mobEntity.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 120, 3));
                    if (((MutantEnderman)this.mob).random.nextInt(2) != 0) {
                        mobEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 120 + ((MutantEnderman)this.mob).random.nextInt(180), ((MutantEnderman)this.mob).random.nextInt(2)));
                    }
                    if (((MutantEnderman)this.mob).random.nextInt(4) != 0) {
                        mobEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 300 + ((MutantEnderman)this.mob).random.nextInt(300), ((MutantEnderman)this.mob).random.nextInt(2)));
                    }
                    if (((MutantEnderman)this.mob).random.nextInt(3) != 0) {
                        mobEntity.addEffect(new MobEffectInstance(MobEffects.HUNGER, 120 + ((MutantEnderman)this.mob).random.nextInt(60), 10 + ((MutantEnderman)this.mob).random.nextInt(2)));
                    }
                    if (((MutantEnderman)this.mob).random.nextInt(4) == 0) continue;
                    mobEntity.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 120 + ((MutantEnderman)this.mob).random.nextInt(400)));
                }
            }
        }

        @Override
        public void stop() {
            super.stop();
            ((MutantEnderman)this.mob).screamDelayTick = 600;
        }
    }

    static class CloneGoal
    extends AnimationGoal<MutantEnderman> {
        private final List<EndersoulClone> cloneList = new ArrayList<EndersoulClone>();
        private LivingEntity attackTarget;

        public CloneGoal(MutantEnderman mob) {
            super(mob);
        }

        @Override
        protected EntityAnimation getAnimation() {
            return CLONE_ANIMATION;
        }

        @Override
        public boolean canUse() {
            this.attackTarget = ((MutantEnderman)this.mob).getTarget();
            if (this.attackTarget == null) {
                return false;
            }
            if (this.attackTarget.getType() != EntityType.WITHER && ((MutantEnderman)this.mob).allHandsFree()) {
                return ((MutantEnderman)this.mob).hurtTime == 0 && (super.canUse() || !((MutantEnderman)this.mob).isAnimationPlaying() && ((MutantEnderman)this.mob).tickCount % 3 == 0 && ((MutantEnderman)this.mob).random.nextInt(300) == 0);
            }
            return false;
        }

        @Override
        public void start() {
            super.start();
            ((MutantEnderman)this.mob).invulnerableTime = 20;
            AttributeInstance attribute = ((MutantEnderman)this.mob).getAttribute(Attributes.STEP_HEIGHT);
            if (!attribute.hasModifier(STEP_HEIGHT_MODIFIER_CLONING_ID)) {
                attribute.addTransientModifier(STEP_HEIGHT_MODIFIER_CLONING);
            }
            ((MutantEnderman)this.mob).setClone(true);
            ((MutantEnderman)this.mob).clearFire();
            ((MutantEnderman)this.mob).removeAllEffects();
            for (int i = 0; i < 7; ++i) {
                double x = this.attackTarget.getX() + (((MutantEnderman)this.mob).random.nextDouble() - 0.5) * 24.0;
                double y = this.attackTarget.getY() + 8.0;
                double z = this.attackTarget.getZ() + (((MutantEnderman)this.mob).random.nextDouble() - 0.5) * 24.0;
                this.createClone(x, y, z);
            }
            this.createClone(((MutantEnderman)this.mob).xo, ((MutantEnderman)this.mob).yo, ((MutantEnderman)this.mob).zo);
            double x = this.attackTarget.getX() + (((MutantEnderman)this.mob).random.nextDouble() - 0.5) * 24.0;
            double y = this.attackTarget.getY() + 8.0;
            double z = this.attackTarget.getZ() + (((MutantEnderman)this.mob).random.nextDouble() - 0.5) * 24.0;
            ((MutantEnderman)this.mob).teleportToPosition(x, y, z);
            EntityUtil.divertAttackers(this.mob, (LivingEntity)this.getRandomClone());
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && ((MutantEnderman)this.mob).getTarget() != null && !this.cloneList.isEmpty() && ((MutantEnderman)this.mob).hurtTime == 0;
        }

        public void tick() {
            for (int i = this.cloneList.size() - 1; i >= 0; --i) {
                EndersoulClone clone = this.cloneList.get(i);
                if (clone.isAlive() && clone.level() == ((MutantEnderman)this.mob).level()) continue;
                this.cloneList.remove(i);
            }
        }

        @Override
        public void stop() {
            super.stop();
            ((MutantEnderman)this.mob).setClone(false);
            AttributeInstance attribute = ((MutantEnderman)this.mob).getAttribute(Attributes.STEP_HEIGHT);
            attribute.removeModifier(STEP_HEIGHT_MODIFIER_CLONING_ID);
            for (EndersoulClone clone : this.cloneList) {
                if (!clone.isAlive()) continue;
                clone.discard();
                EntityUtil.divertAttackers((Mob)clone, (LivingEntity)this.mob);
            }
            this.cloneList.clear();
            ((MutantEnderman)this.mob).getNavigation().stop();
            this.attackTarget.setLastHurtByMob((LivingEntity)this.mob);
            this.attackTarget = null;
        }

        private void createClone(double x, double y, double z) {
            EndersoulClone clone = (EndersoulClone)((EntityType)ModEntityTypes.ENDERSOUL_CLONE_ENTITY_TYPE.value()).create(((MutantEnderman)this.mob).level(), EntitySpawnReason.MOB_SUMMONED);
            clone.setCloner((MutantEnderman)this.mob);
            this.cloneList.add(clone);
            if (!EntityUtil.teleportTo((Mob)clone, x, y, z)) {
                clone.copyPosition((Entity)this.mob);
            }
            ((MutantEnderman)this.mob).level().addFreshEntity((Entity)clone);
        }

        private Mob getRandomClone() {
            return this.cloneList.isEmpty() ? this.mob : (Mob)this.cloneList.get(((MutantEnderman)this.mob).random.nextInt(this.cloneList.size()));
        }
    }

    static class TeleSmashGoal
    extends AnimationGoal<MutantEnderman> {
        public TeleSmashGoal(MutantEnderman mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return TELESMASH_ANIMATION;
        }

        @Override
        public boolean canUse() {
            return ((MutantEnderman)this.mob).getTarget() != null && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            LivingEntity target = ((MutantEnderman)this.mob).getTarget();
            if (target != null) {
                target.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 20, 5));
                target.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 160 + target.getRandom().nextInt(160)));
            }
        }

        public void tick() {
            LivingEntity target = ((MutantEnderman)this.mob).getTarget();
            if (target != null) {
                ((MutantEnderman)this.mob).getNavigation().stop();
                if (((MutantEnderman)this.mob).animationTick < 20) {
                    ((MutantEnderman)this.mob).lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                }
                if (((MutantEnderman)this.mob).animationTick == 17) {
                    target.stopRiding();
                }
                if (((MutantEnderman)this.mob).animationTick == 18) {
                    double x = target.getX() + (target.getRandom().nextDouble() - 0.5) * 14.0;
                    double y = target.getY() + target.getRandom().nextDouble() + (target instanceof Player ? 13.0 : 7.0);
                    double z = target.getZ() + (target.getRandom().nextDouble() - 0.5) * 14.0;
                    EntityUtil.stunRavager(target);
                    EntityUtil.sendParticlePacket((Entity)target, (ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.value(), 256);
                    target.teleportTo(x, y, z);
                    ((MutantEnderman)this.mob).level().playSound(null, x, y, z, (Holder)SoundEvents.GENERIC_EXPLODE, target.getSoundSource(), 1.2f, 0.9f + target.getRandom().nextFloat() * 0.2f);
                    target.hurt(DamageHelper.damageSource((LevelReader)((MutantEnderman)this.mob).level(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob), 6.0f);
                }
            }
        }
    }

    static class FindTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        public FindTargetGoal(MutantEnderman mutantEnderman) {
            super((Mob)mutantEnderman, LivingEntity.class, 10, false, false, (livingEntity, serverLevel) -> (mutantEnderman.isAngryAt(livingEntity, serverLevel) || mutantEnderman.isBeingLookedAtBy(livingEntity) || EndersoulFragment.isProtected((Entity)livingEntity)) && livingEntity.attackable());
        }

        public boolean canUse() {
            boolean flag;
            boolean bl = flag = !((MutantEnderman)this.mob).isAnimationPlaying() && super.canUse();
            if (flag && ((MutantEnderman)this.mob).isBeingLookedAtBy(this.target)) {
                ((MutantEnderman)this.mob).animation = STARE_ANIMATION;
            }
            return flag;
        }

        protected AABB getTargetSearchArea(double targetDistance) {
            return this.mob.getBoundingBox().inflate(targetDistance, targetDistance / 2.0, targetDistance);
        }
    }

    record HeldBlock(Optional<BlockState> blockState, int heldTicks) {
        public static final Codec<HeldBlock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.CODEC.lenientOptionalFieldOf("block_state").forGetter(HeldBlock::blockState), (App)Codec.INT.optionalFieldOf("held_ticks", (Object)0).forGetter(HeldBlock::heldTicks)).apply((Applicative)instance, HeldBlock::new));
        public static final Codec<List<HeldBlock>> LIST_CODEC = CODEC.listOf();
    }
}

