/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.puzzleslib.api.util.v1.EntityHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;

public abstract class MutantMonster
extends Monster {
    protected MutantMonster(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.UNPASSABLE_RAIL, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 8.0f);
        this.setPathfindingMalus(PathType.POWDER_SNOW, 8.0f);
    }

    protected PathNavigation createNavigation(Level level) {
        return new GroundPathNavigation(this, (Mob)this, level){

            protected PathFinder createPathFinder(int maxVisitedNodes) {
                this.nodeEvaluator = new WalkNodeEvaluator();
                this.nodeEvaluator.setCanPassDoors(true);
                return new PathFinder(this, this.nodeEvaluator, maxVisitedNodes){

                    protected float distance(Node first, Node second) {
                        return first.distanceToXZ(second);
                    }
                };
            }
        };
    }

    public float getPathfindingMalus(PathType nodeType) {
        if (nodeType == PathType.LEAVES && this.getTarget() != null) {
            return 0.0f;
        }
        return super.getPathfindingMalus(nodeType);
    }

    public void aiStep() {
        Level level;
        super.aiStep();
        if (this.isAlive() && this.getTarget() != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.horizontalCollision && EntityHelper.isMobGriefingAllowed((ServerLevel)serverLevel, (Entity)this)) {
                boolean hasDestroyedBlock = false;
                AABB aabb = this.getBoundingBox().inflate(0.2);
                for (BlockPos blockPos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
                    if (!(this.level().getBlockState(blockPos).getBlock() instanceof LeavesBlock)) continue;
                    hasDestroyedBlock |= this.level().destroyBlock(blockPos, true, (Entity)this);
                }
                if (!hasDestroyedBlock && this.onGround()) {
                    this.jumpFromGround();
                }
            }
        }
    }
}

