/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.FleeRainGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MutantSnowGolem
extends AbstractGolem
implements RangedAttackMob,
Shearable,
OwnableEntity {
    private static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> DATA_OWNERUUID_ID = SynchedEntityData.defineId(MutantSnowGolem.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);
    private static final EntityDataAccessor<Byte> DATA_STATUS = SynchedEntityData.defineId(MutantSnowGolem.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private boolean isThrowing;
    private int throwingTick;

    public MutantSnowGolem(EntityType<? extends MutantSnowGolem> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SwimJumpGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FleeRainGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.1, 30, 12.0f));
        this.goalSelector.addGoal(3, (Goal)new ThrowIceGoal());
        this.goalSelector.addGoal(4, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 1.0000001E-5f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, (livingEntity, serverLevel) -> livingEntity instanceof Enemy && (!(livingEntity instanceof Creeper) || ((Creeper)livingEntity).getTarget() == this)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MutantSnowGolem.createMobAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.MOVEMENT_SPEED, 0.26);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_OWNERUUID_ID, Optional.empty());
        builder.define(DATA_STATUS, (Object)1);
    }

    @Nullable
    public EntityReference<LivingEntity> getOwnerReference() {
        return ((Optional)this.entityData.get(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwner(@Nullable LivingEntity livingEntity) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(livingEntity).map(EntityReference::new));
    }

    public void setOwnerReference(@Nullable EntityReference<LivingEntity> entityReference) {
        this.entityData.set(DATA_OWNERUUID_ID, Optional.ofNullable(entityReference));
    }

    public boolean hasJackOLantern() {
        return ((Byte)this.entityData.get(DATA_STATUS) & 1) != 0;
    }

    public void setJackOLantern(boolean jackOLantern) {
        byte b0 = (Byte)this.entityData.get(DATA_STATUS);
        this.entityData.set(DATA_STATUS, (Object)(jackOLantern ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean getSwimJump() {
        return ((Byte)this.entityData.get(DATA_STATUS) & 4) != 0;
    }

    public void setSwimJump(boolean swimJumping) {
        byte b0 = (Byte)this.entityData.get(DATA_STATUS);
        this.entityData.set(DATA_STATUS, (Object)(swimJumping ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB)));
    }

    public boolean canAttack(LivingEntity target) {
        return super.canAttack(target) && target instanceof Enemy;
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader level) {
        if (level.getBiome(pos).is(BiomeTags.SNOW_GOLEM_MELTS)) {
            return -10.0f;
        }
        return level.getBlockState(pos).getBlock() == Blocks.SNOW ? 10.0f : 0.0f;
    }

    public void tick() {
        Level level;
        super.tick();
        if (this.level().isClientSide && this.getSwimJump()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)36);
            this.level().broadcastEntityEvent((Entity)this, (byte)37);
        }
        if (this.isThrowing) {
            ++this.throwingTick;
            if (this.throwingTick >= 20) {
                this.isThrowing = false;
                this.throwingTick = 0;
            }
        }
        if (this.level().dimensionType().ultraWarm() || this.level().getBiome(this.blockPosition()).is(BiomeTags.SNOW_GOLEM_MELTS)) {
            if (this.random.nextFloat() > Math.min(80.0f, this.getHealth()) * 0.01f) {
                this.level().addParticle((ParticleOptions)ParticleTypes.FALLING_WATER, this.getRandomX(0.6), this.getRandomY() - 0.15, this.getRandomZ(0.6), 0.0, 0.0, 0.0);
            }
            if (this.tickCount % 60 == 0) {
                this.hurt(this.level().damageSources().onFire(), 1.0f);
            }
        }
        if (this.tickCount % 80 == 0 && this.isAlive() && this.getHealth() < this.getMaxHealth() && this.isSnowingAt(this.blockPosition())) {
            this.heal(1.0f);
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.onGround() && !serverLevel.dimensionType().ultraWarm() && EntityHelper.isMobGriefingAllowed((ServerLevel)serverLevel, (Entity)this)) {
                int x = Mth.floor((double)this.getX());
                int y = Mth.floor((double)this.getBoundingBox().minY);
                int z = Mth.floor((double)this.getZ());
                for (int i = -2; i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        boolean placeIce;
                        if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                        BlockPos pos = new BlockPos(x + i, y, z + j);
                        BlockPos posDown = pos.below();
                        BlockPos posAbove = pos.above();
                        boolean placeSnow = serverLevel.isEmptyBlock(pos) && Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)serverLevel, pos);
                        boolean bl = placeIce = serverLevel.isWaterAt(posDown) && serverLevel.getBlockState(posDown).getBlock() instanceof LiquidBlock;
                        if (serverLevel.getFluidState(pos).getType() == Fluids.FLOWING_WATER) {
                            serverLevel.setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
                        }
                        if (serverLevel.getFluidState(posAbove).getType() == Fluids.FLOWING_WATER) {
                            serverLevel.setBlockAndUpdate(posAbove, Blocks.ICE.defaultBlockState());
                        }
                        if (placeSnow && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.random.nextInt(20) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.random.nextInt(10) != 0) || placeIce && ((Math.abs(i) == 2 || Math.abs(j) == 2) && this.random.nextInt(14) != 0 || (Math.abs(i) == 1 || Math.abs(j) == 1) && this.random.nextInt(6) != 0)) continue;
                        if (placeSnow) {
                            serverLevel.setBlockAndUpdate(pos, Blocks.SNOW.defaultBlockState());
                        }
                        if (!placeIce) continue;
                        serverLevel.setBlockAndUpdate(posDown, Blocks.ICE.defaultBlockState());
                    }
                }
            }
        }
    }

    private boolean isSnowingAt(BlockPos blockPos) {
        if (!this.level().isRaining()) {
            return false;
        }
        if (!this.level().canSeeSky(blockPos)) {
            return false;
        }
        if (this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos).getY() > blockPos.getY()) {
            return false;
        }
        return ((Biome)this.level().getBiome(blockPos).value()).getPrecipitationAt(blockPos, this.level().getSeaLevel()) == Biome.Precipitation.SNOW;
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public boolean readyForShearing() {
        return this.isAlive() && this.hasJackOLantern();
    }

    public void shear(ServerLevel serverLevel, SoundSource soundSource, ItemStack itemStack) {
        serverLevel.playSound(null, (Entity)this, SoundEvents.SNOW_GOLEM_SHEAR, soundSource, 1.0f, 1.0f);
        this.setJackOLantern(false);
        this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)Items.JACK_O_LANTERN), 1.7f);
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        if (!this.isLeashed()) {
            Player owner;
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Player && (owner = (Player)livingEntity).isAlive()) {
                this.setHomeTo(owner.blockPosition(), this.getTarget() == null ? 8 : 16);
            } else if (this.hasHome()) {
                this.setHomeTo(BlockPos.ZERO, -1);
            }
        }
        super.customServerAiStep(serverLevel);
    }

    public boolean isThrowing() {
        return this.isThrowing;
    }

    public int getThrowingTick() {
        return this.throwingTick;
    }

    private void setThrowing(boolean isThrowing) {
        this.isThrowing = isThrowing;
        this.throwingTick = 0;
        this.level().broadcastEntityEvent((Entity)this, (byte)(isThrowing ? 1 : 0));
    }

    public void handleEntityEvent(byte id) {
        if (id == 0) {
            this.isThrowing = false;
            this.throwingTick = 0;
        } else if (id == 1) {
            this.isThrowing = true;
            this.throwingTick = 0;
        } else if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.random.nextGaussian() * 0.02;
                double e = this.random.nextGaussian() * 0.02;
                double f = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d, e, f);
            }
        } else if (id == 36) {
            for (int i = 0; i < 6; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SNOW.defaultBlockState()), this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
        } else if (id == 37) {
            for (int i = 0; i < 6; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float damageAmount) {
        if (this.isInvulnerableTo(serverLevel, damageSource)) {
            return false;
        }
        if (damageSource.getDirectEntity() instanceof Snowball) {
            if (this.isAlive() && this.getHealth() < this.getMaxHealth()) {
                this.heal(1.0f);
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)ParticleTypes.HEART, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), d0, d1, d2);
            }
            return false;
        }
        return super.hurtServer(serverLevel, damageSource, damageAmount);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (!this.isThrowing) {
            this.setThrowing(true);
        }
    }

    public static boolean canHarm(Entity attacker, Entity target) {
        if (!(attacker instanceof MutantSnowGolem)) {
            return true;
        }
        if (target instanceof CreeperMinion) {
            return !((CreeperMinion)target).isTame();
        }
        return target instanceof Enemy || target instanceof Mob && ((Mob)target).getTarget() == attacker || ((MutantSnowGolem)attacker).getTarget() == target;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        InteractionResult interactionResult = itemInHand.interactLivingEntity(player, (LivingEntity)this, interactionHand);
        if (interactionResult.consumesAction()) {
            return interactionResult;
        }
        if (itemInHand.getItem() == Items.SNOWBALL) {
            return InteractionResult.PASS;
        }
        if (itemInHand.isEmpty() && this.getOwnerReference() == null) {
            if (!this.level().isClientSide) {
                this.setOwner((LivingEntity)player);
                this.level().broadcastEntityEvent((Entity)this, (byte)18);
            }
            return InteractionResultHelper.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.9f * this.getEyeHeight()), (double)this.getBbWidth() * 0.2);
    }

    public void die(DamageSource cause) {
        ServerLevel serverLevel;
        Level level = this.level();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && (level = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)level;
            serverPlayer.sendSystemMessage(this.getCombatTracker().getDeathMessage());
        }
        super.die(cause);
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean("JackOLantern", this.hasJackOLantern());
        EntityReference<LivingEntity> entityReference = this.getOwnerReference();
        if (entityReference != null) {
            entityReference.store(valueOutput, "Owner");
        }
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setJackOLantern(valueInput.getBooleanOr("JackOLantern", false));
        this.setOwnerReference((EntityReference<LivingEntity>)EntityReference.readWithOldOwnerConversion((ValueInput)valueInput, (String)"Owner", (Level)this.level()));
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_SNOW_GOLEM_DEATH_SOUND_EVENT.value();
    }

    protected void playStepSound(BlockPos pos, BlockState blockState) {
        this.playSound(SoundEvents.SNOW_STEP, 0.15f, 1.0f);
    }

    static class SwimJumpGoal
    extends Goal {
        private final MutantSnowGolem golem;
        private int jumpTick = 20;
        private boolean waterReplaced;
        private BlockPos.MutableBlockPos prevPos;

        public SwimJumpGoal(MutantSnowGolem golem) {
            this.golem = golem;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP));
            golem.navigation.setCanFloat(true);
        }

        public boolean canUse() {
            return this.golem.isInWater();
        }

        public void start() {
            this.prevPos = new BlockPos.MutableBlockPos(this.golem.getX(), this.golem.getBoundingBox().minY - 1.0, this.golem.getZ());
            this.golem.setDeltaMovement((this.golem.random.nextFloat() - this.golem.random.nextFloat()) * 0.9f, 1.5, (this.golem.random.nextFloat() - this.golem.random.nextFloat()) * 0.9f);
            this.golem.hurt(this.golem.level().damageSources().drown(), 16.0f);
            this.golem.setSwimJump(true);
        }

        public boolean canContinueToUse() {
            return this.jumpTick > 0;
        }

        public void tick() {
            --this.jumpTick;
            if (!this.waterReplaced && !this.golem.isInWater() && this.jumpTick < 17 && EntityHelper.isMobGriefingAllowed((ServerLevel)((ServerLevel)this.golem.level()), (Entity)this.golem)) {
                this.prevPos.setY(this.getWaterSurfaceHeight(this.golem.level(), (BlockPos)this.prevPos));
                if ((double)this.prevPos.getY() > this.golem.getY()) {
                    return;
                }
                for (int x = -2; x <= 2; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -2; z <= 2; ++z) {
                            if (y != 0 && (Math.abs(x) == 2 || Math.abs(z) == 2)) continue;
                            BlockPos pos = this.prevPos.offset(x, y, z);
                            if (!this.golem.level().isEmptyBlock(pos) && !this.golem.level().isWaterAt(pos) || (y != 0 ? (Math.abs(x) == 1 || Math.abs(z) == 1) && this.golem.random.nextInt(4) == 0 : (Math.abs(x) == 2 || Math.abs(z) == 2) && this.golem.random.nextInt(3) == 0)) continue;
                            this.golem.level().setBlockAndUpdate(pos, Blocks.ICE.defaultBlockState());
                        }
                    }
                }
                BlockPos topPos = this.prevPos.above(2);
                if (this.golem.level().isEmptyBlock(topPos)) {
                    this.golem.level().setBlockAndUpdate(topPos, Blocks.ICE.defaultBlockState());
                }
                this.waterReplaced = true;
            }
        }

        public void stop() {
            this.jumpTick = 20;
            this.waterReplaced = false;
            this.golem.setSwimJump(false);
            this.prevPos = null;
        }

        private int getWaterSurfaceHeight(Level world, BlockPos coord) {
            int y = coord.getY();
            while (world.isWaterAt(new BlockPos(coord.getX(), y + 1, coord.getZ()))) {
                ++y;
            }
            return y;
        }
    }

    class ThrowIceGoal
    extends Goal {
        ThrowIceGoal() {
        }

        public boolean canUse() {
            return MutantSnowGolem.this.getTarget() != null && MutantSnowGolem.this.isThrowing;
        }

        public boolean canContinueToUse() {
            return MutantSnowGolem.this.isThrowing && MutantSnowGolem.this.throwingTick < 20;
        }

        public void tick() {
            LivingEntity target = MutantSnowGolem.this.getTarget();
            if (target != null) {
                MutantSnowGolem.this.getNavigation().stop();
                MutantSnowGolem.this.yBodyRot = MutantSnowGolem.this.getYRot();
                if (MutantSnowGolem.this.throwingTick == 7) {
                    ThrowableBlock block = new ThrowableBlock(MutantSnowGolem.this);
                    double x = target.getX() - block.getX();
                    double y = target.getY() - block.getY();
                    double z = target.getZ() - block.getZ();
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    block.shoot(x, y + distance * 0.5, z, 0.9f, 1.0f);
                    MutantSnowGolem.this.level().addFreshEntity((Entity)block);
                }
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }
}

