/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.animation.AdditionalSpawnDataEntity;
import fuzs.mutantmonsters.world.entity.animation.AnimatedEntity;
import fuzs.mutantmonsters.world.entity.animation.EntityAnimation;
import fuzs.mutantmonsters.world.entity.mutant.MutantMonster;
import fuzs.mutantmonsters.world.level.SeismicWave;
import fuzs.mutantmonsters.world.level.ZombieResurrection;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import fuzs.puzzleslib.api.util.v1.DamageHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class MutantZombie
extends MutantMonster
implements AnimatedEntity {
    public static final int MAX_VANISH_TIME = 100;
    public static final int MAX_DEATH_TIME = 140;
    public static final EntityAnimation SLAM_GROUND_ANIMATION = new EntityAnimation("mutant_zombie_slam_ground", 25);
    public static final EntityAnimation THROW_ANIMATION = new EntityAnimation("mutant_zombie_throw", 15);
    public static final EntityAnimation ROAR_ANIMATION = new EntityAnimation("mutant_zombie_roar", 120);
    private static final EntityDataAccessor<Byte> DATA_LIVES = SynchedEntityData.defineId(MutantZombie.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> DATA_THROW_ATTACK_STATE = SynchedEntityData.defineId(MutantZombie.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityAnimation[] ANIMATIONS = new EntityAnimation[]{SLAM_GROUND_ANIMATION, THROW_ANIMATION, ROAR_ANIMATION};
    private final List<SeismicWave> seismicWaveList = new ArrayList<SeismicWave>();
    private final List<ZombieResurrection> resurrectionList = new ArrayList<ZombieResurrection>();
    public int throwHitTick = -1;
    public int throwFinishTick = -1;
    public int vanishTime;
    private EntityAnimation animation = EntityAnimation.NONE;
    private int animationTick;
    private DamageSource deathCause;

    public MutantZombie(EntityType<? extends MutantZombie> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 20;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MutantZombie.createMonsterAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.26).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SlamGroundGoal(this));
        this.goalSelector.addGoal(0, (Goal)new RoarGoal(this));
        this.goalSelector.addGoal(0, (Goal)new ThrowAttackGoal(this));
        this.goalSelector.addGoal(1, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.2).setMaxAttackTick(0));
        this.goalSelector.addGoal(2, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, () -> false));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, WitherBoss.class).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_LIVES, (Object)3);
        builder.define(DATA_THROW_ATTACK_STATE, (Object)0);
    }

    public int getLives() {
        return ((Byte)this.entityData.get(DATA_LIVES)).byteValue();
    }

    private void setLives(int lives) {
        this.entityData.set(DATA_LIVES, (Object)((byte)lives));
    }

    public boolean hasThrowAttackHit() {
        return ((Byte)this.entityData.get(DATA_THROW_ATTACK_STATE) & 1) != 0;
    }

    private void setThrowAttackHit(boolean hit) {
        byte b0 = (Byte)this.entityData.get(DATA_THROW_ATTACK_STATE);
        this.entityData.set(DATA_THROW_ATTACK_STATE, (Object)(hit ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isThrowAttackFinished() {
        return ((Byte)this.entityData.get(DATA_THROW_ATTACK_STATE) & 2) != 0;
    }

    private void setThrowAttackFinished(boolean finished) {
        byte b0 = (Byte)this.entityData.get(DATA_THROW_ATTACK_STATE);
        this.entityData.set(DATA_THROW_ATTACK_STATE, (Object)(finished ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    @Override
    public EntityAnimation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(EntityAnimation animation) {
        this.animation = animation;
    }

    @Override
    public EntityAnimation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected void tickHeadTurn(float renderYawOffset) {
        if (this.deathTime <= 0) {
            super.tickHeadTurn(renderYawOffset);
        }
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public int getMaxFallDistance() {
        return this.getTarget() != null ? (int)this.distanceTo((Entity)this.getTarget()) : 3;
    }

    public boolean isPushable() {
        return !this.onClimbable();
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        ItemStack itemInHand = player.getItemInHand(hand);
        ItemStack itemInHandCopy = itemInHand.copy();
        InteractionResult interactionResult = this.deadMobInteract(player, hand);
        if (interactionResult.consumesAction()) {
            if (player.getAbilities().instabuild && itemInHand == player.getItemInHand(hand) && itemInHand.getCount() < itemInHandCopy.getCount()) {
                itemInHand.setCount(itemInHandCopy.getCount());
            }
            if (itemInHand.isEmpty() && !player.getAbilities().instabuild) {
                player.setItemInHand(hand, ItemStack.EMPTY);
            }
            this.gameEvent((Holder)GameEvent.ENTITY_INTERACT);
            return interactionResult;
        }
        return super.interactAt(player, vec, hand);
    }

    private InteractionResult deadMobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (itemInHand.is(ItemTags.CREEPER_IGNITERS) && !this.isAlive() && !this.isOnFire() && !this.isInWaterOrRain()) {
            this.level().playSound((Entity)player, this.getX(), this.getY(), this.getZ(), SoundEvents.FLINTANDSTEEL_USE, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.4f + 0.8f);
            if (!this.level().isClientSide) {
                this.igniteForSeconds(8.0f);
                if (!itemInHand.isDamageableItem()) {
                    itemInHand.shrink(1);
                } else {
                    ItemHelper.hurtAndBreak((ItemStack)itemInHand, (int)1, (LivingEntity)player, (InteractionHand)interactionHand);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)itemInHand.getItem()));
            }
            return InteractionResultHelper.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity entity) {
        if (!this.isAnimationPlaying()) {
            if (entity.getVehicle() != this && this.random.nextInt(5) != 0) {
                if (this.onGround() || !this.getInBlockState().getFluidState().isEmpty()) {
                    this.animation = SLAM_GROUND_ANIMATION;
                }
            } else {
                this.animation = THROW_ANIMATION;
            }
        }
        return true;
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        if (!this.isAnimationPlaying() && this.getTarget() != null && Math.abs(this.getY() - this.getTarget().getY()) <= 1.0 && this.distanceToSqr((Entity)this.getTarget()) <= 49.0 && this.random.nextInt(20) == 0) {
            this.animation = SLAM_GROUND_ANIMATION;
        }
        super.customServerAiStep(serverLevel);
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float damageAmount) {
        if (this.isInvulnerableTo(serverLevel, damageSource)) {
            return false;
        }
        Entity entity = damageSource.getEntity();
        return (entity == null || this.canHarm(entity) && (this.animation != THROW_ANIMATION || entity != this.getTarget())) && super.hurtServer(serverLevel, damageSource, damageAmount);
    }

    protected void updateNoActionTime() {
    }

    public void tick() {
        super.tick();
        this.fixRotation();
        this.updateAnimation();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.updateMeleeGrounds(serverLevel);
        }
        if (this.level().isDarkOutside() && this.tickCount % 100 == 0 && this.isAlive() && this.getHealth() < this.getMaxHealth()) {
            this.heal(2.0f);
        }
        for (int i = this.resurrectionList.size() - 1; i >= 0; --i) {
            ZombieResurrection zr = this.resurrectionList.get(i);
            if (zr.update(this)) continue;
            this.resurrectionList.remove((Object)zr);
        }
        if (this.getHealth() > 0.0f) {
            this.deathTime = 0;
            this.vanishTime = 0;
        }
    }

    private void fixRotation() {
        float yaw;
        for (yaw = this.yHeadRot - this.yBodyRot; yaw < -180.0f; yaw += 360.0f) {
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        float offset = 0.1f;
        if (this.animation == SLAM_GROUND_ANIMATION) {
            offset = 0.2f;
        }
        this.yBodyRot += yaw * offset;
    }

    private void updateAnimation() {
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.level().isClientSide) {
            if (this.animation == THROW_ANIMATION) {
                if (this.hasThrowAttackHit()) {
                    if (this.throwHitTick == -1) {
                        this.throwHitTick = 0;
                    }
                    ++this.throwHitTick;
                }
                if (this.isThrowAttackFinished()) {
                    if (this.throwFinishTick == -1) {
                        this.throwFinishTick = 0;
                    }
                    ++this.throwFinishTick;
                }
            } else {
                this.throwHitTick = -1;
                this.throwFinishTick = -1;
            }
        }
    }

    private void updateMeleeGrounds(ServerLevel serverLevel) {
        if (!this.seismicWaveList.isEmpty()) {
            SeismicWave wave = this.seismicWaveList.remove(0);
            wave.affectBlocks(serverLevel, (Entity)this);
            AABB box = new AABB((double)wave.getX(), (double)wave.getY() + 1.0, (double)wave.getZ(), (double)wave.getX() + 1.0, (double)wave.getY() + 2.0, (double)wave.getZ() + 1.0);
            if (wave.isInitial()) {
                double addScale = this.random.nextDouble() * 0.75;
                box = box.inflate(0.25 + addScale, 0.25 + addScale * 0.5, 0.25 + addScale);
            }
            DamageSource damageSource = DamageHelper.damageSource((LevelReader)this.level(), ModRegistry.MUTANT_ZOMBIE_SEISMIC_WAVE_DAMAGE_TYPE, (Entity)this);
            for (Entity entity : this.level().getEntities((Entity)this, box, EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(this::canHarm))) {
                float damageAmount;
                float f = damageAmount = wave.isInitial() ? (float)(9 + this.random.nextInt(4)) : (float)(6 + this.random.nextInt(3));
                if (entity instanceof LivingEntity && entity.hurtServer(serverLevel, damageSource, damageAmount) && this.random.nextInt(5) == 0) {
                    ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.HUNGER, 160, 1));
                }
                double x = entity.getX() - this.getX();
                double z = entity.getZ() - this.getZ();
                double d = Math.sqrt(x * x + z * z);
                entity.setDeltaMovement(x / d * 0.3, 0.04, z / d * 0.3);
                EntityUtil.sendPlayerVelocityPacket(entity);
            }
        }
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected void blockedByItem(LivingEntity livingEntity) {
        livingEntity.hurtMarked = true;
    }

    public void die(DamageSource damageSource) {
        if (!this.level().isClientSide) {
            this.deathCause = damageSource;
            for (WrappedGoal goal : this.goalSelector.getAvailableGoals()) {
                if (!goal.isRunning()) continue;
                goal.stop();
            }
            this.setLastHurtMob((Entity)this.getLastHurtByMob());
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            if (this.lastHurtByPlayerMemoryTime > 0) {
                this.lastHurtByPlayerMemoryTime += 140;
            }
        }
    }

    protected void tickDeath() {
        if (this.deathTime <= 25 || !this.isOnFire() || this.deathTime >= 100) {
            ++this.deathTime;
        }
        if (this.isOnFire()) {
            Level level;
            if (this.vanishTime == 0 && (level = this.level()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.getChunkSource().broadcast((Entity)this, (Packet)new ClientboundSetEntityDataPacket(this.getId(), this.getEntityData().getNonDefaultValues()));
            }
            ++this.vanishTime;
        } else {
            this.vanishTime = Math.max(0, this.vanishTime - 1);
        }
        if (this.deathTime >= 140) {
            this.deathTime = 0;
            this.vanishTime = 0;
            this.deathCause = null;
            this.setLives(this.getLives() - 1);
            if (this.getLastHurtMob() != null) {
                this.getLastHurtMob().setLastHurtByMob((LivingEntity)this);
            }
            this.setHealth(Math.round(this.getMaxHealth() / 3.75f));
        }
        if (this.vanishTime >= 100 || this.getLives() <= 0 && this.deathTime > 25) {
            if (!this.level().isClientSide) {
                super.die(this.deathCause != null ? this.deathCause : this.level().damageSources().generic());
            }
            for (int i = 0; i < 30; ++i) {
                double d0 = this.random.nextGaussian() * 0.02;
                double d1 = this.random.nextGaussian() * 0.02;
                double d2 = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)(this.isOnFire() ? ParticleTypes.FLAME : ParticleTypes.POOF), this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d0, d1, d2);
            }
            this.discard();
        }
    }

    public void kill(ServerLevel serverLevel) {
        super.kill(serverLevel);
        this.setLives(0);
    }

    private boolean canHarm(Entity entity) {
        return entity.getType() != EntityType.ZOMBIE && entity.getType() != EntityType.ZOMBIE_VILLAGER && entity.getType() != EntityType.HUSK && entity.getType() != EntityType.DROWNED && !(entity instanceof MutantZombie);
    }

    public boolean killedEntity(ServerLevel level, LivingEntity entity) {
        boolean bl = super.killedEntity(level, entity);
        if ((level.getDifficulty() == Difficulty.NORMAL || level.getDifficulty() == Difficulty.HARD) && entity instanceof Villager) {
            Villager villager = (Villager)entity;
            if (level.getDifficulty() != Difficulty.HARD && this.random.nextBoolean()) {
                return bl;
            }
            if (this.convertVillagerToZombieVillager(level, villager)) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean convertVillagerToZombieVillager(ServerLevel level, Villager villager) {
        ZombieVillager zombieVillager = (ZombieVillager)villager.convertTo(EntityType.ZOMBIE_VILLAGER, ConversionParams.single((Mob)villager, (boolean)true, (boolean)true), zombieVillagerx -> {
            zombieVillagerx.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(zombieVillagerx.blockPosition()), EntitySpawnReason.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true));
            zombieVillagerx.setVillagerData(villager.getVillagerData());
            zombieVillagerx.setGossips(villager.getGossips().copy());
            zombieVillagerx.setTradeOffers(villager.getOffers().copy());
            zombieVillagerx.setVillagerXp(villager.getVillagerXp());
            if (!this.isSilent()) {
                level.levelEvent(null, 1026, this.blockPosition(), 0);
            }
        });
        return zombieVillager != null;
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putInt("Lives", this.getLives());
        valueOutput.putShort("VanishTime", (short)this.vanishTime);
        valueOutput.store("Resurrections", ZombieResurrection.LIST_CODEC, this.resurrectionList);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        valueInput.getInt("Lives").ifPresent(this::setLives);
        this.vanishTime = valueInput.getShortOr("VanishTime", (short)0);
        valueInput.read("Resurrections", ZombieResurrection.LIST_CODEC).ifPresent(this.resurrectionList::addAll);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_AMBIENT_SOUND_EVENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_HURT_SOUND_EVENT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_DEATH_SOUND_EVENT.value();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        if (this.deathTime == 0) {
            this.playSound(SoundEvents.ZOMBIE_STEP, 0.15f, 1.0f);
        }
    }

    @Override
    public void writeAdditionalAddEntityData(CompoundTag compoundTag) {
        AnimatedEntity.super.writeAdditionalAddEntityData(compoundTag);
        compoundTag.putInt("death_time", this.deathTime);
        compoundTag.putInt("vanish_time", this.vanishTime);
        compoundTag.putInt("throw_hit_tick", this.throwHitTick);
        compoundTag.putInt("throw_finish_tick", this.throwFinishTick);
    }

    @Override
    public void readAdditionalAddEntityData(CompoundTag compoundTag) {
        AnimatedEntity.super.readAdditionalAddEntityData(compoundTag);
        this.deathTime = compoundTag.getIntOr("death_time", 0);
        this.vanishTime = compoundTag.getIntOr("vanish_time", 0);
        this.throwHitTick = compoundTag.getIntOr("throw_hit_tick", 0);
        this.throwFinishTick = compoundTag.getIntOr("throw_finish_tick", 0);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return AdditionalSpawnDataEntity.getPacket(this, serverEntity);
    }

    static class SlamGroundGoal
    extends AnimationGoal<MutantZombie> {
        private double dirX = -1.0;
        private double dirZ = -1.0;

        public SlamGroundGoal(MutantZombie mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return SLAM_GROUND_ANIMATION;
        }

        @Override
        public boolean canUse() {
            return ((MutantZombie)this.mob).getTarget() != null && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            ((MutantZombie)this.mob).ambientSoundTime = -((MutantZombie)this.mob).getAmbientSoundInterval();
            ((MutantZombie)this.mob).playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_ATTACK_SOUND_EVENT.value(), 0.3f, 0.8f + ((MutantZombie)this.mob).random.nextFloat() * 0.4f);
        }

        public void tick() {
            LivingEntity target = ((MutantZombie)this.mob).getTarget();
            if (target != null) {
                ((MutantZombie)this.mob).getNavigation().stop();
                if (((MutantZombie)this.mob).animationTick < 8) {
                    ((MutantZombie)this.mob).lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                }
                if (((MutantZombie)this.mob).animationTick == 8) {
                    double x = target.getX() - ((MutantZombie)this.mob).getX();
                    double z = target.getZ() - ((MutantZombie)this.mob).getZ();
                    double d = Math.sqrt(x * x + z * z);
                    this.dirX = x / d;
                    this.dirZ = z / d;
                }
                if (((MutantZombie)this.mob).animationTick == 12) {
                    int x = Mth.floor((double)(((MutantZombie)this.mob).getX() + this.dirX * 2.0));
                    int y = Mth.floor((double)((MutantZombie)this.mob).getBoundingBox().minY);
                    int z = Mth.floor((double)(((MutantZombie)this.mob).getZ() + this.dirZ * 2.0));
                    int x1 = Mth.floor((double)(((MutantZombie)this.mob).getX() + this.dirX * 8.0));
                    int z1 = Mth.floor((double)(((MutantZombie)this.mob).getZ() + this.dirZ * 8.0));
                    SeismicWave.createWaves(((MutantZombie)this.mob).level(), ((MutantZombie)this.mob).seismicWaveList, x, z, x1, z1, y);
                    ((MutantZombie)this.mob).playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 0.5f, 0.8f + ((MutantZombie)this.mob).random.nextFloat() * 0.4f);
                }
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.dirX = -1.0;
            this.dirZ = -1.0;
        }
    }

    static class RoarGoal
    extends AnimationGoal<MutantZombie> {
        public RoarGoal(MutantZombie mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return ROAR_ANIMATION;
        }

        @Override
        public boolean canUse() {
            return ((MutantZombie)this.mob).tickCount % 3 == 0 && !((MutantZombie)this.mob).isAnimationPlaying() && ((MutantZombie)this.mob).getTarget() != null && ((MutantZombie)this.mob).onGround() && ((MutantZombie)this.mob).resurrectionList.isEmpty() && ((MutantZombie)this.mob).distanceToSqr((Entity)((MutantZombie)this.mob).getTarget()) > 16.0 && ((MutantZombie)this.mob).random.nextFloat() * 100.0f < 0.35f;
        }

        @Override
        public void start() {
            super.start();
            ((MutantZombie)this.mob).invulnerableTime = 20;
            ((MutantZombie)this.mob).ambientSoundTime = -((MutantZombie)this.mob).getAmbientSoundInterval();
        }

        public void tick() {
            ((MutantZombie)this.mob).getNavigation().stop();
            if (((MutantZombie)this.mob).animationTick < 75 && ((MutantZombie)this.mob).getTarget() != null) {
                ((MutantZombie)this.mob).lookControl.setLookAt((Entity)((MutantZombie)this.mob).getTarget(), 30.0f, 30.0f);
            }
            if (((MutantZombie)this.mob).animationTick == 10) {
                ((MutantZombie)this.mob).playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_ROAR_SOUND_EVENT.value(), 3.0f, 0.7f + ((MutantZombie)this.mob).random.nextFloat() * 0.2f);
                for (Entity entity : ((MutantZombie)this.mob).level().getEntities((Entity)this.mob, ((MutantZombie)this.mob).getBoundingBox().inflate(12.0, 8.0, 12.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR)) {
                    if (!((MutantZombie)this.mob).canHarm(entity) || !(((MutantZombie)this.mob).distanceToSqr(entity) <= 196.0)) continue;
                    double x = entity.getX() - ((MutantZombie)this.mob).getX();
                    double z = entity.getZ() - ((MutantZombie)this.mob).getZ();
                    double d = Math.sqrt(x * x + z * z);
                    entity.setDeltaMovement(x / d * 0.7, 0.3, z / d * 0.7);
                    DamageSource damageSource = DamageHelper.damageSource((LevelReader)((MutantZombie)this.mob).level(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (Entity)this.mob);
                    entity.hurtServer((ServerLevel)((MutantZombie)this.mob).level(), damageSource, (float)(2 + ((MutantZombie)this.mob).random.nextInt(2)));
                    EntityUtil.sendPlayerVelocityPacket(entity);
                }
            }
            if (((MutantZombie)this.mob).animationTick >= 20 && ((MutantZombie)this.mob).animationTick < 80 && ((MutantZombie)this.mob).animationTick % 10 == 0) {
                int x = Mth.floor((double)((MutantZombie)this.mob).getX());
                int y = Mth.floor((double)((MutantZombie)this.mob).getBoundingBox().minY);
                int z = Mth.floor((double)((MutantZombie)this.mob).getZ());
                y = ZombieResurrection.getSuitableGround(((MutantZombie)this.mob).level(), x += (1 + ((MutantZombie)this.mob).random.nextInt(8)) * (((MutantZombie)this.mob).random.nextBoolean() ? 1 : -1), y - 1, z += (1 + ((MutantZombie)this.mob).random.nextInt(8)) * (((MutantZombie)this.mob).random.nextBoolean() ? 1 : -1));
                if (y != -1) {
                    ((MutantZombie)this.mob).resurrectionList.add(new ZombieResurrection(((MutantZombie)this.mob).level(), x, y, z));
                }
            }
        }
    }

    static class ThrowAttackGoal
    extends AnimationGoal<MutantZombie> {
        private int finish = -1;

        public ThrowAttackGoal(MutantZombie mob) {
            super(mob);
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean canUse() {
            return ((MutantZombie)this.mob).getTarget() != null && super.canUse();
        }

        @Override
        public void start() {
            super.start();
            LivingEntity target = ((MutantZombie)this.mob).getTarget();
            if (target != null) {
                target.stopRiding();
                double x = target.getX() - ((MutantZombie)this.mob).getX();
                double z = target.getZ() - ((MutantZombie)this.mob).getZ();
                double d = Math.sqrt(x * x + z * z);
                target.setDeltaMovement(x / d * 0.8, 1.6, z / d * 0.8);
                EntityUtil.sendPlayerVelocityPacket((Entity)target);
            }
        }

        @Override
        public boolean canContinueToUse() {
            if (this.finish >= 10) {
                return false;
            }
            LivingEntity target = ((MutantZombie)this.mob).getTarget();
            if (target == null) {
                return false;
            }
            if (!target.isAlive()) {
                return false;
            }
            return !(target instanceof Player) || !target.isSpectator() && !((Player)target).isCreative();
        }

        public void tick() {
            LivingEntity target = ((MutantZombie)this.mob).getTarget();
            if (target != null) {
                ((MutantZombie)this.mob).getNavigation().stop();
                ((MutantZombie)this.mob).lookControl.setLookAt((Entity)target, 30.0f, 30.0f);
                if (((MutantZombie)this.mob).animationTick == THROW_ANIMATION.duration()) {
                    ((MutantZombie)this.mob).stuckSpeedMultiplier = Vec3.ZERO;
                    double d1 = target.getX() - ((MutantZombie)this.mob).getX();
                    double d2 = target.getY() - ((MutantZombie)this.mob).getY();
                    double x = target.getZ() - ((MutantZombie)this.mob).getZ();
                    double z = Math.sqrt(d1 * d1 + d2 * d2 + x * x);
                    ((MutantZombie)this.mob).setDeltaMovement(d1 / z * 3.4, d2 / z * 1.4, x / z * 3.4);
                } else if (((MutantZombie)this.mob).animationTick > THROW_ANIMATION.duration()) {
                    double d1 = ((MutantZombie)this.mob).getBbWidth() * 2.0f * ((MutantZombie)this.mob).getBbWidth() * 2.0f;
                    double d2 = ((MutantZombie)this.mob).distanceToSqr(target.getX(), target.getBoundingBox().minY, target.getZ());
                    if (d2 < d1 && !((MutantZombie)this.mob).hasThrowAttackHit()) {
                        ((MutantZombie)this.mob).setThrowAttackHit(true);
                        DamageSource damageSource = ((MutantZombie)this.mob).level().damageSources().mobAttack((LivingEntity)this.mob);
                        if (!target.hurtServer((ServerLevel)((MutantZombie)this.mob).level(), damageSource, (float)((MutantZombie)this.mob).getAttributeValue(Attributes.ATTACK_DAMAGE))) {
                            EntityUtil.disableShield(target, 150);
                        }
                        double x = target.getX() - ((MutantZombie)this.mob).getX();
                        double z = target.getZ() - ((MutantZombie)this.mob).getZ();
                        double d = Math.sqrt(x * x + z * z);
                        target.setDeltaMovement(x / d * 0.6, -1.2, z / d * 0.6);
                        target.invulnerableTime = 10;
                        EntityUtil.sendPlayerVelocityPacket((Entity)target);
                        EntityUtil.stunRavager(target);
                        ((MutantZombie)this.mob).playSound((SoundEvent)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_GRUNT_SOUND_EVENT.value(), 0.3f, 0.8f + ((MutantZombie)this.mob).random.nextFloat() * 0.4f);
                    }
                    if (!(!((MutantZombie)this.mob).onGround() && ((MutantZombie)this.mob).getInBlockState().getFluidState().isEmpty() || ((MutantZombie)this.mob).isThrowAttackFinished())) {
                        this.finish = 0;
                        ((MutantZombie)this.mob).setThrowAttackFinished(true);
                    }
                    if (this.finish >= 0) {
                        ++this.finish;
                    }
                }
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.finish = -1;
            ((MutantZombie)this.mob).setThrowAttackHit(false);
            ((MutantZombie)this.mob).setThrowAttackFinished(false);
        }
    }
}

