/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.projectile;

import fuzs.mutantmonsters.init.ModEntityTypes;
import fuzs.mutantmonsters.init.ModItems;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrowableBlock
extends ThrowableProjectile {
    private static final EntityDataAccessor<OptionalInt> DATA_OWNER_ENTITY_ID = SynchedEntityData.defineId(ThrowableBlock.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private static final EntityDataAccessor<BlockState> DATA_BLOCK_STATE_ID = SynchedEntityData.defineId(ThrowableBlock.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    private static final EntityDataAccessor<Boolean> DATA_IS_HELD = SynchedEntityData.defineId(ThrowableBlock.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_IS_LARGE = SynchedEntityData.defineId(ThrowableBlock.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public ThrowableBlock(EntityType<? extends ThrowableBlock> type, Level level) {
        super(type, level);
    }

    public ThrowableBlock(double x, double y, double z, LivingEntity livingEntity) {
        super((EntityType)ModEntityTypes.THROWABLE_BLOCK_ENTITY_TYPE.value(), x, y, z, livingEntity.level());
        this.setOwner((Entity)livingEntity);
    }

    public ThrowableBlock(MutantEnderman mutantEnderman, int armIndex) {
        this(mutantEnderman.getX(), mutantEnderman.getY() + 4.7, mutantEnderman.getZ(), (LivingEntity)mutantEnderman);
        this.setBlockState(mutantEnderman.getHeldBlock(armIndex).orElseGet(() -> ((Block)Blocks.AIR).defaultBlockState()));
        boolean outer = armIndex <= 1;
        boolean right = (armIndex & 1) == 0;
        LivingEntity attackTarget = mutantEnderman.getTarget();
        Vec3 forward = EntityUtil.getDirVector(this.getYRot(), outer ? 2.7f : 1.4f);
        Vec3 strafe = EntityUtil.getDirVector(this.getYRot() + (right ? 90.0f : -90.0f), outer ? 2.2f : 2.0f);
        this.setPos(this.getX() + forward.x + strafe.x, this.getY() + (double)(outer ? 2.8f : 1.1f) - 4.8, this.getZ() + forward.z + strafe.z);
        if (attackTarget != null) {
            double d0 = attackTarget.getX() - this.getX();
            double d1 = attackTarget.getY(0.33) - this.getY();
            double d2 = attackTarget.getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            this.shoot(d0, d1 + d3 * 0.1, d2, 1.4f, 1.0f);
        } else {
            this.throwBlock((LivingEntity)mutantEnderman);
        }
    }

    public ThrowableBlock(MutantSnowGolem mutantSnowGolem) {
        this(mutantSnowGolem.getX(), mutantSnowGolem.getY() + 1.955 - 0.1 + 1.0, mutantSnowGolem.getZ(), (LivingEntity)mutantSnowGolem);
        this.setYRot(mutantSnowGolem.getYRot());
        this.setBlockState(Blocks.ICE.defaultBlockState());
    }

    public ThrowableBlock(Player player, BlockState blockState, BlockPos blockPos) {
        this((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5, (LivingEntity)player);
        this.setBlockState(blockState);
        this.setHeld(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_OWNER_ENTITY_ID, (Object)OptionalInt.empty());
        builder.define(DATA_BLOCK_STATE_ID, (Object)Blocks.GRASS_BLOCK.defaultBlockState());
        builder.define(DATA_IS_HELD, (Object)false);
        builder.define(DATA_IS_LARGE, (Object)false);
    }

    public BlockState getBlockState() {
        return (BlockState)this.entityData.get(DATA_BLOCK_STATE_ID);
    }

    private void setBlockState(BlockState blockState) {
        this.entityData.set(DATA_BLOCK_STATE_ID, (Object)blockState);
    }

    public boolean isHeld() {
        return (Boolean)this.entityData.get(DATA_IS_HELD);
    }

    private void setHeld(boolean held) {
        this.entityData.set(DATA_IS_HELD, (Object)held);
    }

    public boolean isLarge() {
        return (Boolean)this.entityData.get(DATA_IS_LARGE);
    }

    public void setOwner(Entity entity) {
        super.setOwner(entity);
        if (entity != null) {
            this.entityData.set(DATA_OWNER_ENTITY_ID, (Object)OptionalInt.of(entity.getId()));
            this.entityData.set(DATA_IS_LARGE, (Object)this.isThrownBySnowGolem());
        }
    }

    public boolean isThrownBySnowGolem() {
        return this.getOwner() != null && this.getOwner().getType() == ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.value();
    }

    protected double getDefaultGravity() {
        EntityType entityType;
        EntityType entityType2 = entityType = this.getOwner() != null ? this.getOwner().getType() : null;
        if (entityType == EntityType.PLAYER) {
            return 0.04;
        }
        if (entityType == ModEntityTypes.MUTANT_SNOW_GOLEM_ENTITY_TYPE.value()) {
            return 0.06;
        }
        return 0.01;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean isPickable() {
        return this.isAlive() && !this.isThrownBySnowGolem();
    }

    public boolean isPushable() {
        return this.isHeld() && this.isAlive();
    }

    public void push(Entity entityIn) {
        if (entityIn != this.getOwner()) {
            super.push(entityIn);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            for (int i = 0; i < 60; ++i) {
                double x = this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth();
                double y = this.getY() + 0.5 + (double)(this.random.nextFloat() * this.getBbHeight());
                double z = this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth();
                double motx = (this.random.nextFloat() - this.random.nextFloat()) * 3.0f;
                double moty = 0.5f + this.random.nextFloat() * 2.0f;
                double motz = (this.random.nextFloat() - this.random.nextFloat()) * 3.0f;
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.getBlockState()), x, y, z, motx, moty, motz);
            }
        }
    }

    public void tick() {
        if (this.isHeld()) {
            if (!this.level().isClientSide) {
                this.setSharedFlag(6, this.hasGlowingTag());
            }
            this.baseTick();
            Entity thrower = this.getOwner();
            if (thrower == null) {
                Entity entity;
                OptionalInt optionalInt = (OptionalInt)this.entityData.get(DATA_OWNER_ENTITY_ID);
                if (optionalInt.isPresent() && (entity = this.level().getEntity(optionalInt.getAsInt())) instanceof LivingEntity) {
                    thrower = entity;
                }
                if (thrower != null) {
                    this.setOwner(thrower);
                }
            } else if (thrower instanceof LivingEntity) {
                Vec3 vec = thrower.getLookAngle();
                double x = thrower.getX() + vec.x * 1.6 - this.getX();
                double y = thrower.getEyeY() + vec.y * 1.6 - this.getY();
                double z = thrower.getZ() + vec.z * 1.6 - this.getZ();
                double offset = 0.6;
                this.setDeltaMovement(x * offset, y * offset, z * offset);
                this.move(MoverType.SELF, this.getDeltaMovement());
                if (!(this.level().isClientSide || thrower.isAlive() && !thrower.isSpectator() && ((LivingEntity)thrower).isHolding((Item)ModItems.ENDERSOUL_HAND_ITEM.value()))) {
                    this.setHeld(false);
                }
            }
        } else {
            super.tick();
            this.hasImpulse = true;
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (!super.canHitEntity(entity)) {
            return false;
        }
        return !this.isThrownBySnowGolem() || MutantSnowGolem.canHarm(this.getOwner(), entity);
    }

    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (itemStack.getItem() != ModItems.ENDERSOUL_HAND_ITEM.value()) {
            return InteractionResult.PASS;
        }
        if (this.isHeld()) {
            if (this.getOwner() == player) {
                if (!this.level().isClientSide) {
                    this.setHeld(false);
                    this.throwBlock((LivingEntity)player);
                }
                ItemHelper.hurtAndBreak((ItemStack)itemStack, (int)1, (LivingEntity)player, (InteractionHand)interactionHand);
                return InteractionResultHelper.sidedSuccess((boolean)this.level().isClientSide);
            }
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide) {
            this.setHeld(true);
            this.setOwner((Entity)player);
        }
        return InteractionResultHelper.sidedSuccess((boolean)this.level().isClientSide);
    }

    private void throwBlock(LivingEntity thrower) {
        this.setYRot(thrower.getYRot());
        this.setXRot(thrower.getXRot());
        float f = 0.4f;
        this.shoot(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))) * f, -Mth.sin((float)(this.getXRot() * ((float)Math.PI / 180))) * f, Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * Mth.cos((float)(this.getXRot() * ((float)Math.PI / 180))) * f, 1.4f, 1.0f);
    }

    protected void onHit(HitResult hitResult) {
        LivingEntity livingEntity;
        Entity thrower = this.getOwner();
        LivingEntity livingEntity2 = livingEntity = thrower instanceof LivingEntity ? (LivingEntity)thrower : null;
        if (this.isThrownBySnowGolem()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (Mob mob : this.level().getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate(2.5, 2.0, 2.5), this::canHitEntity)) {
                    if (!(this.distanceToSqr((Entity)mob) <= 6.25)) continue;
                    DamageSource damageSource = this.level().damageSources().mobProjectile((Entity)this, livingEntity);
                    mob.hurtServer(serverLevel, damageSource, 4.0f + (float)this.random.nextInt(3));
                }
                if (hitResult.getType() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitResult).getEntity();
                    DamageSource damageSource = this.level().damageSources().thrown((Entity)this, (Entity)livingEntity);
                    entity.hurtServer(serverLevel, damageSource, 4.0f);
                }
                if (!this.level().isClientSide) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)3);
                    this.discard();
                }
            }
            this.playSound(this.getBlockState().getSoundType().getBreakSound(), 0.8f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.8f);
        } else {
            ServerLevel serverLevel;
            boolean throwerAllowedToPlace = ThrowableBlock.isThrowerAllowedToPlace(livingEntity);
            if (hitResult.getType() == HitResult.Type.BLOCK) {
                blockHitResult = (BlockHitResult)hitResult;
                this.onHitBlock(blockHitResult);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel2 = (ServerLevel)level;
                    BlockPos blockPos = blockHitResult.getBlockPos().relative(blockHitResult.getDirection());
                    if (throwerAllowedToPlace && this.level().getBlockState(blockPos).canBeReplaced() && this.getBlockState().canSurvive((LevelReader)this.level(), blockPos)) {
                        this.level().setBlockAndUpdate(blockPos, this.getBlockState());
                        this.getBlockState().getBlock().setPlacedBy(this.level(), blockPos, this.getBlockState(), livingEntity, ItemStack.EMPTY);
                        SoundType soundType = this.getBlockState().getSoundType();
                        this.playSound(soundType.getPlaceSound(), (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                    } else {
                        this.level().levelEvent(2001, blockPos, Block.getId((BlockState)this.getBlockState()));
                        if (serverLevel2.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            Block.dropResources((BlockState)this.getBlockState(), (Level)serverLevel2, (BlockPos)this.blockPosition());
                        }
                    }
                }
            } else {
                blockHitResult = this.level();
                if (blockHitResult instanceof ServerLevel) {
                    serverLevel = (ServerLevel)blockHitResult;
                    if (hitResult.getType() == HitResult.Type.ENTITY) {
                        Entity entity = ((EntityHitResult)hitResult).getEntity();
                        DamageSource damageSource = serverLevel.damageSources().thrown((Entity)this, (Entity)livingEntity);
                        entity.hurtServer(serverLevel, damageSource, 4.0f);
                        this.level().levelEvent(2001, this.blockPosition(), Block.getId((BlockState)this.getBlockState()));
                        if (serverLevel.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            Block.dropResources((BlockState)this.getBlockState(), (Level)serverLevel, (BlockPos)this.blockPosition());
                        }
                    }
                }
            }
            Level level = this.level();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                for (Entity entity : this.level().getEntities((Entity)this, this.getBoundingBox().inflate(2.0), this::canHitEntity)) {
                    if (entity.is((Entity)livingEntity) || !(this.distanceToSqr(entity) <= 4.0)) continue;
                    entity.hurtServer(serverLevel, this.level().damageSources().mobProjectile((Entity)this, livingEntity), (float)(6 + this.random.nextInt(3)));
                }
                this.discard();
            }
        }
    }

    public static boolean isThrowerAllowedToPlace(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player.mayBuild();
        }
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            Level level = mob.level();
            if (!(level instanceof ServerLevel)) {
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            return EntityHelper.isMobGriefingAllowed((ServerLevel)serverLevel, (Entity)livingEntity);
        }
        return false;
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean("Held", this.isHeld());
        valueOutput.store("BlockState", BlockState.CODEC, (Object)this.getBlockState());
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.setHeld(valueInput.getBooleanOr("Held", false));
        valueInput.read("BlockState", BlockState.CODEC).ifPresent(this::setBlockState);
    }
}

