/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.item;

import fuzs.mutantmonsters.world.level.MutatedExplosionHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;

public class CreeperShardItem
extends Item {
    public CreeperShardItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 1, false);
    }

    public void hurtEnemy(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        int damageValue = itemStack.getDamageValue();
        if (damageValue > 0) {
            Player player;
            itemStack.setDamageValue(damageValue - 1);
            LivingEntity livingEntity = attacker;
            if (!(livingEntity instanceof Player && (player = (Player)livingEntity).isCreative() || attacker.getRandom().nextInt(4) != 0)) {
                attacker.addEffect(new MobEffectInstance(MobEffects.POISON, 80 + attacker.getRandom().nextInt(40)));
            }
        }
        target.knockback((double)0.9f, attacker.getX() - target.getX(), attacker.getZ() - target.getZ());
        attacker.level().playSound(null, target.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.NEUTRAL, 0.3f, 0.8f + attacker.getRandom().nextFloat() * 0.4f);
    }

    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        int maxDamage = itemInHand.getMaxDamage();
        int damageValue = itemInHand.getDamageValue();
        if (damageValue < maxDamage) {
            if (!level.isClientSide) {
                float radius = 5.0f * (float)(maxDamage - damageValue) / 16.0f;
                if (damageValue == 0) {
                    radius += 2.0f;
                }
                level.explode((Entity)player, Explosion.getDefaultDamageSource((Level)level, (Entity)player), (ExplosionDamageCalculator)new MutatedExplosionHelper.MutatedExplosionDamageCalculator(), player.getX(), player.getY() + 1.0, player.getZ(), radius, false, player.mayBuild() ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
            }
            itemInHand.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)interactionHand));
            player.getCooldowns().addCooldown(itemInHand, (maxDamage - damageValue) * 2);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHelper.success((ItemStack)itemInHand);
        }
        return super.use(level, player, interactionHand);
    }
}

