/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.item;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.config.ServerConfig;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModTags;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import fuzs.mutantmonsters.world.entity.projectile.ThrowableBlock;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import fuzs.puzzleslib.api.util.v1.InteractionResultHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EndersoulHandItem
extends Item {
    public EndersoulHandItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-2.4f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2, false);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState blockState = level.getBlockState(pos);
        ItemStack itemStack = context.getItemInHand();
        Player player = context.getPlayer();
        if (context.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (!MutantEnderman.canBlockBeHeld(level, pos, blockState, ModTags.ENDERSOUL_HAND_HOLDABLE_IMMUNE_BLOCK_TAG)) {
            return InteractionResult.PASS;
        }
        if (!level.mayInteract((Entity)player, pos)) {
            return InteractionResult.PASS;
        }
        if (!player.mayUseItemAt(pos, context.getClickedFace(), itemStack)) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide) {
            level.addFreshEntity((Entity)new ThrowableBlock(player, blockState, pos));
            level.removeBlock(pos, false);
        }
        return InteractionResultHelper.sidedSuccess((boolean)level.isClientSide);
    }

    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (!player.isSecondaryUseActive()) {
            return InteractionResultHelper.pass((ItemStack)itemInHand);
        }
        HitResult result = player.pick((double)((ServerConfig)MutantMonsters.CONFIG.get(ServerConfig.class)).endersoulHandTeleportDistance, 1.0f, false);
        if (result.getType() != HitResult.Type.BLOCK) {
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".teleport_failed")), true);
            return InteractionResultHelper.fail((ItemStack)itemInHand);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos startPos = ((BlockHitResult)result).getBlockPos();
            BlockPos endPos = startPos.relative(((BlockHitResult)result).getDirection());
            BlockPos posDown = startPos.below();
            if (!level.isEmptyBlock(posDown) || !level.getBlockState(posDown).blocksMotion()) {
                for (int i = 0; i < 3; ++i) {
                    BlockPos checkPos = startPos.above(i + 1);
                    if (!level.isEmptyBlock(checkPos)) continue;
                    endPos = checkPos;
                    break;
                }
            }
            level.playSound(null, player.xo, player.yo, player.zo, SoundEvents.CHORUS_FRUIT_TELEPORT, player.getSoundSource(), 1.0f, 1.0f);
            player.teleportTo((double)endPos.getX() + 0.5, (double)endPos.getY(), (double)endPos.getZ() + 0.5);
            level.playSound(null, endPos, SoundEvents.CHORUS_FRUIT_TELEPORT, player.getSoundSource(), 1.0f, 1.0f);
            MutantEnderman.teleportAttack(serverLevel, (LivingEntity)player);
            EntityUtil.sendParticlePacket((Entity)player, (ParticleOptions)ModRegistry.ENDERSOUL_PARTICLE_TYPE.value(), 256);
            player.getCooldowns().addCooldown(itemInHand, 200);
            ItemHelper.hurtAndBreak((ItemStack)itemInHand, (int)4, (LivingEntity)player, (InteractionHand)interactionHand);
        }
        player.fallDistance = 0.0;
        player.swing(interactionHand);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHelper.sidedSuccess((ItemStack)itemInHand, (boolean)level.isClientSide);
    }
}

