/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.item;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;

public class SkeletonArmorItem
extends Item {
    public SkeletonArmorItem(ArmorMaterial armorMaterial, ArmorType armorType, Item.Properties properties) {
        super(SkeletonArmorItem.skeletonProperties(armorMaterial, armorType, properties));
    }

    static Item.Properties skeletonProperties(ArmorMaterial armorMaterial, ArmorType armorType, Item.Properties properties) {
        properties.humanoidArmor(armorMaterial, armorType);
        switch (armorType) {
            case BOOTS: {
                properties.attributes(SkeletonArmorItem.withJumpStrength(armorType, armorMaterial.createAttributes(armorType), 2));
                break;
            }
            case LEGGINGS: {
                properties.attributes(SkeletonArmorItem.withMovementSpeed(armorType, armorMaterial.createAttributes(armorType), 2));
            }
        }
        return properties;
    }

    static ItemAttributeModifiers withJumpStrength(ArmorType armorType, ItemAttributeModifiers itemAttributeModifiers, int amplifier) {
        EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)armorType.getSlot());
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)("armor." + armorType.getName()));
        return itemAttributeModifiers.withModifierAdded(Attributes.JUMP_STRENGTH, new AttributeModifier(resourceLocation, 0.1 * (double)amplifier, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup).withModifierAdded(Attributes.SAFE_FALL_DISTANCE, new AttributeModifier(resourceLocation, 1.0 * (double)amplifier, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
    }

    static ItemAttributeModifiers withMovementSpeed(ArmorType armorType, ItemAttributeModifiers itemAttributeModifiers, int amplifier) {
        EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)armorType.getSlot());
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)("armor." + armorType.getName()));
        return itemAttributeModifiers.withModifierAdded(Attributes.MOVEMENT_SPEED, new AttributeModifier(resourceLocation, 0.2 * (double)amplifier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), equipmentSlotGroup);
    }

    public Component getDescriptionComponent() {
        return Component.translatable((String)(this.getDescriptionId() + ".description")).withStyle(ChatFormatting.GOLD);
    }
}

