/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.level;

import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.effect.ChemicalXMobEffect;
import fuzs.mutantmonsters.world.entity.SkullSpirit;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.phys.Vec3;

public class MutatedExplosionHelper {
    public static void onExplosionDetonate(ServerLevel serverLevel, ServerExplosion explosion, List<BlockPos> affectedBlocks, List<Entity> affectedEntities) {
        if (explosion.damageCalculator instanceof MutatedExplosionDamageCalculator) {
            affectedEntities.removeIf(entity -> !MutatedExplosionHelper.isAffectedByExplosion(serverLevel, explosion, entity));
        }
    }

    private static boolean isAffectedByExplosion(ServerLevel serverLevel, ServerExplosion explosion, Entity entity) {
        if (entity.ignoreExplosion((Explosion)explosion)) {
            return false;
        }
        if (entity instanceof MutantCreeper) {
            return false;
        }
        Entity entity2 = explosion.getDirectSourceEntity();
        if (entity2 instanceof SkullSpirit) {
            LivingEntity livingEntity;
            SkullSpirit skullSpirit = (SkullSpirit)entity2;
            if (entity == skullSpirit.getTarget()) {
                return !skullSpirit.isAttached();
            }
            return !(entity instanceof LivingEntity) || ChemicalXMobEffect.IS_APPLICABLE.test(livingEntity = (LivingEntity)entity, serverLevel);
        }
        return true;
    }

    public static void explode(Entity entity, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction) {
        DamageSource damageSource = Explosion.getDefaultDamageSource((Level)entity.level(), (Entity)entity);
        MutatedExplosionDamageCalculator damageCalculator = new MutatedExplosionDamageCalculator();
        entity.level().explode(entity, damageSource, (ExplosionDamageCalculator)damageCalculator, entity.getX(), entity.getY(), entity.getZ(), radius, fire, explosionInteraction, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE);
    }

    public static class MutatedExplosionDamageCalculator
    extends ExplosionDamageCalculator {
        public boolean shouldDamageEntity(Explosion explosion, Entity entity) {
            if (explosion instanceof ServerExplosion) {
                Entity entity2;
                ServerPlayer serverPlayer;
                ServerExplosion serverExplosion = (ServerExplosion)explosion;
                if (entity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)entity).isBlocking() && (entity2 = explosion.getDirectSourceEntity()) instanceof MutantCreeper) {
                    MutantCreeper mutantCreeper = (MutantCreeper)entity2;
                    float seenPercent = this.getKnockbackMultiplier(entity) == 0.0f ? 0.0f : ServerExplosion.getSeenPercent((Vec3)explosion.center(), (Entity)entity);
                    float damageAmount = this.getEntityDamageAmount(explosion, entity, seenPercent);
                    if (!entity.hurtServer(serverPlayer.level(), serverExplosion.damageSource, damageAmount)) {
                        if (mutantCreeper.isJumpAttacking()) {
                            EntityUtil.disableShield((LivingEntity)serverPlayer, mutantCreeper.isCharged() ? 200 : 100);
                        } else {
                            ItemHelper.hurtAndBreak((ItemStack)serverPlayer.getUseItem(), (int)((int)(damageAmount * 2.0f)), (LivingEntity)serverPlayer, (InteractionHand)serverPlayer.getUsedItemHand());
                        }
                        entity.hurtServer(serverPlayer.level(), serverExplosion.damageSource, damageAmount * 0.5f);
                    }
                    return false;
                }
            }
            return super.shouldDamageEntity(explosion, entity);
        }
    }
}

