/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.particle.CustomTintTerrainParticleData;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class BarrelBlock
extends WoodStorageBlockBase {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty FLAT_TOP = BooleanProperty.create((String)"flat_top");
    private static final VoxelShape ITEM_ENTITY_COLLISION_SHAPE = BarrelBlock.box((double)0.05, (double)0.05, (double)0.05, (double)15.95, (double)15.95, (double)15.95);

    public BarrelBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, float explosionResistance, BlockBehaviour.Properties properties) {
        this(numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier, explosionResistance, stateDef -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)stateDef.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)TICKING, (Comparable)Boolean.valueOf(false))).setValue((Property)FLAT_TOP, (Comparable)Boolean.valueOf(false)), properties);
    }

    public BarrelBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, float explosionResistance, Function<StateDefinition<Block, BlockState>, BlockState> getDefaultState, BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().mapColor(MapColor.WOOD).strength(2.5f).sound(SoundType.WOOD).isRedstoneConductor((state, level, pos) -> BarrelBlock.isFlatTop(state)).explosionResistance(explosionResistance), numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
        this.registerDefaultState(getDefaultState.apply((StateDefinition<Block, BlockState>)this.stateDefinition));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        super.addCreativeTabItems(itemConsumer);
        if (this != ModBlocks.BARREL.get()) {
            return;
        }
        ItemStack flatBarrel = WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)this), WoodType.ACACIA);
        BarrelBlockItem.toggleFlatTop(flatBarrel);
        itemConsumer.accept(flatBarrel);
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        level.sendParticles((ParticleOptions)new CustomTintTerrainParticleData(state1, pos), entity.getX(), entity.getY(), entity.getZ(), numberOfParticles, 0.0, 0.0, 0.0, 0.15);
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        level.addParticle((ParticleOptions)new CustomTintTerrainParticleData(state, pos), entity.getX() + (level.random.nextDouble() - 0.5) * (double)entity.getBbWidth(), entity.getY() + 0.1, entity.getZ() + (level.random.nextDouble() - 0.5) * (double)entity.getBbWidth(), vec3.x * -4.0, 1.5, vec3.z * -4.0);
        return true;
    }

    public InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).map(b -> {
            if (b.isPacked()) {
                return InteractionResult.FAIL;
            }
            if (level.isClientSide || hand == InteractionHand.OFF_HAND) {
                return InteractionResult.SUCCESS;
            }
            InteractionResult result = this.tryItemInteraction(player, hand, (WoodStorageBlockEntity)b, stack, this.getFacing(state), hitResult);
            if (result.consumesAction()) {
                return result;
            }
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }).orElse((InteractionResult)InteractionResult.TRY_WITH_EMPTY_HAND);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        player.awardStat(Stats.OPEN_BARREL);
        player.openMenu((MenuProvider)new SimpleMenuProvider((w, p, pl) -> this.instantiateContainerMenu(w, pl, pos), WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(StorageBlockEntity::getDisplayName).orElse((Component)Component.empty())), pos);
        Level level2 = player.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            PiglinAi.angerNearbyPiglins((ServerLevel)serverLevel, (Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BarrelBlockEntity.class).ifPresent(barrel -> {
            Map<BarrelMaterial, ResourceLocation> materials = BarrelBlockItem.getMaterials(stack);
            if (!materials.isEmpty()) {
                barrel.setMaterials(new EnumMap<BarrelMaterial, ResourceLocation>(materials));
            }
        });
    }

    protected StorageContainerMenu instantiateContainerMenu(int w, Player pl, BlockPos pos) {
        return new StorageContainerMenu(w, pl, pos);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(StorageBlockEntity::recheckOpen);
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (BlockState)state.setValue(FACING, (Comparable)direction.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, TICKING, FLAT_TOP});
    }

    @Override
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack cloneItemStack = super.getCloneItemStack(level, pos, state, includeData);
        BarrelBlockItem.setFlatTop(cloneItemStack, (Boolean)state.getValue((Property)FLAT_TOP));
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BarrelBlockEntity.class).ifPresent(barrelBlockEntity -> {
            Map<BarrelMaterial, ResourceLocation> materials = barrelBlockEntity.getMaterials();
            if (!materials.isEmpty()) {
                BarrelBlockItem.setMaterials(cloneItemStack, materials);
            }
        });
        return cloneItemStack;
    }

    @Override
    public void addDropData(ItemStack stack, StorageBlockEntity be) {
        BarrelBlockEntity barrelBlockEntity;
        Map<BarrelMaterial, ResourceLocation> materials;
        super.addDropData(stack, be);
        BlockState state = be.getBlockState();
        BarrelBlockItem.setFlatTop(stack, (Boolean)state.getValue((Property)FLAT_TOP));
        if (be instanceof BarrelBlockEntity && !(materials = (barrelBlockEntity = (BarrelBlockEntity)be).getMaterials()).isEmpty()) {
            BarrelBlockItem.setMaterials(stack, materials);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)blockPlaceContext.getNearestLookingDirection().getOpposite())).setValue((Property)FLAT_TOP, (Comparable)Boolean.valueOf(BarrelBlockItem.isFlatTop((DataComponentHolder)blockPlaceContext.getItemInHand())));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        return context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).getEntity() instanceof ItemEntity || this.isCalledByCollisionCacheLogic(level, pos) ? ITEM_ENTITY_COLLISION_SHAPE : super.getCollisionShape(state, level, pos, context);
    }

    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.block();
    }

    private boolean isCalledByCollisionCacheLogic(BlockGetter level, BlockPos pos) {
        return level instanceof EmptyBlockGetter && pos == BlockPos.ZERO;
    }

    @Override
    @Nullable
    public StorageBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BarrelBlockEntity(pos, state);
    }

    @Override
    protected BlockEntityType<? extends StorageBlockEntity> getBlockEntityType() {
        return ModBlocks.BARREL_BLOCK_ENTITY_TYPE.get();
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.getValue(FACING);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    private static boolean isFlatTop(BlockState state) {
        return (Boolean)state.getValue((Property)FLAT_TOP);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }
}

