/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum BarrelMaterial implements StringRepresentable
{
    SIDE("side", MaterialModelPart.CORE, new BarrelMaterial[0]),
    SIDE_TRIM("side_trim", MaterialModelPart.TRIM, new BarrelMaterial[0]),
    BOTTOM("bottom", MaterialModelPart.CORE, new BarrelMaterial[0]),
    BOTTOM_TRIM("bottom_trim", MaterialModelPart.TRIM, new BarrelMaterial[0]),
    TOP("top", MaterialModelPart.CORE, new BarrelMaterial[0]),
    TOP_TRIM("top_trim", MaterialModelPart.TRIM, new BarrelMaterial[0]),
    TOP_INNER_TRIM("top_inner_trim", MaterialModelPart.TRIM, new BarrelMaterial[0]),
    ALL("all", MaterialModelPart.BOTH, SIDE, SIDE_TRIM, BOTTOM, BOTTOM_TRIM, TOP, TOP_TRIM, TOP_INNER_TRIM),
    ALL_TRIM("all_trim", MaterialModelPart.TRIM, SIDE_TRIM, BOTTOM_TRIM, TOP_TRIM, TOP_INNER_TRIM),
    ALL_BUT_TRIM("all_but_trim", MaterialModelPart.CORE, SIDE, BOTTOM, TOP),
    TOP_ALL("top_all", MaterialModelPart.BOTH, TOP, TOP_TRIM, TOP_INNER_TRIM),
    SIDE_ALL("side_all", MaterialModelPart.BOTH, SIDE, SIDE_TRIM),
    BOTTOM_ALL("bottom_all", MaterialModelPart.BOTH, BOTTOM, BOTTOM_TRIM);

    public static final Codec<BarrelMaterial> CODEC;
    public static final StreamCodec<FriendlyByteBuf, BarrelMaterial> STREAM_CODEC;
    private final String name;
    private MaterialModelPart materialModelPart;
    private final BarrelMaterial[] children;
    private static final Map<String, BarrelMaterial> NAME_VALUES;

    private BarrelMaterial(String name, MaterialModelPart materialModelPart, BarrelMaterial ... children) {
        this.name = name;
        this.materialModelPart = materialModelPart;
        this.children = children;
    }

    public MaterialModelPart getMaterialModelPart() {
        return this.materialModelPart;
    }

    public String getSerializedName() {
        return this.name;
    }

    public BarrelMaterial[] getChildren() {
        BarrelMaterial[] barrelMaterialArray;
        if (this.children.length > 0) {
            barrelMaterialArray = this.children;
        } else {
            BarrelMaterial[] barrelMaterialArray2 = new BarrelMaterial[1];
            barrelMaterialArray = barrelMaterialArray2;
            barrelMaterialArray2[0] = this;
        }
        return barrelMaterialArray;
    }

    @Nullable
    public Direction getLeafSide() {
        if (this.isLeaf()) {
            return switch (this.ordinal()) {
                case 0, 1 -> Direction.NORTH;
                case 2, 3 -> Direction.DOWN;
                case 4, 5 -> Direction.UP;
                default -> null;
            };
        }
        return null;
    }

    public boolean isLeaf() {
        return this.children.length == 0;
    }

    public static BarrelMaterial fromName(String name) {
        return NAME_VALUES.getOrDefault(name, SIDE);
    }

    public static List<BarrelMaterial> getFillFromDefaults(BarrelMaterial material) {
        return switch (material.ordinal()) {
            case 0 -> List.of(BOTTOM, TOP, TOP_INNER_TRIM);
            case 1 -> List.of(BOTTOM_TRIM, TOP_TRIM);
            case 2 -> List.of(SIDE, TOP, TOP_INNER_TRIM);
            case 3 -> List.of(SIDE_TRIM, TOP_TRIM);
            case 4 -> List.of(TOP_INNER_TRIM, SIDE, BOTTOM);
            case 5 -> List.of(SIDE_TRIM, BOTTOM_TRIM);
            case 6 -> List.of(TOP_TRIM, SIDE_TRIM, BOTTOM_TRIM);
            default -> List.of();
        };
    }

    static {
        CODEC = StringRepresentable.fromEnum(BarrelMaterial::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(BarrelMaterial.class);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BarrelMaterial value : BarrelMaterial.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
    }

    public static enum MaterialModelPart {
        BOTH,
        TRIM,
        CORE;

    }
}

