/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;

public class BarrelMaterialRecipe
extends CustomRecipe {
    public BarrelMaterialRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        int barrelRow = -1;
        int barrelCol = -1;
        int minRowWithBlock = Integer.MAX_VALUE;
        int minColWithBlock = Integer.MAX_VALUE;
        int maxRowWithBlock = Integer.MIN_VALUE;
        int maxColWithBlock = Integer.MIN_VALUE;
        HashMap<Integer, Integer> rowCounts = new HashMap<Integer, Integer>();
        for (int row = 0; row < input.height(); ++row) {
            for (int col = 0; col < input.width(); ++col) {
                BlockItem blockItem;
                BlockItem blockItem2;
                ItemStack item = input.getItem(col + row * input.width());
                if (item.isEmpty()) continue;
                Item item2 = item.getItem();
                if (item2 instanceof BlockItem && (blockItem2 = (BlockItem)item2).getBlock() instanceof BarrelBlock) {
                    if (barrelRow < 0) {
                        barrelRow = row;
                        barrelCol = col;
                        continue;
                    }
                    return false;
                }
                item2 = item.getItem();
                if (item2 instanceof BlockItem && Block.isShapeFullBlock((VoxelShape)(blockItem = (BlockItem)item2).getBlock().defaultBlockState().getShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO))) {
                    boolean isBottomMiddleAndBottomLeftHasBlock;
                    boolean bl = isBottomMiddleAndBottomLeftHasBlock = barrelCol == col && barrelRow < row && rowCounts.getOrDefault(row, 0) > 0;
                    if (isBottomMiddleAndBottomLeftHasBlock) {
                        return false;
                    }
                    rowCounts.compute(row, (k, v) -> v == null ? 1 : v + 1);
                    if (row < minRowWithBlock) {
                        minRowWithBlock = row;
                    }
                    if (col < minColWithBlock) {
                        minColWithBlock = col;
                    }
                    if (row > maxRowWithBlock) {
                        maxRowWithBlock = row;
                    }
                    if (col <= maxColWithBlock) continue;
                    maxColWithBlock = col;
                    continue;
                }
                return false;
            }
        }
        if (barrelRow < 0 || rowCounts.isEmpty() || minRowWithBlock < barrelRow - 1 || maxRowWithBlock > barrelRow + 1 || minColWithBlock < barrelCol - 1 || maxColWithBlock > barrelCol + 1) {
            return false;
        }
        return rowCounts.getOrDefault(barrelRow - 1, 0) <= 3 && rowCounts.getOrDefault(barrelRow, 0) <= 2 && rowCounts.getOrDefault(barrelRow + 1, 0) <= 2;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        int barrelColumn = -1;
        int barrelRow = -1;
        ItemStack barrelStackCopy = ItemStack.EMPTY;
        for (int row = 0; row < input.height(); ++row) {
            for (int col = 0; col < input.width(); ++col) {
                BlockItem blockItem;
                Item item;
                ItemStack item2 = input.getItem(col + row * input.width());
                if (item2.isEmpty() || barrelColumn >= 0 || !((item = item2.getItem()) instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof BarrelBlock)) continue;
                barrelColumn = col;
                barrelRow = row;
                barrelStackCopy = item2.copy();
                barrelStackCopy.setCount(1);
            }
        }
        EnumMap<BarrelMaterial, ResourceLocation> materials = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
        materials.putAll(BarrelBlockItem.getMaterials(barrelStackCopy));
        BarrelBlockItem.uncompactMaterials(materials);
        this.fillGridMaterials(input, barrelColumn, barrelRow, materials);
        BarrelMaterialRecipe.fillEmptyMaterialsWithDefaults(materials);
        BarrelBlockItem.compactMaterials(materials);
        BarrelBlockItem.setMaterials(barrelStackCopy, materials);
        BarrelBlockItem.removeCoveredTints(barrelStackCopy, materials);
        return barrelStackCopy;
    }

    private static void fillEmptyMaterialsWithDefaults(Map<BarrelMaterial, ResourceLocation> materials) {
        block0: for (BarrelMaterial material : BarrelMaterial.values()) {
            if (!material.isLeaf() || materials.containsKey((Object)material)) continue;
            for (BarrelMaterial fillFromDefault : BarrelMaterial.getFillFromDefaults(material)) {
                if (!materials.containsKey((Object)fillFromDefault)) continue;
                materials.put(material, materials.get((Object)fillFromDefault));
                continue block0;
            }
        }
    }

    private void fillGridMaterials(CraftingInput input, int barrelColumn, int barrelRow, Map<BarrelMaterial, ResourceLocation> materials) {
        for (int row = 0; row < input.height(); ++row) {
            for (int col = 0; col < input.width(); ++col) {
                Item item;
                ItemStack item2 = input.getItem(col + row * input.width());
                if (row == barrelRow && col == barrelColumn || item2.isEmpty() || !((item = item2.getItem()) instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                List<BarrelMaterial> barrelMaterials = this.getBarrelMaterials(row, col, barrelRow, barrelColumn);
                boolean firstMaterial = true;
                for (BarrelMaterial barrelMaterial : barrelMaterials) {
                    if (!materials.containsKey((Object)barrelMaterial) || firstMaterial) {
                        materials.put(barrelMaterial, BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock()));
                    }
                    firstMaterial = false;
                }
            }
        }
    }

    private List<BarrelMaterial> getBarrelMaterials(int row, int col, int barrelRow, int barrelColumn) {
        if (row < barrelRow) {
            if (col < barrelColumn) {
                return List.of(BarrelMaterial.TOP);
            }
            if (col == barrelColumn) {
                return List.of(BarrelMaterial.TOP_INNER_TRIM, BarrelMaterial.TOP, BarrelMaterial.TOP_TRIM);
            }
            return List.of(BarrelMaterial.TOP_TRIM);
        }
        if (row == barrelRow) {
            if (col < barrelColumn) {
                return List.of(BarrelMaterial.SIDE);
            }
            return List.of(BarrelMaterial.SIDE_TRIM);
        }
        if (col < barrelColumn) {
            return List.of(BarrelMaterial.BOTTOM);
        }
        if (col == barrelColumn) {
            return List.of(BarrelMaterial.BOTTOM, BarrelMaterial.BOTTOM_TRIM);
        }
        return List.of(BarrelMaterial.BOTTOM_TRIM);
    }

    public RecipeSerializer<BarrelMaterialRecipe> getSerializer() {
        return (RecipeSerializer)ModBlocks.BARREL_MATERIAL_RECIPE_SERIALIZER.get();
    }
}

