/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class BarrelBlockItem
extends WoodStorageBlockItem {
    public static final Codec<Map<BarrelMaterial, ResourceLocation>> MATERIALS_CODEC = Codec.simpleMap(BarrelMaterial.CODEC, (Codec)ResourceLocation.CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])BarrelMaterial.values())).codec();
    public static final StreamCodec<FriendlyByteBuf, Map<BarrelMaterial, ResourceLocation>> MATERIALS_STREAM_CODEC = StreamCodec.of((buf, map) -> buf.writeMap(map, BarrelMaterial.STREAM_CODEC, (StreamEncoder)ResourceLocation.STREAM_CODEC), buf -> buf.readMap(BarrelMaterial.STREAM_CODEC, (StreamDecoder)ResourceLocation.STREAM_CODEC));

    public BarrelBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static void toggleFlatTop(ItemStack stack) {
        boolean flatTop = BarrelBlockItem.isFlatTop((DataComponentHolder)stack);
        BarrelBlockItem.setFlatTop(stack, !flatTop);
    }

    public static void setFlatTop(ItemStack stack, boolean flatTop) {
        if (flatTop) {
            stack.set(ModDataComponents.FLAT_TOP, (Object)true);
        } else {
            stack.remove(ModDataComponents.FLAT_TOP);
        }
    }

    public static boolean isFlatTop(DataComponentHolder componentHolder) {
        return (Boolean)componentHolder.getOrDefault(ModDataComponents.FLAT_TOP, (Object)false);
    }

    public static void setMaterials(ItemStack barrel, Map<BarrelMaterial, ResourceLocation> materials) {
        barrel.set(ModDataComponents.BARREL_MATERIALS, Map.copyOf(materials));
    }

    public static Map<BarrelMaterial, ResourceLocation> getMaterials(ItemStack barrel) {
        return (Map)barrel.getOrDefault(ModDataComponents.BARREL_MATERIALS, Map.of());
    }

    public static void removeMaterials(ItemStack stack) {
        stack.remove(ModDataComponents.BARREL_MATERIALS);
    }

    public static void uncompactMaterials(Map<BarrelMaterial, ResourceLocation> materials) {
        if (materials.isEmpty()) {
            return;
        }
        EnumMap uncompactedMaterials = new EnumMap(BarrelMaterial.class);
        materials.forEach((mat, texture) -> {
            for (BarrelMaterial child : mat.getChildren()) {
                uncompactedMaterials.put(child, texture);
            }
        });
        materials.clear();
        materials.putAll(uncompactedMaterials);
    }

    public static void compactMaterials(Map<BarrelMaterial, ResourceLocation> materials) {
        for (BarrelMaterial material : BarrelMaterial.values()) {
            if (material.isLeaf()) continue;
            ResourceLocation firstChildTexture = null;
            boolean allChildrenHaveSameTexture = true;
            for (BarrelMaterial child : material.getChildren()) {
                ResourceLocation texture = materials.get((Object)child);
                if (texture == null || firstChildTexture != null && !firstChildTexture.equals((Object)texture)) {
                    allChildrenHaveSameTexture = false;
                    break;
                }
                if (firstChildTexture != null) continue;
                firstChildTexture = texture;
            }
            if (firstChildTexture == null || !allChildrenHaveSameTexture) continue;
            materials.put(material, firstChildTexture);
            for (BarrelMaterial child : material.getChildren()) {
                materials.remove((Object)child);
            }
        }
    }

    public static void removeCoveredTints(ItemStack barrelStackCopy, Map<BarrelMaterial, ResourceLocation> materials) {
        Item item = barrelStackCopy.getItem();
        if (item instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            boolean hasMainTint = tintableBlockItem.getMainColor(barrelStackCopy).isPresent();
            boolean hasAccentTint = tintableBlockItem.getAccentColor(barrelStackCopy).isPresent();
            if (hasMainTint || hasAccentTint) {
                if (hasMainTint && (materials.containsKey((Object)BarrelMaterial.ALL) || materials.containsKey((Object)BarrelMaterial.ALL_BUT_TRIM))) {
                    tintableBlockItem.removeMainColor(barrelStackCopy);
                }
                if (hasAccentTint && (materials.containsKey((Object)BarrelMaterial.ALL) || materials.containsKey((Object)BarrelMaterial.ALL_TRIM))) {
                    tintableBlockItem.removeAccentColor(barrelStackCopy);
                }
            }
        }
    }

    public static Map<BarrelMaterial, ResourceLocation> getUncompactedMaterials(ItemStack storageStack) {
        EnumMap<BarrelMaterial, ResourceLocation> materials = new EnumMap<BarrelMaterial, ResourceLocation>(BarrelMaterial.class);
        materials.putAll(BarrelBlockItem.getMaterials(storageStack));
        BarrelBlockItem.uncompactMaterials(materials);
        return materials;
    }

    @Override
    public Component getName(ItemStack stack) {
        Component name = BarrelBlockItem.getMaterials(stack).isEmpty() ? super.getName(stack) : BarrelBlockItem.getDisplayName(this.getDescriptionId(), null);
        if (BarrelBlockItem.isFlatTop((DataComponentHolder)stack)) {
            return name.copy().append((Component)Component.translatable((String)(StorageTranslationHelper.INSTANCE.translBlockTooltipKey("barrel") + ".flat_top")));
        }
        return name;
    }

    @Override
    public boolean isTintable(ItemStack stack) {
        return BarrelBlockItem.getMaterials(stack).isEmpty();
    }
}

