/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.fml.loading.FMLEnvironment;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageItemClient;

public class WoodStorageBlockItem
extends StorageBlockItem {
    public WoodStorageBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static void setPacked(ItemStack storageStack, boolean packed) {
        storageStack.set(ModDataComponents.PACKED, (Object)packed);
    }

    public static boolean isPacked(ItemStack storageStack) {
        return (Boolean)storageStack.getOrDefault(ModDataComponents.PACKED, (Object)false);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        if (WoodStorageBlockItem.isPacked(stack)) {
            HolderLookup.Provider registries;
            if (tooltipFlag.isAdvanced() && (registries = context.registries()) != null) {
                StackStorageWrapper.fromStack(registries, stack).getContentsUuid().ifPresent(uuid -> tooltipAdder.accept((Component)Component.literal((String)("UUID: " + String.valueOf(uuid))).withStyle(ChatFormatting.DARK_GRAY)));
            }
            if (!Screen.hasShiftDown()) {
                tooltipAdder.accept((Component)Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (!WoodStorageBlockItem.isPacked(stack)) {
            return Optional.empty();
        }
        if (FMLEnvironment.dist.isClient()) {
            return Optional.ofNullable(StorageItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    @Override
    public void setMainColor(ItemStack storageStack, int mainColor) {
        if (StorageBlockItem.getAccentColorFromComponentHolder((DataComponentGetter)storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setMainColor(storageStack, mainColor);
    }

    @Override
    public void setAccentColor(ItemStack storageStack, int accentColor) {
        if (StorageBlockItem.getMainColorFromComponentHolder((DataComponentGetter)storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setAccentColor(storageStack, accentColor);
    }

    private void removeWoodType(ItemStack storageStack) {
        storageStack.remove(ModDataComponents.WOOD_TYPE);
    }

    public static Optional<WoodType> getWoodType(DataComponentHolder componentHolder) {
        return Optional.ofNullable((WoodType)componentHolder.get(ModDataComponents.WOOD_TYPE));
    }

    public static ItemStack setWoodType(ItemStack storageStack, WoodType woodType) {
        storageStack.set(ModDataComponents.WOOD_TYPE, (Object)woodType);
        return storageStack;
    }

    public Component getName(ItemStack stack) {
        return WoodStorageBlockItem.getDisplayName(this.getDescriptionId(), WoodStorageBlockItem.getWoodType((DataComponentHolder)stack).orElse(null));
    }

    public static Component getDisplayName(String descriptionId, @Nullable WoodType woodType) {
        if (woodType == null) {
            return Component.translatable((String)descriptionId, (Object[])new Object[]{"", ""});
        }
        return Component.translatable((String)descriptionId, (Object[])new Object[]{Component.translatable((String)("wood_name.sophisticatedstorage." + woodType.name().toLowerCase(Locale.ROOT))), " "});
    }
}

