/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Chimney
extends Container
implements ITiledBlock<Container.Tile> {
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final EnumProperty<SideType> NORTH = EnumProperty.create((String)"north", SideType.class);
    public static final EnumProperty<SideType> EAST = EnumProperty.create((String)"east", SideType.class);
    public static final EnumProperty<SideType> SOUTH = EnumProperty.create((String)"south", SideType.class);
    public static final EnumProperty<SideType> WEST = EnumProperty.create((String)"west", SideType.class);
    public static final Map<Direction, EnumProperty<SideType>> SIDES = ImmutableMap.copyOf((Map)((Map)Util.make((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    })));
    public final boolean isNarrow;
    public final int radius;
    public final int wallThickness;
    protected final Function<BlockState, VoxelShape> shapes;

    public Chimney(Properties<?> props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(false))).setValue(NORTH, (Comparable)((Object)SideType.NORMAL))).setValue(EAST, (Comparable)((Object)SideType.NORMAL))).setValue(SOUTH, (Comparable)((Object)SideType.NORMAL))).setValue(WEST, (Comparable)((Object)SideType.NORMAL)));
        this.isNarrow = props.isNarrow;
        this.radius = props.radius;
        this.wallThickness = props.wallThickness;
        this.shapes = this.getShapeForEachState(this::calculateShapeFor);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TOP, NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = super.getStateForPlacement(context);
        state = this.updateTop((LevelReader)level, state, pos);
        for (Direction direction : GameWorld.Directions.of().horizontals().toList()) {
            state = this.updateSide((LevelReader)level, state, pos, direction);
        }
        return state;
    }

    protected VoxelShape calculateShapeFor(BlockState state) {
        return SIDES.entrySet().stream().filter(entry -> state.hasProperty((Property)entry.getValue())).map(entry -> this.makeSideShape((Direction)entry.getKey(), (SideType)((Object)((Object)state.getValue((Property)entry.getValue()))), (Boolean)state.getValue((Property)TOP))).reduce(Shapes.empty(), Shapes::or);
    }

    protected VoxelShape sideWallShape(Direction side, int wallThickness) {
        return switch (side) {
            case Direction.NORTH -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)wallThickness);
            case Direction.SOUTH -> Block.box((double)0.0, (double)0.0, (double)(16 - wallThickness), (double)16.0, (double)16.0, (double)16.0);
            case Direction.WEST -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)wallThickness, (double)16.0, (double)16.0);
            case Direction.EAST -> Block.box((double)(16 - wallThickness), (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            default -> Shapes.empty();
        };
    }

    protected VoxelShape makeSideShape(Direction side, SideType type, boolean top) {
        VoxelShape shape;
        int minXZ = this.isNarrow ? 8 - (this.radius - 1) : 8 - this.radius;
        int maxXZ = this.isNarrow ? 8 + (this.radius - 1) : 8 + this.radius;
        switch (side) {
            case NORTH: {
                VoxelShape voxelShape = Block.box((double)minXZ, (double)0.0, (double)minXZ, (double)maxXZ, (double)16.0, (double)(minXZ + this.wallThickness));
                break;
            }
            case SOUTH: {
                VoxelShape voxelShape = Block.box((double)minXZ, (double)0.0, (double)(maxXZ - this.wallThickness), (double)maxXZ, (double)16.0, (double)maxXZ);
                break;
            }
            case WEST: {
                VoxelShape voxelShape = Block.box((double)minXZ, (double)0.0, (double)minXZ, (double)(minXZ + this.wallThickness), (double)16.0, (double)maxXZ);
                break;
            }
            case EAST: {
                VoxelShape voxelShape = Block.box((double)(maxXZ - this.wallThickness), (double)0.0, (double)minXZ, (double)maxXZ, (double)16.0, (double)maxXZ);
                break;
            }
            default: {
                VoxelShape voxelShape = shape = Shapes.empty();
            }
        }
        if (type != SideType.NORMAL) {
            int thic = minXZ + this.wallThickness;
            VoxelShape bridge = switch (side) {
                case Direction.NORTH -> Block.box((double)minXZ, (double)0.0, (double)0.0, (double)maxXZ, (double)16.0, (double)thic);
                case Direction.SOUTH -> Block.box((double)minXZ, (double)0.0, (double)(16 - thic), (double)maxXZ, (double)16.0, (double)16.0);
                case Direction.WEST -> Block.box((double)0.0, (double)0.0, (double)minXZ, (double)thic, (double)16.0, (double)maxXZ);
                case Direction.EAST -> Block.box((double)(16 - thic), (double)0.0, (double)minXZ, (double)16.0, (double)16.0, (double)maxXZ);
                default -> Shapes.empty();
            };
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)bridge, (BooleanOp)BooleanOp.OR);
            if (type == SideType.PORTAL) {
                int w = this.wallThickness;
                int h = top ? 0 : w;
                VoxelShape hole = switch (side) {
                    case Direction.NORTH -> Block.box((double)(minXZ + w), (double)0.0, (double)0.0, (double)(maxXZ - w), (double)(16 - h), (double)thic);
                    case Direction.SOUTH -> Block.box((double)(minXZ + w), (double)0.0, (double)(16 - thic), (double)(maxXZ - w), (double)(16 - h), (double)16.0);
                    case Direction.WEST -> Block.box((double)0.0, (double)0.0, (double)(minXZ + w), (double)thic, (double)(16 - h), (double)(maxXZ - w));
                    case Direction.EAST -> Block.box((double)(16 - thic), (double)0.0, (double)(minXZ + w), (double)16.0, (double)(16 - h), (double)(maxXZ - w));
                    default -> Shapes.empty();
                };
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)hole, (BooleanOp)BooleanOp.ONLY_FIRST);
            }
        }
        return shape;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapes.apply(pState);
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        BlockState blockState = super.updateShape(state, level, tickAccess, pos, direction, neighborPos, neighborState, randomSource);
        blockState = this.updateTop(level, blockState, pos);
        if (direction.getAxis().getPlane() == Direction.Plane.HORIZONTAL) {
            blockState = this.updateSide(level, blockState, pos, direction);
        }
        return blockState;
    }

    protected BlockState updateTop(LevelReader level, BlockState state, BlockPos pos) {
        boolean chimneyAbove = GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)pos.above());
        return (BlockState)state.setValue((Property)TOP, (Comparable)Boolean.valueOf(!chimneyAbove));
    }

    protected boolean canAttachTo(BlockGetter level, Direction direction, BlockPos pos, BlockState state) {
        if (this.isNarrow) {
            return false;
        }
        if (state.getBlock() instanceof ISmokeContainer) {
            return false;
        }
        VoxelShape blockShape = state.getBlockSupportShape(level, pos);
        if (blockShape == Shapes.block()) {
            return true;
        }
        Direction face = direction.getOpposite();
        VoxelShape faceShape = blockShape.getFaceShape(face);
        Block block = state.getBlock();
        if (block instanceof StairBlock) {
            StairBlock stair = (StairBlock)block;
            VoxelShape slabFace = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0).getFaceShape(face);
            return Shapes.joinIsNotEmpty((VoxelShape)faceShape, (VoxelShape)slabFace, (BooleanOp)BooleanOp.ONLY_FIRST);
        }
        return !faceShape.isEmpty();
    }

    protected BlockState updateSide(LevelReader level, BlockState state, BlockPos pos, Direction facing) {
        BlockPos neighborPos = pos.relative(facing);
        SideType sideType = SideType.NORMAL;
        if (GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)neighborPos)) {
            BlockState neighborState = level.getBlockState(neighborPos);
            if (GameWorld.SmokeContainers.isChimney((LevelReader)level, (BlockPos)neighborPos)) {
                Block block;
                if (!this.isNarrow && (block = neighborState.getBlock()) instanceof Chimney) {
                    Chimney chimney = (Chimney)block;
                    if (!chimney.isNarrow) {
                        sideType = SideType.PORTAL;
                    }
                }
            } else if (AdChimneys.getInstance().emitters.get(level, neighborPos).isPresent()) {
                sideType = SideType.PORTAL;
            } else if (this.canAttachTo((BlockGetter)level, facing, neighborPos, neighborState)) {
                sideType = SideType.BRIDGE;
            }
        }
        return (BlockState)state.setValue((Property)SIDES.get(facing), (Comparable)((Object)sideType));
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return switch (pRot) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, (Comparable)((Object)((SideType)((Object)pState.getValue(SOUTH)))))).setValue(EAST, (Comparable)((Object)((SideType)((Object)pState.getValue(WEST)))))).setValue(SOUTH, (Comparable)((Object)((SideType)((Object)pState.getValue(NORTH)))))).setValue(WEST, (Comparable)((Object)((SideType)((Object)pState.getValue(EAST)))));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, (Comparable)((Object)((SideType)((Object)pState.getValue(EAST)))))).setValue(EAST, (Comparable)((Object)((SideType)((Object)pState.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((SideType)((Object)pState.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((SideType)((Object)pState.getValue(NORTH)))));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue(NORTH, (Comparable)((Object)((SideType)((Object)pState.getValue(WEST)))))).setValue(EAST, (Comparable)((Object)((SideType)((Object)pState.getValue(NORTH)))))).setValue(SOUTH, (Comparable)((Object)((SideType)((Object)pState.getValue(EAST)))))).setValue(WEST, (Comparable)((Object)((SideType)((Object)pState.getValue(SOUTH)))));
            default -> pState;
        };
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return switch (pMirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)pState.setValue(NORTH, (Comparable)((Object)((SideType)((Object)pState.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((SideType)((Object)pState.getValue(NORTH)))));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)pState.setValue(EAST, (Comparable)((Object)((SideType)((Object)pState.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((SideType)((Object)pState.getValue(EAST)))));
            default -> super.mirror(pState, pMirror);
        };
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(true) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public int getLightBlock(BlockState state) {
        if (state.getSoundType() != SoundType.GLASS) {
            return this.isNarrow ? 5 : 15;
        }
        return 1;
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.CHIMNEY;
    }

    public boolean isActive(BlockGetter world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.hasProperty((Property)WATERLOGGED) && (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public Container.Tile createTile(BlockPos pos, BlockState state) {
        return new Container.Tile(pos, state);
    }

    public Class<Container.Tile> getTileClass() {
        return Container.Tile.class;
    }

    public static enum SideType implements IForgeEnum
    {
        NORMAL,
        BRIDGE,
        PORTAL;


        public String toString() {
            return this.getSerializedName();
        }
    }

    public static class Properties<T extends Properties<T>>
    extends Container.Properties<T> {
        boolean isNarrow = false;
        int radius = 8;
        int wallThickness = 2;

        protected Properties(Class<T> selfClass, ResourceKey<Block> blockId) {
            super(selfClass, blockId);
            this.vanillaProps.noOcclusion();
        }

        public static Properties<?> of(ResourceKey<Block> blockId) {
            return new Properties<Properties>(Properties.class, blockId);
        }

        public T narrow(int radius) {
            this.isNarrow = true;
            this.radius = radius;
            return (T)((Object)((Properties)this.self));
        }

        public T wallThickness(int thickness) {
            this.wallThickness = thickness;
            return (T)((Object)((Properties)this.self));
        }
    }
}

