/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.tiles.RepaintableBlockTile;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class Container
extends ForgeBlock
implements ISmokeContainer,
IWaterLoggable {
    public Container(Properties<?> props) {
        super(null, props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return IWaterLoggable.getFluidState((BlockState)state, (boolean)false);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.block();
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return true;
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        return IWaterLoggable.updateFluidPostPlacement((LevelReader)level, (ScheduledTickAccess)tickAccess, (BlockPos)pos, (BlockState)state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return IWaterLoggable.getStateForPlacement((BlockPlaceContext)context, (BlockState)this.defaultBlockState());
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public ColorARGB getColor() {
        return ColorARGB.DEFAULT;
    }

    public static class Tile
    extends RepaintableBlockTile {
        public Tile(BlockPos pos, BlockState state) {
            super((BlockEntityType)AdChimneys.getInstance().tiles.container.get(), pos, state);
        }
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeBlock.Properties<T> {
        protected Properties(Class<T> selfClass, ResourceKey<Block> key) {
            super(selfClass, key);
            this.vanillaProps.randomTicks();
        }

        public static Properties<?> of(ResourceKey<Block> key) {
            return new Properties<Properties>(Properties.class, key);
        }

        public T stone() {
            this.vanillaProps.strength(2.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.STONE);
            return (T)((Object)((Properties)this.self));
        }

        public T metal() {
            this.vanillaProps.strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL);
            return (T)((Object)((Properties)this.self));
        }

        public T glass() {
            this.vanillaProps.strength(0.3f).sound(SoundType.GLASS).noOcclusion().isValidSpawn((s, w, p, a) -> false).isRedstoneConductor((s, w, p) -> false).isSuffocating((s, w, p) -> false).isViewBlocking((s, w, p) -> false);
            return (T)((Object)((Properties)this.self));
        }
    }
}

