/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ITiledBlock;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Vent
extends Container
implements ITiledBlock<Container.Tile> {
    protected static final VoxelShape HOLE_CENTER = Vent.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final VoxelShape HOLES_Z = Shapes.or((VoxelShape)Vent.box((double)3.0, (double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)16.0), (VoxelShape)Vent.box((double)10.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0));
    protected static final VoxelShape HOLES_X = Shapes.or((VoxelShape)Vent.box((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)6.0), (VoxelShape)Vent.box((double)0.0, (double)3.0, (double)10.0, (double)16.0, (double)13.0, (double)13.0));
    protected static final VoxelShape HOLES_BOTTOM = Shapes.or((VoxelShape)Vent.box((double)3.0, (double)0.0, (double)3.0, (double)6.0, (double)3.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Vent.box((double)10.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)6.0), Vent.box((double)3.0, (double)0.0, (double)10.0, (double)6.0, (double)3.0, (double)13.0), Vent.box((double)10.0, (double)0.0, (double)10.0, (double)13.0, (double)3.0, (double)13.0)});
    protected static final VoxelShape SUPPORTS_SIDE = Shapes.or((VoxelShape)Vent.box((double)5.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)16.0), (VoxelShape)Vent.box((double)0.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0));
    protected static final VoxelShape SHAPE;
    protected static final VoxelShape SUPPORT_SHAPE;

    public Vent(Container.Properties<?> props) {
        super(props);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.VENT;
    }

    public boolean isActive(BlockGetter world, BlockPos pos) {
        return !IWaterLoggable.isWaterlogged((BlockState)world.getBlockState(pos));
    }

    public int getLightBlock(BlockState state) {
        return 10;
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return false;
    }

    public Container.Tile createTile(BlockPos pos, BlockState state) {
        return new Container.Tile(pos, state);
    }

    public Class<Container.Tile> getTileClass() {
        return Container.Tile.class;
    }

    static {
        VoxelShape core = Vent.box((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0);
        VoxelShape shape = Shapes.joinUnoptimized((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)HOLE_CENTER, (VoxelShape[])new VoxelShape[]{HOLES_X, HOLES_Z, HOLES_BOTTOM}), (BooleanOp)BooleanOp.ONLY_FIRST);
        SHAPE = Shapes.or((VoxelShape)shape, (VoxelShape)core);
        SUPPORT_SHAPE = Shapes.or((VoxelShape)SHAPE, (VoxelShape)SUPPORTS_SIDE);
    }
}

