/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.data;

import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Chimney;
import com.endertech.minecraft.mods.adchimneys.blocks.Pipe;
import com.endertech.minecraft.mods.adchimneys.blocks.Pump;
import com.endertech.minecraft.mods.adchimneys.blocks.Vent;
import com.endertech.minecraft.mods.adchimneys.data.ModItemTags;
import com.endertech.minecraft.mods.adchimneys.init.Blocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class ModRecipes
extends RecipeProvider {
    public ModRecipes(HolderLookup.Provider lookupProvider, RecipeOutput recipeOutput) {
        super(lookupProvider, recipeOutput);
    }

    protected void buildChimney(Chimney chimney, TagKey<Item> material, int count, RecipeOutput output) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)chimney, count).pattern("M M").pattern("M M").pattern("M M").define(Character.valueOf('M'), material).unlockedBy("has_item", this.has(material)).save(output);
    }

    protected void buildNarrowChimney(Chimney chimney, TagKey<Item> material, int count, RecipeOutput output) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)chimney, count).pattern("MMM").pattern(" M ").pattern(" M ").define(Character.valueOf('M'), material).unlockedBy("has_item", this.has(material)).save(output);
    }

    protected void buildVent(Vent vent, Chimney material, RecipeOutput output) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)vent, 4).pattern("H H").pattern("   ").pattern("H H").define(Character.valueOf('H'), (ItemLike)material).unlockedBy("has_item", this.has((ItemLike)material)).save(output);
    }

    protected void buildPump(Pump pump, Vent material, RecipeOutput output) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)pump, 4).pattern("#R#").pattern("RVR").pattern("#R#").define(Character.valueOf('#'), (ItemLike)material).define(Character.valueOf('R'), (ItemLike)Items.REPEATER).define(Character.valueOf('V'), (ItemLike)Items.HOPPER).unlockedBy("has_item", this.has((ItemLike)material)).save(output);
    }

    protected void buildPipe(Pipe pipe, TagKey<Item> material, int count, RecipeOutput output) {
        this.shaped(RecipeCategory.TRANSPORTATION, (ItemLike)pipe, count).pattern("I I").pattern("I I").pattern("I I").define(Character.valueOf('I'), material).unlockedBy("has_item", this.has(material)).save(output);
    }

    protected void buildRecipes() {
        AdChimneys mod = AdChimneys.getInstance();
        Blocks blocks = mod.blocks;
        this.buildChimney((Chimney)((Object)blocks.cobblestone_chimney.get()), (TagKey<Item>)Tags.Items.COBBLESTONES, 8, this.output);
        this.buildChimney((Chimney)((Object)blocks.stone_chimney.get()), (TagKey<Item>)Tags.Items.STONES, 8, this.output);
        this.buildNarrowChimney((Chimney)((Object)blocks.small_brick_chimney.get()), ModItemTags.SMALL_BRICKS, 8, this.output);
        this.buildChimney((Chimney)((Object)blocks.large_brick_chimney.get()), ModItemTags.LARGE_BRICKS, 8, this.output);
        this.buildNarrowChimney((Chimney)((Object)blocks.metal_chimney.get()), (TagKey<Item>)Tags.Items.INGOTS, 8, this.output);
        this.buildChimney((Chimney)((Object)blocks.glass_chimney.get()), (TagKey<Item>)Tags.Items.GLASS_BLOCKS, 8, this.output);
        this.buildVent((Vent)((Object)blocks.stone_vent.get()), (Chimney)((Object)blocks.stone_chimney.get()), this.output);
        this.buildVent((Vent)((Object)blocks.metal_vent.get()), (Chimney)((Object)blocks.metal_chimney.get()), this.output);
        this.buildPump((Pump)((Object)blocks.stone_pump.get()), (Vent)((Object)blocks.stone_vent.get()), this.output);
        this.buildPump((Pump)((Object)blocks.metal_pump.get()), (Vent)((Object)blocks.metal_vent.get()), this.output);
        this.buildPipe((Pipe)((Object)blocks.pipe.get()), (TagKey<Item>)Tags.Items.INGOTS_IRON, 8, this.output);
    }
}

