/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.mixin;

import com.endertech.minecraft.forge.tiles.RepaintableBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={BrushItem.class})
public abstract class BrushItemMixin
extends Item {
    public BrushItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Redirect(method={"onUseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/BlockHitResult;getBlockPos()Lnet/minecraft/core/BlockPos;", ordinal=0))
    private BlockPos getBlockPos(BlockHitResult hitResult, Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        BlockPos pos = hitResult.getBlockPos();
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            BlockEntity blockEntity = pLevel.getBlockEntity(pos);
            if (blockEntity instanceof RepaintableBlockTile) {
                RepaintableBlockTile tile = (RepaintableBlockTile)blockEntity;
                tile.tryRepaint(player, player.getUsedItemHand());
            }
        }
        return pos;
    }
}

