/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.particles;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AbstractSmokeParticle {

    public static abstract class Instance
    extends TextureSheetParticle {
        private static final int MAX_HIT_AFTER_HIT_AMOUNT = 2;
        private static final double ON_HIT_MOTION_REDICTION = 0.7;
        protected boolean insideChimney = true;
        protected float chimneySize = 0.0f;
        protected int ticksInChimney = 0;
        protected long lastUpdateTime;
        protected final IWind wind;
        protected final SpriteSet animatedSprite;
        private int hitAfterHitCount = 0;

        public Instance(ClientLevel level, IWind wind, Smoke smoke, Vect3d pos, Vect3d motion, float scale, SpriteSet sprite) {
            super(level, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
            this.animatedSprite = sprite;
            this.wind = wind;
            this.setSpriteFromAge(sprite);
            this.hasPhysics = (Boolean)Smoke.canCollide.get();
            this.lastUpdateTime = level.getGameTime();
            WorldData.getData((LevelAccessor)level).getSmokeLocations().countSmokeParticle(this);
        }

        public abstract void updateAnimatedSprite();

        public Vect3d getPosition() {
            return Vect3d.from((double)this.x, (double)this.y, (double)this.z);
        }

        public Vect3d getMotion() {
            return Vect3d.from((double)this.xd, (double)this.yd, (double)this.zd);
        }

        public void setMotion(Vect3d motion) {
            this.xd = motion.x;
            this.yd = motion.y;
            this.zd = motion.z;
        }

        public void setColor(ColorARGB color) {
            this.setColor(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
        }

        public void setPosition(Vect3d pos) {
            this.setPos(pos.x, pos.y, pos.z);
        }

        public BlockPos getBlockPos() {
            return BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        }

        protected void tryColorizeWith(ColorARGB color) {
            if (Smoke.colorize == null || !((Boolean)Smoke.colorize.get()).booleanValue()) {
                return;
            }
            float alpha = color.getAlpha().toFloat();
            if (CommonMath.Random.result((float)(alpha * ((Double)Smoke.coloringFactor.get()).floatValue()))) {
                this.setColor(color);
            }
        }

        public boolean isAlive() {
            return super.isAlive() && Mth.abs((float)(this.level.getGameTime() - this.lastUpdateTime)) <= (float)this.lifetime;
        }

        public void tick() {
            this.lastUpdateTime = this.level.getGameTime();
            ++this.age;
            if (this.age >= this.lifetime) {
                this.remove();
            }
            BlockPos blockPos = this.getBlockPos();
            BlockState state = this.level.getBlockState(blockPos);
            if (GameWorld.SmokeContainers.isChimney((LevelReader)this.level, (BlockPos)blockPos)) {
                VoxelShape shape = state.getCollisionShape((BlockGetter)this.level, blockPos);
                if (!shape.isEmpty()) {
                    Direction[] bb = shape.bounds();
                    this.insideChimney = bb.move(blockPos).contains(this.x, this.y, this.z);
                    this.chimneySize = (float)Math.min(bb.getXsize(), bb.getZsize());
                } else {
                    this.insideChimney = false;
                    this.chimneySize = 1.0f;
                }
            } else {
                this.insideChimney = false;
            }
            if (this.insideChimney && CommonMath.notZero((double)this.yd) && this.yd > 0.0) {
                ++this.ticksInChimney;
                --this.age;
            }
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
            this.updateAnimatedSprite();
            boolean affectedByWind = false;
            if (!this.insideChimney) {
                for (Direction direction : GameWorld.Directions.CLOCKWISE_HORIZONTALS) {
                    if (state.isFaceSturdy((BlockGetter)this.level, blockPos, direction) || !this.level.canSeeSky(blockPos.relative(direction))) continue;
                    affectedByWind = true;
                    break;
                }
            }
            this.yd -= (double)this.gravity;
            Vect3d motion = affectedByWind ? this.getMotion().add(this.wind.getMotion()) : this.getMotion();
            this.move(motion);
        }

        public void move(double dx, double dy, double dz) {
            this.move(Vect3d.from((double)dx, (double)dy, (double)dz));
        }

        public void move(Vect3d motion) {
            Vect3d nextPos = this.getPosition().add(motion);
            this.moveTo(nextPos);
        }

        private void moveTo(Vect3d nextPos) {
            if (this.hasPhysics) {
                if (this.hitAfterHitCount > 2) {
                    this.remove();
                    return;
                }
                Vect3d curPos = this.getPosition();
                BlockPos blockPos = nextPos.toBlockPos();
                if (!blockPos.equals((Object)this.getBlockPos()) && !GameWorld.isBlockLoaded((LevelReader)this.level, (BlockPos)blockPos)) {
                    this.remove();
                    return;
                }
                BlockState blockState = this.level.getBlockState(blockPos);
                BlockHitResult hit = blockState.getCollisionShape((BlockGetter)this.level, blockPos).clip(curPos.toVector3d(), nextPos.toVector3d(), blockPos);
                if (hit != null && !blockState.isFaceSturdy((BlockGetter)this.level, blockPos, hit.getDirection())) {
                    hit = null;
                }
                if (hit != null && hit.getType() != HitResult.Type.MISS) {
                    ++this.hitAfterHitCount;
                    Direction.Axis axis = hit.getDirection().getAxis();
                    Vect3d hitLocation = Vect3d.from((Vec3)hit.getLocation());
                    Vect3d bounceVec = nextPos.subtract(hitLocation);
                    switch (axis) {
                        case X: {
                            bounceVec = bounceVec.invertX();
                            this.xd = -this.xd;
                            break;
                        }
                        case Z: {
                            bounceVec = bounceVec.invertZ();
                            this.zd = -this.zd;
                            break;
                        }
                        case Y: {
                            bounceVec = bounceVec.invertY();
                            CommonMath.Angle angle = CommonMath.Angle.random();
                            double motion = this.yd * this.getOnHitMotionReduction();
                            motion = Math.max(motion, 0.1);
                            this.xd = angle.cos() * motion;
                            this.zd = angle.sin() * motion;
                            this.yd = 0.0;
                            this.hasPhysics = false;
                            this.onGround = true;
                            break;
                        }
                        default: {
                            this.remove();
                            return;
                        }
                    }
                    nextPos = hitLocation.add(bounceVec);
                    this.moveTo(nextPos);
                    return;
                }
            }
            this.hitAfterHitCount = 0;
            this.setPosition(nextPos);
        }

        protected double getOnHitMotionReduction() {
            return 0.7;
        }

        public abstract ParticleRenderType getRenderType();
    }

    public static abstract class Provider<T extends Options>
    implements ParticleProvider<T> {
        protected final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        @Nullable
        public abstract Particle createParticle(T var1, ClientLevel var2, double var3, double var5, double var7, double var9, double var11, double var13);
    }

    public static abstract class Options
    implements ParticleOptions {
        public final IWind wind;
        public final Smoke smoke;

        public Options(IWind wind, Smoke smoke) {
            this.wind = wind;
            this.smoke = smoke;
        }

        public static <T extends Options> ParticleType<T> simpleParticleType(T options) {
            final MapCodec codec = MapCodec.unit(options);
            final StreamCodec streamCodec = StreamCodec.unit(options);
            return new ParticleType<T>(true){

                public MapCodec<T> codec() {
                    return codec;
                }

                public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec() {
                    return streamCodec;
                }
            };
        }
    }
}

