/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.particles;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Chimney;
import com.endertech.minecraft.mods.adchimneys.particles.AbstractSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernSmokeParticle {
    public static void generate(Level level, IWind wind, Smoke smoke, BlockPos pos, float factor) {
        int n;
        BlockState state = level.getBlockState(pos);
        VoxelShape blockShape = state.getCollisionShape((BlockGetter)level, pos);
        AABB blockBB = blockShape.isEmpty() ? Shapes.block().bounds() : blockShape.bounds();
        Block block = state.getBlock();
        if (block instanceof Chimney) {
            Chimney chimney = (Chimney)block;
            n = chimney.wallThickness;
        } else {
            n = 2;
        }
        int wallThickness = n;
        FloatBounds dyBounds = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.6f));
        FloatBounds dxzBounds = FloatBounds.between((Float)Float.valueOf((float)Math.max(blockBB.minX, blockBB.minZ)), (Float)Float.valueOf((float)Math.min(blockBB.maxX, blockBB.maxZ))).reduce(Float.valueOf((float)wallThickness / 16.0f)).reduce(Float.valueOf(smoke.getScale() / 10.0f));
        boolean useVanillaParticles = (Boolean)Smoke.useVanillaParticles.get();
        Object data = useVanillaParticles ? ParticleTypes.CAMPFIRE_COSY_SMOKE : new Options(wind, smoke);
        int smokeAmount = Math.round(smoke.getAmount() * factor);
        double speedY = useVanillaParticles ? 0.07 : 0.0;
        for (int i = 0; i < smokeAmount; ++i) {
            double dx = dxzBounds.randomBetween().floatValue();
            double dy = dyBounds.randomBetween().floatValue();
            double dz = dxzBounds.randomBetween().floatValue();
            Vect3d smokePos = Vect3d.from((BlockPos)pos).move(dx, dy, dz);
            level.addAlwaysVisibleParticle((ParticleOptions)data, true, smokePos.x, smokePos.y, smokePos.z, 0.0, speedY, 0.0);
        }
    }

    public static class Options
    extends AbstractSmokeParticle.Options {
        public Options(IWind wind, Smoke smoke) {
            super(wind, smoke);
        }

        public ParticleType<?> getType() {
            return (ParticleType)AdChimneys.getInstance().particles.modern.get();
        }
    }

    public static class Instance
    extends AbstractSmokeParticle.Instance {
        public Instance(ClientLevel level, IWind wind, Smoke smoke, Vect3d pos, Vect3d motion, float scale, SpriteSet sprite) {
            super(level, wind, smoke, pos, motion, scale, sprite);
            this.lifetime = this.random.nextInt(50) + 80;
            this.scale(1.5f * scale);
            this.setAlpha(0.9f);
            this.setColor(smoke.pickColor());
            this.gravity = 3.0E-6f;
            this.xd = motion.x;
            this.yd = motion.y + (double)(this.random.nextFloat() / 500.0f);
            this.zd = motion.z;
        }

        @Override
        public ParticleRenderType getRenderType() {
            return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
        }

        public float getQuadSize(float partialTicks) {
            if (this.age == 0 && !this.insideChimney) {
                return 0.0f;
            }
            float sizeFactor = this.insideChimney ? this.chimneySize : 1.0f;
            float ageFactor = 4.0f * ((float)this.age + partialTicks) / (float)this.lifetime;
            return Math.max(this.quadSize, this.quadSize * ageFactor) * sizeFactor;
        }

        @Override
        public void tick() {
            super.tick();
            if (!this.insideChimney) {
                this.yd *= 0.99;
            }
            if (this.onGround) {
                ++this.age;
                ++this.age;
            }
        }

        @Override
        public void updateAnimatedSprite() {
            if (this.age == 1) {
                this.pickSprite(this.animatedSprite);
            }
            if (this.age >= this.lifetime - 60 && this.alpha > 0.01f) {
                this.alpha -= 0.015f;
            }
        }
    }

    public static class Provider
    extends AbstractSmokeParticle.Provider<Options> {
        public Provider(SpriteSet sprite) {
            super(sprite);
        }

        @Override
        public Particle createParticle(Options options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            double motionY = (double)options.smoke.getIntensity() / 10.0 * CommonMath.Random.between((double)0.5, (double)1.0);
            motionY = Math.max(motionY, 0.1);
            return new Instance(level, options.wind, options.smoke, Vect3d.from((double)x, (double)y, (double)z), Vect3d.from((double)0.0, (double)motionY, (double)0.0), options.smoke.getScale(), this.sprite);
        }
    }
}

