/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.minecraft.forge.events.ChunkDataLoadedEvent;
import com.endertech.minecraft.forge.events.ChunkFullyLoadedEvent;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="adchimneys")
public class Events {
    @SubscribeEvent
    public static void onBlockChanged(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor level = event.getLevel();
        if (GameWorld.isServerSide((LevelReader)level)) {
            WorldData.getData(level).getSmokeLocations().updateSmokeSourceAt(event.getPos());
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkFullyLoadedEvent event) {
        WorldData data = WorldData.getData((LevelAccessor)event.getLevel());
        data.getSmokeLocations().updateSmokeSourcesIn((ChunkAccess)event.getChunk());
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            WorldData data = WorldData.getData((LevelAccessor)level);
            data.getSmokeLocations().removeAllSmokeSourcesIn(event.getChunk());
        }
    }

    public static void onChunkDataLoaded(ChunkDataEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            WorldData data = WorldData.getData((LevelAccessor)level);
            data.getSmokeLocations().readSmokeSourceLocationsFrom(event.getChunk().getPos(), event.getData().structureData());
        }
    }

    @SubscribeEvent
    public static void onChunkDataLoaded(ChunkDataLoadedEvent event) {
        ServerLevel serverLevel = event.getLevel();
        if (serverLevel instanceof ServerLevel) {
            ServerLevel level = serverLevel;
            WorldData data = WorldData.getData((LevelAccessor)level);
            data.getSmokeLocations().readSmokeSourceLocationsFrom(event.getChunkPos(), event.getData());
        }
    }

    @SubscribeEvent
    public static void onChunkDataSaved(ChunkDataEvent.Save event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            WorldData data = WorldData.getData((LevelAccessor)level);
            data.getSmokeLocations().writeSmokeSourceLocationsTo(event.getChunk(), event.getData().structureData());
        }
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        SmokeLocations smokeLocations = WorldData.getData((LevelAccessor)level).getSmokeLocations();
        if (level.isClientSide()) {
            smokeLocations.onClientTick();
        } else {
            smokeLocations.onServerTick();
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor level = event.getLevel();
        WorldData.DATA_MAP.remove(level);
    }
}

