/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.disenchanting_table.core.world.block;

import common.com.cursee.disenchanting_table.DisEnchantingTable;
import common.com.cursee.disenchanting_table.DisEnchantingTableClient;
import common.com.cursee.disenchanting_table.core.registry.ModBlockEntities;
import common.com.cursee.disenchanting_table.core.world.block.entity.DisEnchantingTableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DisEnchantingTableBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public DisEnchantingTableBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ENCHANTING_TABLE).setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)DisEnchantingTable.identifier("disenchanting_table"))));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return DisEnchantingTableBlock.interact(level, pos, player);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return DisEnchantingTableBlock.interact(level, pos, player);
    }

    protected static InteractionResult interact(Level level, BlockPos pos, Player player) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)blockEntity;
            player.openMenu(menuProvider);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new DisEnchantingTableBlockEntity(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return null;
        }
        return DisEnchantingTableBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlockEntities.DISENCHANTING_TABLE.get(), DisEnchantingTableBlockEntity::tick);
    }

    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!DisEnchantingTableClient.render_block_particles) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            int xMod = random.nextInt(2) * 2 - 1;
            int zMod = random.nextInt(2) * 2 - 1;
            double xPos = (double)pos.getX() + 0.5 + 0.25 * (double)xMod;
            double yPos = (float)pos.getY() + random.nextFloat();
            double zPos = (double)pos.getZ() + 0.5 + 0.25 * (double)zMod;
            double xSpeed = random.nextFloat() * (float)xMod;
            double ySpeed = ((double)random.nextFloat() - 0.5) * 0.125;
            double zSpeed = random.nextFloat() * (float)zMod;
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed);
        }
    }
}

