/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.disenchanting_table;

import com.cursee.moandjiezana.toml.Toml;
import fabric.com.cursee.disenchanting_table.Constants;
import fabric.com.cursee.disenchanting_table.DisEnchantingTable;
import fabric.com.cursee.disenchanting_table.client.gui.screens.DisEnchantingMenuScreen;
import fabric.com.cursee.disenchanting_table.client.gui.screens.DisEnchantingTableScreen;
import fabric.com.cursee.disenchanting_table.client.renderer.blockentity.DisEnchantingTableRenderer;
import fabric.com.cursee.disenchanting_table.core.registry.ModBlockEntities;
import fabric.com.cursee.disenchanting_table.core.registry.ModMenus;
import fabric.com.cursee.disenchanting_table.platform.Services;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.class_2591;
import net.minecraft.class_3917;

public class DisEnchantingTableClient {
    public static boolean render_block_particles = true;
    public static boolean render_experience_cost = true;
    public static boolean render_table_item = true;

    public static void init() {
        DisEnchantingTableClient.createOrLoadConfiguration();
        if (!Services.PLATFORM.getPlatformName().equalsIgnoreCase("neoforge")) {
            Services.PLATFORM.registerBlockEntityRenderer((class_2591)ModBlockEntities.DISENCHANTING_TABLE.get(), DisEnchantingTableRenderer::new);
            Services.PLATFORM.registerMenuScreen((class_3917)ModMenus.DISENCHANTING_MENU.get(), DisEnchantingMenuScreen::new);
            Services.PLATFORM.registerMenuScreen((class_3917)ModMenus.DISENCHANTING_TABLE.get(), DisEnchantingTableScreen::new);
        }
    }

    public static void createOrLoadConfiguration() {
        String configFilename;
        String configFileString;
        File configFile;
        String configDirectoryString = Services.PLATFORM.getGameDirectory() + File.separator + "config";
        File configDirectory = new File(configDirectoryString);
        if (!configDirectory.exists() && !configDirectory.mkdirs()) {
            Constants.LOG.info("Insufficient privileges to create directory {}", (Object)configDirectoryString);
            DisEnchantingTableClient.retainsDefaultsMessage();
        }
        if (!(configFile = new File(configFileString = configDirectoryString + File.separator + (configFilename = "disenchanting_table-client.toml"))).exists()) {
            InputStream ioStream = DisEnchantingTable.class.getClassLoader().getResourceAsStream("assets/" + configFilename);
            if (ioStream == null) {
                Constants.LOG.info("Unable to get resource from self {}", (Object)configFilename);
                DisEnchantingTableClient.retainsDefaultsMessage();
            }
            try (InputStream inputStream = ioStream;
                 BufferedInputStream bis = new BufferedInputStream(inputStream);
                 BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(configFile));){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = bis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                Constants.LOG.info("Failed to copy default config file, error: {}", (Object)e.getMessage());
                DisEnchantingTableClient.retainsDefaultsMessage();
            }
        } else {
            Toml toml = new Toml().read(configFile);
            render_block_particles = toml.getBoolean("render_block_particles", Boolean.valueOf(render_block_particles));
            render_experience_cost = toml.getBoolean("render_experience_cost", Boolean.valueOf(render_experience_cost));
            render_table_item = toml.getBoolean("render_table_item", Boolean.valueOf(render_table_item));
        }
    }

    public static void retainsDefaultsMessage() {
        Constants.LOG.info("Configuration will retain default values.");
    }
}

