/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.disenchanting_table.core.world.block.entity.function;

import fabric.com.cursee.disenchanting_table.DisEnchantingTableServer;
import fabric.com.cursee.disenchanting_table.core.util.DisEnchantingHelper;
import fabric.com.cursee.disenchanting_table.core.util.ExperienceHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class DisEnchantingStrategy {
    public static final int INPUT_SLOT = 0;
    public static final int EXTRA_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    public static final int SLOT_COUNT = 3;
    public static final int PROGRESS_DATA_SLOT = 0;
    public static final int DATA_SLOT_COUNT = 1;

    public static boolean canAcceptInput(int slot, class_1799 stack) {
        return slot == 0 && DisEnchantingHelper.canDisenchant(stack);
    }

    public static boolean canAcceptExtra(int slot, class_1799 stack) {
        return slot == 1 && stack.method_31574(class_1802.field_8529);
    }

    public static boolean canOutputToHopper(int slot, class_1799 stack) {
        return slot == 0 && !DisEnchantingHelper.canDisenchant(stack) || slot == 2;
    }

    public static boolean automaticModeEnabled() {
        return DisEnchantingTableServer.automatic_disenchanting;
    }

    public static int automaticModeTime() {
        return DisEnchantingTableServer.automatic_disenchanting_ticks;
    }

    public static boolean requiresExperience() {
        return DisEnchantingTableServer.requires_experience;
    }

    public static boolean usesPoints() {
        return DisEnchantingTableServer.uses_points;
    }

    public static int experienceCost() {
        return DisEnchantingTableServer.experience_cost;
    }

    public static boolean resetsRepairCost() {
        return DisEnchantingTableServer.resets_repair_cost;
    }

    public static boolean hasEnoughExperience(class_1657 player) {
        if (!DisEnchantingStrategy.requiresExperience()) {
            return true;
        }
        if (player.method_31549().field_7477) {
            return true;
        }
        if (player.method_68878()) {
            return true;
        }
        if (DisEnchantingStrategy.usesPoints()) {
            return ExperienceHelper.hasEnoughExperiencePoints(player, DisEnchantingStrategy.experienceCost());
        }
        return ExperienceHelper.hasEnoughExperienceLevels(player, DisEnchantingStrategy.experienceCost());
    }
}

