/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.disenchanting_table.core.world.block.entity.util;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public abstract class ModBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();

    public ModBlockEntity(BlockEntityType<? extends BlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract void writePacketData(ValueOutput var1);

    public abstract void readPacketData(ValueInput var1);

    protected void saveAdditional(ValueOutput output) {
        this.writePacketData(output);
        super.saveAdditional(output);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.readPacketData(input);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag;
        try (ProblemReporter.ScopedCollector collector = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)collector, (HolderLookup.Provider)registries);
            this.writePacketData((ValueOutput)output);
            tag = output.buildResult();
        }
        return tag;
    }
}

